/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.util.intervals;

import com.hp.hpl.guess.util.intervals.IntervalNode;
import com.hp.hpl.guess.util.intervals.RBTree;
import java.util.Vector;

public class IntervalTree
extends RBTree {
    public static void main(String[] args) {
        int i;
        IntervalTree foo = new IntervalTree();
        foo.insert(new IntervalNode(7, 11));
        foo.insert(new IntervalNode(12, 13));
        foo.insert(new IntervalNode(5, 10));
        foo.insert(new IntervalNode(10, 14));
        foo.insert(new IntervalNode(4, 10));
        foo.insert(new IntervalNode(6, 14));
        foo.insert(new IntervalNode(3, 8));
        foo.insert(new IntervalNode(3, 8));
        IntervalNode test = new IntervalNode(1, 11);
        foo.insert(test);
        foo.insert(new IntervalNode(2, 13));
        foo.insert(new IntervalNode(8, 9));
        foo.inOrderWalk(foo.root, "");
        IntervalNode[] retr = foo.searchOverlap(2, 6);
        System.out.println("\noverlap 2-6 found:");
        for (i = 0; i < retr.length; ++i) {
            System.out.println(retr[i]);
        }
        retr = foo.searchContains(2, 10);
        System.out.println("\ncontains 2-10 found:");
        for (i = 0; i < retr.length; ++i) {
            System.out.println(retr[i]);
        }
        retr = foo.searchContained(8, 11);
        System.out.println("\ncontained in 8-11 found:");
        for (i = 0; i < retr.length; ++i) {
            System.out.println(retr[i]);
        }
        retr = foo.searchExact(6, 14);
        System.out.println("\nexact match for 6-14 found:");
        for (i = 0; i < retr.length; ++i) {
            System.out.println(retr[i]);
        }
        foo.delete(test);
        System.out.println("");
        foo.inOrderWalk(foo.root, "");
    }

    public IntervalNode[] searchOverlap(int low, int high) {
        IntervalNode x = this.root;
        Vector toReturn = new Vector();
        this.searchOverlap(low, high, this.root, toReturn);
        Object[] returnIntervalNodes = new IntervalNode[toReturn.size()];
        toReturn.copyInto(returnIntervalNodes);
        return returnIntervalNodes;
    }

    private void searchOverlap(int low, int high, IntervalNode x, Vector v) {
        if (x != IntervalNode.nullIntervalNode) {
            if (x.overlaps(low, high)) {
                v.addElement(x);
            }
            if (x.getLeft() != IntervalNode.nullIntervalNode && x.getLeft().getMax() >= low) {
                this.searchOverlap(low, high, x.getLeft(), v);
            }
            if (x.getRight() != IntervalNode.nullIntervalNode && x.getRight().getMin() <= high) {
                this.searchOverlap(low, high, x.getRight(), v);
            }
        }
    }

    public IntervalNode[] searchContains(int low, int high) {
        IntervalNode x = this.root;
        Vector toReturn = new Vector();
        this.searchContains(low, high, this.root, toReturn);
        if (toReturn.size() == 0) {
            return new IntervalNode[0];
        }
        Object[] returnIntervalNodes = new IntervalNode[toReturn.size()];
        toReturn.copyInto(returnIntervalNodes);
        return returnIntervalNodes;
    }

    private void searchContains(int low, int high, IntervalNode x, Vector v) {
        if (x != IntervalNode.nullIntervalNode) {
            if (x.contains(low, high)) {
                v.addElement(x);
            }
            if (x.getLeft() != IntervalNode.nullIntervalNode && x.getLeft().getMax() >= low) {
                this.searchContains(low, high, x.getLeft(), v);
            }
            if (x.getRight() != IntervalNode.nullIntervalNode && x.getRight().getMin() <= high) {
                this.searchContains(low, high, x.getRight(), v);
            }
        }
    }

    public IntervalNode[] searchContained(int low, int high) {
        IntervalNode x = this.root;
        Vector toReturn = new Vector();
        this.searchContained(low, high, this.root, toReturn);
        Object[] returnIntervalNodes = new IntervalNode[toReturn.size()];
        toReturn.copyInto(returnIntervalNodes);
        return returnIntervalNodes;
    }

    private void searchContained(int low, int high, IntervalNode x, Vector v) {
        if (x != IntervalNode.nullIntervalNode) {
            if (x.isContained(low, high)) {
                v.addElement(x);
            }
            if (x.getLeft() != IntervalNode.nullIntervalNode && x.getLeft().getMax() >= low) {
                this.searchContained(low, high, x.getLeft(), v);
            }
            if (x.getRight() != IntervalNode.nullIntervalNode && x.getRight().getMin() <= high) {
                this.searchContained(low, high, x.getRight(), v);
            }
        }
    }

    public IntervalNode[] searchExact(int low, int high) {
        IntervalNode x = this.root;
        Vector toReturn = new Vector();
        this.searchExact(low, high, this.root, toReturn);
        Object[] returnIntervalNodes = new IntervalNode[toReturn.size()];
        toReturn.copyInto(returnIntervalNodes);
        return returnIntervalNodes;
    }

    private void searchExact(int low, int high, IntervalNode x, Vector v) {
        if (x != IntervalNode.nullIntervalNode) {
            if (x.exactMatch(low, high)) {
                v.addElement(x);
            }
            if (x.getLeft() != IntervalNode.nullIntervalNode && x.getLeft().getMax() >= low) {
                this.searchExact(low, high, x.getLeft(), v);
            }
            if (x.getRight() != IntervalNode.nullIntervalNode && x.getRight().getMin() <= high) {
                this.searchExact(low, high, x.getRight(), v);
            }
        }
    }
}

