/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.util.intervals;

import com.hp.hpl.guess.util.intervals.IntervalNode;
import com.hp.hpl.guess.util.intervals.Tree;

public class RBTree
extends Tree {
    private final void leftRotate(IntervalNode x) {
        if (x.getRight() == IntervalNode.nullIntervalNode) {
            return;
        }
        IntervalNode y = x.getRight();
        x.setRight(y.getLeft());
        if (y.getLeft() != IntervalNode.nullIntervalNode) {
            y.getLeft().setP(x);
        }
        y.setP(x.getP());
        if (x.getP() == IntervalNode.nullIntervalNode) {
            this.root = y;
        } else if (x == x.getP().getLeft()) {
            x.getP().setLeft(y);
        } else {
            x.getP().setRight(y);
        }
        y.setLeft(x);
        x.setP(y);
    }

    private final void rightRotate(IntervalNode x) {
        if (x.getLeft() == IntervalNode.nullIntervalNode) {
            return;
        }
        IntervalNode y = x.getLeft();
        x.setLeft(y.getRight());
        if (y.getRight() != IntervalNode.nullIntervalNode) {
            y.getRight().setP(x);
        }
        y.setP(x.getP());
        if (x.getP() == IntervalNode.nullIntervalNode) {
            this.root = y;
        } else if (x == x.getP().getRight()) {
            x.getP().setRight(y);
        } else {
            x.getP().setLeft(y);
        }
        y.setRight(x);
        x.setP(y);
    }

    @Override
    public void insert(IntervalNode x) {
        super.insert(x);
        x.color = false;
        while (x != this.root && !x.getP().color) {
            IntervalNode y;
            if (x.getP() == x.getP().getP().getLeft()) {
                y = x.getP().getP().getRight();
                if (!y.color) {
                    x.getP().color = true;
                    y.color = true;
                    x.getP().getP().color = false;
                    x = x.getP().getP();
                    continue;
                }
                if (x == x.getP().getRight()) {
                    x = x.getP();
                    this.leftRotate(x);
                }
                x.getP().color = true;
                x.getP().getP().color = false;
                this.rightRotate(x.getP().getP());
                continue;
            }
            y = x.getP().getP().getLeft();
            if (!y.color) {
                x.getP().color = true;
                y.color = true;
                x.getP().getP().color = false;
                x = x.getP().getP();
                continue;
            }
            if (x == x.getP().getLeft()) {
                x = x.getP();
                this.rightRotate(x);
            }
            x.getP().color = true;
            x.getP().getP().color = false;
            this.leftRotate(x.getP().getP());
        }
        this.root.color = true;
    }

    @Override
    public IntervalNode delete(IntervalNode z) {
        IntervalNode y = z.getLeft() == IntervalNode.nullIntervalNode || z.getRight() == IntervalNode.nullIntervalNode ? z : super.successor(z);
        IntervalNode x = y.getLeft() != IntervalNode.nullIntervalNode ? y.getLeft() : y.getRight();
        x.setP(y.getP());
        if (y.getP() == IntervalNode.nullIntervalNode) {
            this.root = x;
        } else if (y == y.getP().getLeft()) {
            y.getP().setLeft(x);
        } else {
            y.getP().setRight(x);
        }
        if (y != z) {
            z.low = y.low;
        }
        y.color = true;
        if (true) {
            this.deleteFixup(x);
        }
        return y;
    }

    private final void deleteFixup(IntervalNode x) {
        while (x != IntervalNode.nullIntervalNode && x.color) {
            IntervalNode w;
            if (x == x.getP().getLeft()) {
                w = x.getP().getRight();
                if (!w.color) {
                    w.color = true;
                    x.getP().color = false;
                    this.leftRotate(x.getP());
                }
                if (w.getLeft().color && w.getRight().color) {
                    w.color = false;
                    x = x.getP();
                    continue;
                }
                if (w.getRight().color) {
                    w.getLeft().color = true;
                    w.color = false;
                    this.rightRotate(w);
                    w = x.getP().getRight();
                }
                w.color = x.getP().color;
                x.getP().color = true;
                w.getRight().color = true;
                this.leftRotate(x.getP());
                x = this.root;
                continue;
            }
            w = x.getP().getLeft();
            if (!w.color) {
                w.color = true;
                x.getP().color = false;
                this.leftRotate(x.getP());
            }
            if (w.getRight().color && w.getLeft().color) {
                w.color = false;
                x = x.getP();
                continue;
            }
            if (w.getLeft().color) {
                w.getRight().color = true;
                w.color = false;
                this.rightRotate(w);
                w = x.getP().getLeft();
            }
            w.color = x.getP().color;
            x.getP().color = true;
            w.getLeft().color = true;
            this.leftRotate(x.getP());
            x = this.root;
        }
        x.color = true;
    }
}

