/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.util.intervals;

import com.hp.hpl.guess.util.intervals.IntervalNode;
import com.hp.hpl.guess.util.intervals.IntervalTree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RangeManager {
    private IntervalTree itree = new IntervalTree();

    public List parseRange(String range) {
        ArrayList<HiLow> toRet = new ArrayList<HiLow>();
        String[] ranges = range.split(",");
        for (int i = 0; i < ranges.length; ++i) {
            try {
                String temp = ranges[i].trim();
                String[] hilo = temp.split("\\s*-\\s*");
                int hi = 0;
                int lo = 0;
                if (hilo.length == 1) {
                    lo = Integer.parseInt(hilo[0]);
                    hi = Integer.parseInt(hilo[0]);
                    toRet.add(new HiLow(lo, hi));
                    continue;
                }
                if (hilo.length == 2) {
                    lo = Integer.parseInt(hilo[0]);
                    hi = Integer.parseInt(hilo[1]);
                    toRet.add(new HiLow(lo, hi));
                    continue;
                }
                throw new Error("Invalid range: " + temp + "in '" + range + "'");
            }
            catch (Exception ex) {
                throw new Error("Invalid range '" + range + "' " + ex.toString());
            }
        }
        return toRet;
    }

    public Collection searchOverlap(String range) {
        List t = this.parseRange(range);
        Iterator it = t.iterator();
        HashSet<Object> toRet = new HashSet<Object>();
        while (it.hasNext()) {
            HiLow chi = (HiLow)it.next();
            IntervalNode[] res = this.itree.searchOverlap(chi.low, chi.hi);
            for (int i = 0; i < res.length; ++i) {
                if (res[i].getProxy() == null) continue;
                toRet.add(res[i].getProxy());
            }
        }
        return toRet;
    }

    public Collection searchContains(String range) {
        List t = this.parseRange(range);
        Iterator it = t.iterator();
        HashSet<Object> toRet = new HashSet<Object>();
        while (it.hasNext()) {
            HiLow chi = (HiLow)it.next();
            IntervalNode[] res = this.itree.searchContains(chi.low, chi.hi);
            for (int i = 0; i < res.length; ++i) {
                if (res[i].getProxy() == null) continue;
                toRet.add(res[i].getProxy());
            }
        }
        return toRet;
    }

    public Collection searchContained(String range) {
        List t = this.parseRange(range);
        Iterator it = t.iterator();
        HashSet<Object> toRet = new HashSet<Object>();
        while (it.hasNext()) {
            HiLow chi = (HiLow)it.next();
            IntervalNode[] res = this.itree.searchContained(chi.low, chi.hi);
            for (int i = 0; i < res.length; ++i) {
                if (res[i].getProxy() == null) continue;
                toRet.add(res[i].getProxy());
            }
        }
        return toRet;
    }

    public Collection searchExact(String range) {
        List t = this.parseRange(range);
        Iterator it = t.iterator();
        HashSet<Object> toRet = new HashSet<Object>();
        while (it.hasNext()) {
            HiLow chi = (HiLow)it.next();
            IntervalNode[] res = this.itree.searchExact(chi.low, chi.hi);
            for (int i = 0; i < res.length; ++i) {
                if (res[i].getProxy() == null) continue;
                toRet.add(res[i].getProxy());
            }
        }
        return toRet;
    }

    public void addRange(Object o, String range) {
        List t = this.parseRange(range);
        for (HiLow chi : t) {
            IntervalNode inode = new IntervalNode(chi.low, chi.hi, o);
            this.itree.insert(inode);
        }
    }

    class HiLow {
        public int hi = 0;
        public int low = 0;

        public HiLow(int low, int hi) {
            this.hi = hi;
            this.low = low;
        }
    }
}

