/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.guess.util.intervals;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.EdgeEditorPopup;
import com.hp.hpl.guess.ui.EditorPopup;
import com.hp.hpl.guess.ui.GraphElementEditorPopup;
import com.hp.hpl.guess.ui.Interesting;
import com.hp.hpl.guess.ui.NodeEditorPopup;
import com.hp.hpl.guess.ui.ThrowableEditorPopup;
import com.hp.hpl.guess.util.intervals.IntervalNode;
import com.hp.hpl.guess.util.intervals.IntervalTree;
import com.hp.hpl.guess.util.intervals.TextPaneIntervalNode;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.text.DefaultStyledDocument;
import org.python.core.PyInstance;
import org.python.core.PySequence;
import org.python.core.PyString;

public abstract class Tracker {
    private static IntervalTree itree = new IntervalTree();
    private static int location = 0;
    public static boolean enabled = true;
    private static DefaultStyledDocument doc = null;
    private static HashSet hs = new HashSet();

    public static void setDocument(DefaultStyledDocument d) {
        doc = d;
    }

    public static void moveToDocEnd() {
        if (doc != null) {
            Tracker.setLocation(doc.getLength());
        }
    }

    public EditorPopup getMenu(Object o) {
        if (o instanceof PyInstance) {
            if (((PyInstance)o).isNodeProxy()) {
                return NodeEditorPopup.getPopup();
            }
            if (((PyInstance)o).isEdgeProxy()) {
                return EdgeEditorPopup.getPopup();
            }
            if (((PyInstance)o).isTypeOfInterest()) {
                Interesting inte = (Interesting)((PyInstance)o).__tojava__(Interesting.class);
                return inte.getPopup();
            }
        } else {
            if (o instanceof PyString) {
                return null;
            }
            if (o instanceof PySequence) {
                Iterator it = ((PySequence)o).findGraphElements().iterator();
                boolean nd = false;
                boolean ed = false;
                while (it.hasNext()) {
                    Object o2 = it.next();
                    if (o2 instanceof Node) {
                        nd = true;
                        continue;
                    }
                    if (!(o2 instanceof Edge)) continue;
                    ed = true;
                }
                if (nd && ed) {
                    return GraphElementEditorPopup.getPopup();
                }
                if (nd) {
                    return NodeEditorPopup.getPopup();
                }
                if (ed) {
                    return EdgeEditorPopup.getPopup();
                }
                return null;
            }
            if (o instanceof Throwable) {
                return ThrowableEditorPopup.getPopup();
            }
        }
        return null;
    }

    public static String generateStatusString(Object o) {
        if (o instanceof PyInstance) {
            o = ((PyInstance)o).__tojava__(Object.class);
        }
        if (o instanceof Interesting) {
            return ((Interesting)o).getStatusBarString();
        }
        return "";
    }

    public static void disableTracker() {
        enabled = false;
        itree = null;
        hs.clear();
    }

    public static void setLocation(int newloc) {
        location = newloc;
    }

    public static void incrementLocation(int incr) {
        location += incr;
    }

    public static IntervalNode[] searchOverlap(int low, int high) {
        if (!enabled) {
            return new IntervalNode[0];
        }
        return itree.searchOverlap(low, high);
    }

    public static IntervalNode[] searchContains(int low, int high) {
        if (!enabled) {
            return new IntervalNode[0];
        }
        return itree.searchContains(low, high);
    }

    public static IntervalNode[] searchContained(int low, int high) {
        if (!enabled) {
            return new IntervalNode[0];
        }
        return itree.searchContained(low, high);
    }

    public static IntervalNode[] searchExact(int low, int high) {
        if (!enabled) {
            return new IntervalNode[0];
        }
        return itree.searchExact(low, high);
    }

    public static HashSet getRecentNodes() {
        return hs;
    }

    public static TextPaneIntervalNode addNode(int length, Object o) {
        if (!enabled) {
            return null;
        }
        TextPaneIntervalNode inode = new TextPaneIntervalNode(location, location + length, o);
        hs.add(inode);
        itree.insert(inode);
        return inode;
    }

    public static TextPaneIntervalNode addNode(int start, int length, Object o) {
        if (!enabled) {
            return null;
        }
        TextPaneIntervalNode inode = new TextPaneIntervalNode(start, start + length, o);
        hs.add(inode);
        itree.insert(inode);
        return inode;
    }

    public static int getLocation() {
        return location;
    }

    public static IntervalTree getIntervalTree() {
        return itree;
    }

    public static void testWalk() {
        if (!enabled) {
            return;
        }
        itree.inOrderWalk(Tracker.itree.root, "");
        System.out.println(Tracker.itree.root.getMin() + " " + Tracker.itree.root.getMax());
        IntervalNode test = itree.treeMin(Tracker.itree.root);
        System.out.println(test.getMin());
        test = itree.treeMax(Tracker.itree.root);
        System.out.println(test.getMax());
    }
}

