/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.ConnectionFunc;
import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.PyExtendedCursor;
import com.ziclix.python.sql.zxJDBC;
import java.sql.Connection;
import java.sql.SQLException;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyConnection
extends PyObject
implements ClassDictInit {
    protected Connection connection;
    protected boolean supportsTransactions;
    public static PyClass __class__;
    protected static PyList __members__;
    protected static PyList __methods__;

    @Override
    protected PyClass getPyClass() {
        return __class__;
    }

    public PyConnection(Connection connection) throws SQLException {
        this.connection = connection;
        this.supportsTransactions = this.connection.getMetaData().supportsTransactions();
        if (this.supportsTransactions) {
            this.connection.setAutoCommit(false);
        }
    }

    public String toString() {
        try {
            return "<PyConnection user='" + this.connection.getMetaData().getUserName() + "', url='" + this.connection.getMetaData().getURL() + "'>";
        }
        catch (SQLException e) {
            return "<PyConnection at " + this.hashCode() + ">";
        }
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("autocommit", (PyObject)new PyInteger(0));
        dict.__setitem__("__version__", Py.newString("$Revision: 1.1 $").__getslice__(Py.newInteger(11), Py.newInteger(-2), null));
        dict.__setitem__("close", (PyObject)new ConnectionFunc("close", 0, 0, 0, zxJDBC.getString("close")));
        dict.__setitem__("commit", (PyObject)new ConnectionFunc("commit", 1, 0, 0, zxJDBC.getString("commit")));
        dict.__setitem__("cursor", (PyObject)new ConnectionFunc("cursor", 2, 0, 1, zxJDBC.getString("cursor")));
        dict.__setitem__("rollback", (PyObject)new ConnectionFunc("rollback", 3, 0, 0, zxJDBC.getString("rollback")));
        dict.__setitem__("nativesql", (PyObject)new ConnectionFunc("nativesql", 4, 1, 1, zxJDBC.getString("nativesql")));
        dict.__setitem__("initModule", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("setConnection", null);
        dict.__setitem__("getPyClass", null);
        dict.__setitem__("connection", null);
        dict.__setitem__("classDictInit", null);
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        if ("autocommit".equals(name)) {
            try {
                if (this.supportsTransactions) {
                    this.connection.setAutoCommit(value.__nonzero__());
                }
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e.getMessage());
            }
            return;
        }
        super.__setattr__(name, value);
    }

    @Override
    public PyObject __findattr__(String name) {
        if ("autocommit".equals(name)) {
            try {
                return this.connection.getAutoCommit() ? Py.One : Py.Zero;
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e.getMessage());
            }
        }
        if ("dbname".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getDatabaseProductName());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e.getMessage());
            }
        }
        if ("dbversion".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getDatabaseProductVersion());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e.getMessage());
            }
        }
        if ("driverversion".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getDriverVersion());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e.getMessage());
            }
        }
        if ("url".equals(name)) {
            try {
                return Py.newString(this.connection.getMetaData().getURL());
            }
            catch (SQLException e) {
                throw zxJDBC.makeException(zxJDBC.DatabaseError, e.getMessage());
            }
        }
        if ("__connection__".equals(name)) {
            return Py.java2py(this.connection);
        }
        if ("__methods__".equals(name)) {
            return __methods__;
        }
        if ("__members__".equals(name)) {
            return __members__;
        }
        return super.__findattr__(name);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            throw zxJDBC.newError(e);
        }
    }

    public void commit() {
        if (!this.supportsTransactions) {
            return;
        }
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw zxJDBC.newError(e);
        }
    }

    public void rollback() {
        if (!this.supportsTransactions) {
            return;
        }
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw zxJDBC.newError(e);
        }
    }

    public PyObject nativesql(PyObject nativeSQL) {
        if (nativeSQL == Py.None) {
            return Py.None;
        }
        try {
            return Py.newString(this.connection.nativeSQL(nativeSQL.__str__().toString()));
        }
        catch (SQLException e) {
            throw zxJDBC.newError(e);
        }
    }

    public PyCursor cursor() {
        return new PyExtendedCursor(this);
    }

    public PyCursor cursor(boolean dynamicFetch) {
        return new PyExtendedCursor(this, dynamicFetch);
    }

    static {
        PyObject[] m = new PyObject[]{new PyString("close"), new PyString("commit"), new PyString("cursor"), new PyString("rollback"), new PyString("nativesql")};
        __methods__ = new PyList(m);
        m = new PyObject[]{new PyString("autocommit"), new PyString("dbname"), new PyString("dbversion"), new PyString("driverversion"), new PyString("url"), new PyString("__connection__")};
        __members__ = new PyList(m);
    }
}

