/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.CursorFunc;
import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.JDBC20DataHandler;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyConnection;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyCursor
extends PyObject
implements ClassDictInit {
    protected Fetch fetch;
    protected int arraysize = 1;
    protected PyObject warnings;
    protected PyObject lastrowid;
    protected PyObject updatecount;
    protected boolean dynamicFetch;
    protected PyConnection connection;
    protected DataHandler datahandler;
    protected Statement sqlStatement;
    private static DataHandler DATAHANDLER = null;
    public static PyClass __class__;
    protected static PyList __methods__;
    protected static PyList __members__;

    PyCursor(PyConnection connection) {
        this(connection, false);
    }

    PyCursor(PyConnection connection, boolean dynamicFetch) {
        this.connection = connection;
        this.datahandler = DATAHANDLER;
        this.dynamicFetch = dynamicFetch;
        this.clear();
    }

    @Override
    protected PyClass getPyClass() {
        return __class__;
    }

    public String toString() {
        return "<PyCursor object instance at " + this.hashCode() + ">";
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        if ("arraysize".equals(name)) {
            this.arraysize = value.__int__().getValue();
        } else if ("datahandler".equals(name)) {
            this.datahandler = (DataHandler)value.__tojava__(DataHandler.class);
        } else {
            super.__setattr__(name, value);
        }
    }

    @Override
    public PyObject __findattr__(String name) {
        if ("arraysize".equals(name)) {
            return Py.newInteger(this.arraysize);
        }
        if ("__methods__".equals(name)) {
            return __methods__;
        }
        if ("__members__".equals(name)) {
            return __members__;
        }
        if ("description".equals(name)) {
            return this.fetch.getDescription();
        }
        if ("rowcount".equals(name)) {
            return Py.newInteger(this.fetch.getRowCount());
        }
        if ("warnings".equals(name)) {
            return this.warnings;
        }
        if ("lastrowid".equals(name)) {
            return this.lastrowid;
        }
        if ("updatecount".equals(name)) {
            return this.updatecount;
        }
        if ("datahandler".equals(name)) {
            return Py.java2py(this.datahandler);
        }
        if ("dynamic".equals(name)) {
            return this.dynamicFetch ? Py.One : Py.Zero;
        }
        if ("connection".equals(name)) {
            return this.connection;
        }
        return super.__findattr__(name);
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__version__", Py.newString("$Revision: 1.1 $").__getslice__(Py.newInteger(11), Py.newInteger(-2), null));
        dict.__setitem__("fetchmany", (PyObject)new CursorFunc("fetchmany", 0, 1, 2, "fetch specified number of rows"));
        dict.__setitem__("close", (PyObject)new CursorFunc("close", 1, 1, "close the cursor"));
        dict.__setitem__("fetchall", (PyObject)new CursorFunc("fetchall", 2, 1, "fetch all results"));
        dict.__setitem__("fetchone", (PyObject)new CursorFunc("fetchone", 3, 1, "fetch the next result"));
        dict.__setitem__("nextset", (PyObject)new CursorFunc("nextset", 4, 1, "return next set or None"));
        dict.__setitem__("execute", (PyObject)new CursorFunc("execute", 5, 1, 4, "execute the sql expression"));
        dict.__setitem__("setinputsizes", (PyObject)new CursorFunc("setinputsizes", 6, 1, "not implemented"));
        dict.__setitem__("setoutputsize", (PyObject)new CursorFunc("setoutputsize", 7, 1, 2, "not implemented"));
        dict.__setitem__("callproc", (PyObject)new CursorFunc("callproc", 8, 1, 4, "executes a stored procedure"));
        dict.__setitem__("executemany", (PyObject)new CursorFunc("executemany", 9, 1, 3, "execute sql with the parameter list"));
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("getDataHandler", null);
        dict.__setitem__("addWarning", null);
        dict.__setitem__("fetch", null);
        dict.__setitem__("newFetch", null);
        dict.__setitem__("sqlStatement", null);
        dict.__setitem__("dynamicFetch", null);
        dict.__setitem__("getPyClass", null);
    }

    public void __del__() {
        this.close();
    }

    public void close() {
        this.clear();
    }

    protected DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.connection.getMetaData();
    }

    public DataHandler getDataHandler() {
        return this.datahandler;
    }

    protected void newFetch() {
        this.fetch = this.dynamicFetch ? Fetch.newDynamicFetch(this) : Fetch.newStaticFetch(this);
    }

    protected void prepareStatement(String sqlString, PyObject maxRows, boolean prepared) throws SQLException {
        this.sqlStatement = prepared ? this.connection.connection.prepareStatement(sqlString) : this.connection.connection.createStatement();
        if (maxRows != Py.None) {
            this.sqlStatement.setMaxRows(maxRows.__int__().getValue());
        }
    }

    public void callproc(PyObject name, final PyObject params, PyObject bindings, PyObject maxRows) {
        this.clear();
        try {
            PyDictionary callableBindings;
            Procedure procedure;
            if (this.getMetaData().supportsStoredProcedures()) {
                if (this.isSeqSeq(params)) {
                    throw zxJDBC.makeException(zxJDBC.NotSupportedError, "sequence of sequences is not supported");
                }
                procedure = new Procedure(this, name);
                callableBindings = new PyDictionary();
                this.sqlStatement = procedure.prepareCall();
                if (maxRows != Py.None) {
                    this.sqlStatement.setMaxRows(maxRows.__int__().getValue());
                }
                procedure.normalizeInput(params, callableBindings);
                if (bindings instanceof PyDictionary) {
                    callableBindings.update((PyDictionary)bindings);
                }
            } else {
                throw zxJDBC.makeException(zxJDBC.NotSupportedError, zxJDBC.getString("noStoredProc"));
            }
            this.prepare(params, callableBindings, procedure);
            this.execute(new ExecuteSQL(){

                @Override
                public void executeSQL() throws SQLException {
                    CallableStatement callableStatement = (CallableStatement)PyCursor.this.sqlStatement;
                    if (callableStatement.execute()) {
                        PyCursor.this.fetch.add(callableStatement.getResultSet());
                    }
                    PyCursor.this.fetch.add(callableStatement, procedure, params);
                }
            });
        }
        catch (PyException e) {
            throw e;
        }
        catch (Exception e) {
            throw zxJDBC.newError(e);
        }
    }

    public void executemany(String sqlString, PyObject params, PyObject bindings, PyObject maxRows) {
        this.execute(sqlString, params, bindings, maxRows);
    }

    public void execute(final String sqlString, PyObject params, PyObject bindings, PyObject maxRows) {
        this.clear();
        boolean hasParams = this.hasParams(params);
        try {
            this.prepareStatement(sqlString, maxRows, hasParams);
            if (hasParams) {
                ExecuteSQL esql = new ExecuteSQL(){

                    @Override
                    public void executeSQL() throws SQLException {
                        if (((PreparedStatement)PyCursor.this.sqlStatement).execute()) {
                            PyCursor.this.fetch.add(PyCursor.this.sqlStatement.getResultSet());
                        }
                    }
                };
                if (this.isSeqSeq(params)) {
                    int len = params.__len__();
                    for (int i = 0; i < len; ++i) {
                        PyObject param = params.__getitem__(i);
                        this.prepare(param, bindings, null);
                        this.execute(esql);
                    }
                } else {
                    this.prepare(params, bindings, null);
                    this.execute(esql);
                }
            } else {
                this.execute(new ExecuteSQL(){

                    @Override
                    public void executeSQL() throws SQLException {
                        if (PyCursor.this.sqlStatement.execute(sqlString)) {
                            PyCursor.this.fetch.add(PyCursor.this.sqlStatement.getResultSet());
                        }
                    }
                });
            }
        }
        catch (PyException e) {
            throw e;
        }
        catch (Exception e) {
            throw zxJDBC.newError(e);
        }
    }

    protected void execute(ExecuteSQL execute) throws SQLException {
        this.datahandler.preExecute(this.sqlStatement);
        execute.executeSQL();
        this.lastrowid = this.datahandler.getRowId(this.sqlStatement);
        this.updatecount = Py.newInteger(this.sqlStatement.getUpdateCount());
        this.addWarning(this.sqlStatement.getWarnings());
        this.datahandler.postExecute(this.sqlStatement);
    }

    protected void prepare(PyObject params, PyObject bindings, Procedure procedure) throws SQLException {
        if (params == Py.None) {
            return;
        }
        PreparedStatement preparedStatement = (PreparedStatement)this.sqlStatement;
        int columns = 0;
        int column = 0;
        int index = params.__len__();
        if (procedure == null) {
            columns = params.__len__();
            preparedStatement.clearParameters();
        } else {
            int n = columns = procedure.columns == Py.None ? 0 : procedure.columns.__len__();
        }
        while (columns-- > 0) {
            PyObject binding;
            column = columns + 1;
            if (procedure != null && !procedure.isInput(column)) continue;
            PyObject param = params.__getitem__(--index);
            if (bindings != Py.None && (binding = bindings.__finditem__(Py.newInteger(index))) != null) {
                try {
                    int bindingValue = binding.__int__().getValue();
                    this.datahandler.setJDBCObject(preparedStatement, column, param, bindingValue);
                    continue;
                }
                catch (PyException e) {
                    throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("bindingValue"));
                }
            }
            this.datahandler.setJDBCObject(preparedStatement, column, param);
        }
    }

    public PyObject fetchone() {
        return this.fetch.fetchone();
    }

    public PyObject fetchall() {
        return this.fetch.fetchall();
    }

    public PyObject fetchmany(int size) {
        return this.fetch.fetchmany(size);
    }

    public PyObject nextset() {
        return this.fetch.nextset();
    }

    protected void addWarning(SQLWarning warning) {
        if (warning == null) {
            return;
        }
        if (this.warnings == Py.None) {
            this.warnings = new PyList();
        }
        PyTuple warn = new PyTuple();
        warn.__add__(Py.java2py(warning.getMessage()));
        warn.__add__(Py.java2py(warning.getSQLState()));
        warn.__add__(Py.newInteger(warning.getErrorCode()));
        ((PyList)this.warnings).append(warn);
        SQLWarning next = warning.getNextWarning();
        if (next != null) {
            this.addWarning(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this.warnings = Py.None;
        this.lastrowid = Py.None;
        this.updatecount = Py.newInteger(-1);
        try {
            this.fetch.close();
        }
        catch (Exception e) {
        }
        finally {
            this.newFetch();
        }
        try {
            this.sqlStatement.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.sqlStatement = null;
        }
    }

    protected boolean isSeq(PyObject object) {
        if (object == null || object == Py.None) {
            return false;
        }
        if (object.__tojava__(List.class) != Py.NoConversion) {
            return true;
        }
        return object instanceof PyList || object instanceof PyTuple;
    }

    protected boolean hasParams(PyObject params) {
        if (Py.None == params) {
            return false;
        }
        boolean isSeq = this.isSeq(params);
        if (!isSeq) {
            throw zxJDBC.makeException(zxJDBC.ProgrammingError, zxJDBC.getString("optionalSecond"));
        }
        return params.__len__() > 0;
    }

    protected boolean isSeqSeq(PyObject object) {
        if (this.isSeq(object) && object.__len__() > 0) {
            for (int i = 0; i < object.__len__(); ++i) {
                if (this.isSeq(object.__finditem__(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        DATAHANDLER = new DataHandler();
        try {
            DATAHANDLER = new JDBC20DataHandler(DATAHANDLER);
        }
        catch (Throwable t) {
            // empty catch block
        }
        PyObject[] m = new PyObject[]{new PyString("close"), new PyString("execute"), new PyString("executemany"), new PyString("fetchone"), new PyString("fetchall"), new PyString("fetchmany"), new PyString("callproc")};
        __methods__ = new PyList(m);
        m = new PyObject[]{new PyString("arraysize"), new PyString("rowcount"), new PyString("description"), new PyString("datahandler"), new PyString("warnings"), new PyString("lastrowid"), new PyString("updatecount")};
        __members__ = new PyList(m);
    }

    private static interface ExecuteSQL {
        public void executeSQL() throws SQLException;
    }
}

