/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.Fetch;
import com.ziclix.python.sql.Procedure;
import com.ziclix.python.sql.PyCursor;
import com.ziclix.python.sql.zxJDBC;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyList;
import org.python.core.PyObject;

class StaticFetch
extends Fetch {
    protected int counter = -1;
    protected List results = new LinkedList();
    protected List descriptions = new LinkedList();

    public StaticFetch(PyCursor cursor) {
        super(cursor);
    }

    @Override
    public void add(ResultSet resultSet) {
        this.add(resultSet, null);
    }

    @Override
    public void add(ResultSet resultSet, Set skipCols) {
        try {
            if (resultSet != null && resultSet.getMetaData() != null) {
                PyObject metadata = this.createDescription(resultSet.getMetaData());
                PyList result = this.createResults(resultSet, skipCols, metadata);
                this.results.add(result);
                this.descriptions.add(metadata);
                this.rowcount = ((PyObject)this.results.get(0)).__len__();
                this.description = (PyObject)this.descriptions.get(0);
            }
        }
        catch (PyException e) {
            throw e;
        }
        catch (Exception e) {
            throw zxJDBC.newError(e);
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void add(CallableStatement callableStatement, Procedure procedure, PyObject params) {
        try {
            PyObject result = this.createResults(callableStatement, procedure, params);
            if (result != Py.None) {
                this.results.add(result);
                this.descriptions.add(this.createDescription(procedure));
                this.description = (PyObject)this.descriptions.get(0);
                this.rowcount = ((PyObject)this.results.get(0)).__len__();
            }
        }
        catch (PyException e) {
            throw e;
        }
        catch (Exception e) {
            throw zxJDBC.newError(e);
        }
    }

    @Override
    public PyObject fetchall() {
        return this.fetchmany(this.rowcount);
    }

    @Override
    public PyObject fetchmany(int size) {
        PyObject res = Py.None;
        PyObject current = Py.None;
        if (this.results == null || this.results.size() <= 0) {
            return current;
        }
        current = (PyObject)this.results.get(0);
        if (size <= 0) {
            size = this.rowcount;
        }
        if (this.counter + 1 < this.rowcount) {
            int start = this.counter + 1;
            this.counter += size;
            res = current.__getslice__(Py.newInteger(start), Py.newInteger(this.counter + 1), Py.newInteger(1));
        }
        return res;
    }

    @Override
    public PyObject nextset() {
        PyObject next = Py.None;
        if (this.results != null && this.results.size() > 1) {
            this.results.remove(0);
            this.descriptions.remove(0);
            next = (PyObject)this.results.get(0);
            this.description = (PyObject)this.descriptions.get(0);
            this.rowcount = next.__len__();
            this.counter = -1;
        }
        return next == Py.None ? Py.None : Py.One;
    }

    @Override
    public void close() throws SQLException {
        this.counter = -1;
        this.results.clear();
    }
}

