/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import java.util.HashSet;
import java.util.Stack;
import java.util.Vector;

public class BFSIterator {
    private Graph g = null;
    private Vector queue = new Stack();
    private HashSet visited = new HashSet();
    private int location = -1;

    public BFSIterator(Vertex start, Graph g) {
        this.g = g;
        this.visited.add(start);
        this.queue.add(start);
    }

    public boolean hasNext() {
        return this.queue.elementAt(this.location + 1) != null;
    }

    public Vertex next() {
        ++this.location;
        Vertex v = (Vertex)this.queue.elementAt(this.location);
        if (v == null) {
            return null;
        }
        for (Vertex su : v.getSuccessors()) {
            if (this.visited.contains(su)) continue;
            this.visited.add(su);
            this.queue.add(su);
        }
        return v;
    }
}

