/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import java.util.HashSet;
import java.util.Stack;

public class DFSIterator {
    private Graph g = null;
    private Stack queue = new Stack();
    private HashSet visited = new HashSet();

    public DFSIterator(Vertex start, Graph g) {
        this.g = g;
        this.visited.add(start);
        this.queue.push(start);
    }

    public boolean hasNext() {
        return this.queue.peek() != null;
    }

    public Vertex next() {
        Vertex v = (Vertex)this.queue.pop();
        if (v == null) {
            return null;
        }
        for (Vertex su : v.getSuccessors()) {
            if (this.visited.contains(su)) continue;
            this.visited.add(su);
            this.queue.push(su);
        }
        return v;
    }
}

