/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.ClusterSet;
import edu.uci.ics.jung.algorithms.cluster.KMeansClusterer;
import edu.uci.ics.jung.algorithms.cluster.VoltageClusterer;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.VoltageRanker;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.ConstantEdgeValue;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.graph.decorators.NumberVertexValue;
import edu.uci.ics.jung.graph.decorators.UserDatumNumberVertexValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class VoltageClustererL
extends VoltageClusterer {
    private int volt_rank_iterations;
    private double volt_rank_convergence;
    private NumberEdgeValue e_weight_map = new ConstantEdgeValue(1.0);

    public void setEdgeWeight(NumberEdgeValue edge_weights) {
        this.e_weight_map = edge_weights;
        this.vr = new VoltageRanker(edge_weights, (NumberVertexValue)this.vv, this.volt_rank_iterations, this.volt_rank_convergence);
    }

    public VoltageClustererL(int num_candidates, int rank_iterations, double rank_convergence) {
        super(num_candidates, rank_iterations, rank_convergence, 100, 0.01);
        this.volt_rank_iterations = rank_iterations;
        this.volt_rank_convergence = rank_convergence;
    }

    public Collection getCommunity(ArchetypeGraph g, ArchetypeVertex v) {
        return this.cluster_internal(g, v, 1, -1, this.num_candidates);
    }

    public Collection getCommunity(ArchetypeGraph g, ArchetypeVertex v, int communitysize) {
        return this.cluster_internal(g, v, 1, communitysize, this.num_candidates);
    }

    public Collection cluster(ArchetypeGraph g, int num_clusters) {
        return this.cluster_internal(g, null, num_clusters, -1, this.num_candidates);
    }

    protected Collection cluster_internal(ArchetypeGraph g, ArchetypeVertex origin, int num_clusters, int communitysize, int num_candidates) {
        int maxclustsize;
        int minclustsize;
        Set weakcomponent;
        int i;
        WeakComponentClusterer wcc = new WeakComponentClusterer();
        ClusterSet wcs = wcc.extract((ArchetypeGraph)((Graph)g));
        wcs.sort();
        Graph gg = wcs.getClusterAsNewSubGraph(0);
        LinkedList<Collection> clusters = new LinkedList<Collection>();
        HashSet remaining = new HashSet(g.getVertices());
        if (origin != null) {
            if (!wcs.getCluster(0).contains(origin)) {
                for (i = 1; i < wcs.size(); ++i) {
                    weakcomponent = wcs.getCluster(i);
                    if (!weakcomponent.contains(origin)) continue;
                    if ((double)weakcomponent.size() <= (double)communitysize * 0.5 || weakcomponent.size() <= 6) {
                        clusters.add(weakcomponent);
                        Set allvertices = g.getVertices();
                        LinkedList<ArchetypeVertex> allothervertices = new LinkedList<ArchetypeVertex>();
                        for (ArchetypeVertex othervertex : allvertices) {
                            if (weakcomponent.contains(othervertex)) continue;
                            allothervertices.add(othervertex);
                        }
                        clusters.add(allothervertices);
                        return clusters;
                    }
                    gg = wcs.getClusterAsNewSubGraph(i);
                }
            }
        } else {
            for (i = 1; i < wcs.size(); ++i) {
                weakcomponent = wcs.getCluster(i);
                if (weakcomponent.size() >= g.numVertices() / num_clusters / 2 && weakcomponent.size() <= g.numVertices() / num_clusters * 2) {
                    clusters.add(weakcomponent);
                    remaining.removeAll(weakcomponent);
                    continue;
                }
                if (weakcomponent.size() <= g.numVertices() / num_clusters) continue;
                Graph mysubgraph = wcs.getClusterAsNewSubGraph(i);
                int numclustersforsubgraph = (int)Math.floor((double)wcs.size() / (double)g.numVertices() * (double)num_clusters);
                int numcandidatesforsubgraph = (int)Math.ceil((double)wcs.size() / (double)g.numVertices() * (double)num_candidates);
                if (numcandidatesforsubgraph < 20) {
                    numcandidatesforsubgraph = 20;
                }
                Collection weakclusters = this.cluster_internal((ArchetypeGraph)mysubgraph, null, numclustersforsubgraph, 0, numcandidatesforsubgraph);
                Iterator iter = weakclusters.iterator();
                while (iter.hasNext()) {
                    Collection clustertoadd = (Collection)iter.next();
                    if (!iter.hasNext() && weakclusters.size() != 1) continue;
                    clusters.add(clustertoadd);
                    remaining.removeAll(clustertoadd);
                }
            }
        }
        Set vertices = gg.getVertices();
        int num_vertices = vertices.size();
        ArchetypeVertex[] v = new ArchetypeVertex[num_vertices];
        int i2 = 0;
        int j = 0;
        Iterator iter = vertices.iterator();
        while (iter.hasNext()) {
            v[i2++] = (ArchetypeVertex)iter.next();
        }
        if (origin == null) {
            minclustsize = (int)((double)num_vertices / (double)num_clusters * 0.5);
            maxclustsize = (int)((double)num_vertices / (double)num_clusters * 2.0);
        } else if (communitysize < 3 || communitysize >= g.numVertices()) {
            minclustsize = 3;
            maxclustsize = (int)((double)num_vertices / 2.0);
        } else {
            minclustsize = (int)((double)communitysize * 0.5);
            maxclustsize = (int)((double)communitysize * 2.0);
        }
        if (minclustsize < 3) {
            minclustsize = 3;
        }
        if ((double)maxclustsize >= (double)num_vertices * 0.75) {
            maxclustsize = (int)((double)num_vertices * 0.75);
        }
        System.out.println("minclustsize = " + minclustsize + " maxclustsize " + maxclustsize);
        final UserDatumNumberVertexValue lVV = this.vv;
        ArchetypeVertex[] voltage_ranks = new ArchetypeVertex[vertices.size()];
        LinkedList candidates = new LinkedList();
        int num_samples = origin != null ? 20 : num_candidates;
        for (int nc = 0; nc < num_samples; ++nc) {
            ArchetypeVertex source = null;
            source = origin == null ? v[(int)(Math.random() * (double)num_vertices)] : origin;
            ArchetypeVertex target = null;
            while (source == (target = v[(int)(Math.random() * (double)num_vertices)])) {
            }
            this.calculateVoltagesL((ArchetypeGraph)gg, (Vertex)source, (Vertex)target, this.volt_rank_iterations, this.volt_rank_convergence);
            int numverticesadded = 0;
            Iterator iter2 = vertices.iterator();
            while (iter2.hasNext()) {
                ArchetypeVertex archetypeVertex;
                voltage_ranks[numverticesadded] = archetypeVertex = (ArchetypeVertex)iter2.next();
                ++numverticesadded;
            }
            Arrays.sort(voltage_ranks, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    double voltage2;
                    ArchetypeVertex w1 = (ArchetypeVertex)arg0;
                    ArchetypeVertex w2 = (ArchetypeVertex)arg1;
                    double voltage1 = lVV.getNumber(w1).doubleValue();
                    if (voltage1 < (voltage2 = lVV.getNumber(w2).doubleValue())) {
                        return -1;
                    }
                    if (voltage1 > voltage2) {
                        return 1;
                    }
                    return 0;
                }
            });
            ArchetypeVertex[] sortedVoltageArray = new ArchetypeVertex[voltage_ranks.length];
            sortedVoltageArray = voltage_ranks;
            try {
                double voltage2;
                double voltage1;
                ArchetypeVertex w2;
                ArchetypeVertex w1;
                HashMap lowclust = new HashMap();
                HashMap hashMap = new HashMap();
                j = 0;
                for (j = 0; j < minclustsize; ++j) {
                    lowclust.put(sortedVoltageArray[j], null);
                }
                double d = 0.0;
                int cutpoint = minclustsize;
                for (j = minclustsize; j < maxclustsize; ++j) {
                    w1 = sortedVoltageArray[j - 1];
                    w2 = sortedVoltageArray[j];
                    voltage1 = this.vv.getNumber(w1).doubleValue();
                    voltage2 = this.vv.getNumber(w2).doubleValue();
                    if (!(voltage2 - voltage1 > d)) continue;
                    d = voltage2 - voltage1;
                    cutpoint = j - 1;
                }
                for (j = minclustsize; j <= cutpoint; ++j) {
                    w1 = sortedVoltageArray[j];
                    lowclust.put(w1, null);
                }
                for (j = sortedVoltageArray.length - 1; j >= sortedVoltageArray.length - minclustsize; --j) {
                    hashMap.put(sortedVoltageArray[j], null);
                }
                d = 0.0;
                cutpoint = sortedVoltageArray.length - maxclustsize;
                for (j = sortedVoltageArray.length - minclustsize; j >= sortedVoltageArray.length - maxclustsize && j > 0; --j) {
                    w1 = sortedVoltageArray[j - 1];
                    w2 = sortedVoltageArray[j];
                    voltage1 = this.vv.getNumber(w1).doubleValue();
                    voltage2 = this.vv.getNumber(w2).doubleValue();
                    if (!(voltage2 - voltage1 > d)) continue;
                    d = voltage2 - voltage1;
                    cutpoint = j;
                }
                for (j = sortedVoltageArray.length - minclustsize - 1; j >= cutpoint; --j) {
                    w1 = sortedVoltageArray[j];
                    hashMap.put(w1, null);
                }
                candidates.add(lowclust.keySet());
                candidates.add(hashMap.keySet());
                continue;
            }
            catch (KMeansClusterer.NotEnoughClustersException e) {
                // empty catch block
            }
        }
        LinkedList<Object> reserveseeds = new LinkedList<Object>();
        Object[] seed_candidates = origin == null ? this.getSeedCandidates(candidates) : new Object[]{origin};
        for (j = 0; j < seed_candidates.length && !remaining.isEmpty(); ++j) {
            Object seed = seed_candidates[j];
            if (!remaining.contains(seed)) continue;
            int numcandforseed = 0;
            for (Collection collection : candidates) {
                if (!collection.contains(seed)) continue;
                ++numcandforseed;
            }
            Map occur_counts = this.getObjectCounts(candidates, seed);
            if (occur_counts.size() < 2) continue;
            try {
                LinkedList linkedList = new LinkedList();
                Set set = occur_counts.keySet();
                for (Object k : set) {
                    double[] dArray = (double[])occur_counts.get(k);
                    if (!(dArray[0] >= Math.floor(numcandforseed / 2))) continue;
                    linkedList.add(k);
                }
                if (linkedList.size() >= minclustsize) {
                    for (Collection collection : candidates) {
                        collection.removeAll(linkedList);
                    }
                    clusters.add(linkedList);
                    remaining.removeAll(linkedList);
                } else {
                    reserveseeds.add(seed);
                }
                if (clusters.size() < num_clusters * 2) continue;
            }
            catch (KMeansClusterer.NotEnoughClustersException notEnoughClustersException) {}
            break;
        }
        if (remaining.size() >= 3 && clusters.size() < num_clusters * 2) {
            Iterator iter2 = reserveseeds.iterator();
            while (iter2.hasNext() && !remaining.isEmpty()) {
                ArchetypeVertex reserveseed = (ArchetypeVertex)iter2.next();
                if (!remaining.contains(reserveseed)) continue;
                int numcandforseed = 0;
                for (Collection collection : candidates) {
                    if (!collection.contains(reserveseed)) continue;
                    ++numcandforseed;
                }
                Map map = this.getObjectCounts(candidates, reserveseed);
                if (map.size() < 2) continue;
                try {
                    LinkedList linkedList = new LinkedList();
                    Set occur_countsset = map.keySet();
                    for (Object k : occur_countsset) {
                        double[] ovalue = (double[])map.get(k);
                        if (!(ovalue[0] >= Math.floor(numcandforseed / 2))) continue;
                        linkedList.add(k);
                    }
                    if (linkedList.size() >= 3) {
                        for (Collection collection : candidates) {
                            collection.removeAll(linkedList);
                        }
                        clusters.add(linkedList);
                        remaining.removeAll(linkedList);
                    }
                    if (clusters.size() < num_clusters * 2) continue;
                }
                catch (KMeansClusterer.NotEnoughClustersException notEnoughClustersException) {}
                break;
            }
        }
        if (!remaining.isEmpty()) {
            clusters.add(remaining);
        }
        return clusters;
    }

    protected Object[] getSeedCandidates(Collection candidates) {
        final Map occur_counts = this.getObjectCounts(candidates, null);
        Object[] occurrences = occur_counts.keySet().toArray();
        Arrays.sort(occurrences, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                double[] count1;
                double[] count0 = (double[])occur_counts.get(arg0);
                if (count0[0] < (count1 = (double[])occur_counts.get(arg1))[0]) {
                    return 1;
                }
                if (count0[0] > count1[0]) {
                    return -1;
                }
                return 0;
            }
        });
        return occurrences;
    }

    protected Map getObjectCounts(Collection candidates, Object seed) {
        HashMap occur_counts = new HashMap();
        for (Collection candidate : candidates) {
            if (seed != null && !candidate.contains(seed)) continue;
            for (Object element : candidate) {
                double[] count = (double[])occur_counts.get(element);
                if (count == null) {
                    count = new double[]{1.0};
                    occur_counts.put(element, count);
                    continue;
                }
                count[0] = count[0] + 1.0;
            }
        }
        return occur_counts;
    }

    public void calculateVoltagesL(ArchetypeGraph g, Vertex source, Vertex sink, int rank_iterations, double rank_threshold) {
        Indexer id = Indexer.getIndexer((ArchetypeGraph)g);
        Set vertices = g.getVertices();
        double[] volt_array = new double[vertices.size()];
        for (int i = 0; i < volt_array.length; ++i) {
            Double voltage;
            Vertex v = (Vertex)id.getVertex(i);
            if (v.equals(source)) {
                voltage = new Double(1.0);
                volt_array[i] = voltage;
                this.vv.setNumber((ArchetypeVertex)v, (Number)voltage);
                continue;
            }
            if (v.equals(sink)) {
                voltage = new Double(0.0);
                volt_array[i] = voltage;
                this.vv.setNumber((ArchetypeVertex)v, (Number)voltage);
                continue;
            }
            volt_array[i] = 0.5;
            this.vv.setNumber((ArchetypeVertex)v, (Number)new Double(0.5));
        }
        int iteration = 0;
        double max_change = Double.POSITIVE_INFINITY;
        while (iteration++ < rank_iterations && max_change > rank_threshold) {
            max_change = 0.0;
            for (Vertex v : vertices) {
                if (source.equals(v) || sink.equals(v)) continue;
                Set edges = v.getInEdges();
                double voltage_sum = 0.0;
                double weight_sum = 0.0;
                for (Edge e : edges) {
                    Vertex w = e.getOpposite(v);
                    voltage_sum += volt_array[id.getIndex((ArchetypeVertex)w)];
                    weight_sum += 1.0;
                }
                double new_voltage = voltage_sum == 0.0 && weight_sum == 0.0 ? 0.0 : voltage_sum / weight_sum;
                max_change = Math.max(max_change, Math.abs(this.vv.getNumber((ArchetypeVertex)v).doubleValue() - new_voltage));
                this.vv.setNumber((ArchetypeVertex)v, (Number)new Double(new_voltage));
            }
            for (int i = 0; i < volt_array.length; ++i) {
                volt_array[i] = this.vv.getNumber(id.getVertex(i)).doubleValue();
            }
        }
    }
}

