/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import edu.uci.ics.jung.algorithms.transformation.DirectionTransformer;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class EadesGreedyDAG {
    public static void removeLoopsAndTwoCycles(DirectedGraph graph) {
        HashSet<DirectedEdge> toRemove = new HashSet<DirectedEdge>();
        for (DirectedEdge de : graph.getEdges()) {
            if (de.getSource() != de.getDest()) continue;
            toRemove.add(de);
        }
        for (Vertex v1 : graph.getVertices()) {
            for (Vertex v2 : v1.getSuccessors()) {
                if (!v1.isSuccessorOf(v2) || !v1.isPredecessorOf(v2)) continue;
                toRemove.addAll(v1.findEdgeSet(v2));
                toRemove.addAll(v2.findEdgeSet(v1));
            }
        }
        for (DirectedEdge de : toRemove) {
            graph.removeEdge((Edge)de);
        }
    }

    public static Vertex findSink(DirectedGraph graph) {
        for (Vertex v : graph.getVertices()) {
            if (v.outDegree() != 0) continue;
            return v;
        }
        return null;
    }

    public static Vertex findSource(DirectedGraph graph) {
        for (Vertex v : graph.getVertices()) {
            if (v.inDegree() != 0) continue;
            return v;
        }
        return null;
    }

    public static Graph eadesGreedyDAG(Graph graphO) {
        return EadesGreedyDAG.eadesGreedyDAG(graphO, true);
    }

    public static Graph eadesGreedyDAG(Graph graphO, boolean copy) {
        graphO = DirectionTransformer.toDirected((Graph)graphO, (boolean)copy);
        LinkedList<Object> s1 = new LinkedList<Object>();
        LinkedList<Vertex> s2 = new LinkedList<Vertex>();
        DirectedGraph graph = DirectionTransformer.toDirected((Graph)graphO);
        HashMap<Vertex, ArchetypeVertex> oToN = new HashMap<Vertex, ArchetypeVertex>();
        for (Vertex v2 : graphO.getVertices()) {
            oToN.put(v2, v2.getEqualVertex((ArchetypeGraph)graph));
        }
        while (graph.getVertices().size() > 0) {
            Vertex v2;
            v2 = EadesGreedyDAG.findSink(graph);
            while (v2 != null) {
                s2.addFirst(v2);
                graph.removeVertex(v2);
                v2 = EadesGreedyDAG.findSink(graph);
            }
            v2 = EadesGreedyDAG.findSource(graph);
            while (v2 != null) {
                s1.addLast(v2);
                graph.removeVertex(v2);
                v2 = EadesGreedyDAG.findSource(graph);
            }
            int max = Integer.MIN_VALUE;
            Vertex mVert = null;
            for (Vertex v2 : graph.getVertices()) {
                if (v2.outDegree() - v2.inDegree() <= max) continue;
                max = v2.outDegree() - v2.inDegree();
                mVert = v2;
            }
            if (mVert == null) continue;
            s1.addLast(mVert);
            graph.removeVertex(mVert);
        }
        s1.addAll(s2);
        HashMap<Vertex, Integer> hm = new HashMap<Vertex, Integer>();
        Iterator it = s1.iterator();
        int i = 0;
        while (it.hasNext()) {
            Vertex v = (Vertex)it.next();
            hm.put(v, new Integer(i));
            ++i;
        }
        it = s1.iterator();
        i = 0;
        while (it.hasNext()) {
            Vertex vN = (Vertex)it.next();
            Vertex vO = (Vertex)vN.getEqualVertex((ArchetypeGraph)graphO);
            for (DirectedEdge e : vO.getOutEdges()) {
                Vertex succO = e.getDest();
                Vertex succN = (Vertex)oToN.get(succO);
                int loc = (Integer)hm.get(succN);
                if (loc >= i) continue;
                graphO.removeEdge((Edge)e);
                if (succO.isPredecessorOf(vO)) continue;
                graphO.addEdge((Edge)new DirectedSparseEdge(succO, vO));
            }
            ++i;
        }
        return graphO;
    }
}

