/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.contrib;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.jung.NEVMap;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.Coordinates;
import java.awt.Dimension;

public class WeightedKK
extends AbstractLayout {
    private double EPSILON = 0.1;
    private int currentIteration;
    private int maxIterations = 2000;
    private String status = "KKLayout";
    private double L;
    private double K = 1.0;
    private DoubleMatrix2D dm;
    private boolean adjustForGravity = true;
    private boolean exchangeVertices = true;
    private Vertex[] vertices;
    private Coordinates[] xydata;
    private Graph g = null;
    protected DijkstraShortestPath dsp = null;
    protected double diameter;

    public WeightedKK(Graph g) {
        super(g);
        this.g = g;
    }

    public String getStatus() {
        return this.status + this.getCurrentSize();
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public boolean isIncremental() {
        return true;
    }

    public boolean incrementsAreDone() {
        return this.currentIteration > this.maxIterations;
    }

    protected void initialize_local() {
    }

    protected void initializeLocations() {
        super.initializeLocations();
        Dimension d = this.getCurrentSize();
        double height = d.getHeight();
        double width = d.getWidth();
        int n = this.getVisibleVertices().size();
        this.dm = new DenseDoubleMatrix2D(n, n);
        this.vertices = new Vertex[n];
        this.xydata = new Coordinates[n];
        this.dsp = new DijkstraShortestPath((ArchetypeGraph)this.g, (NumberEdgeValue)new NEVMap(Guess.getGraph().getEdgeSchema().getField("weight")));
        int index = 0;
        for (Vertex v : this.getVisibleVertices()) {
            Coordinates xyd = this.getCoordinates((ArchetypeVertex)v);
            this.vertices[index] = v;
            this.xydata[index] = xyd;
            ++index;
        }
        this.diameter = 0.0;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                Number dist = this.dsp.getDistance((ArchetypeVertex)this.vertices[i], (ArchetypeVertex)this.vertices[j]);
                if (dist == null || !((double)dist.intValue() > this.diameter)) continue;
                this.diameter = dist.intValue();
            }
        }
        double L0 = height > width ? width : height;
        this.L = L0 / this.diameter * 0.9;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double dist = this.getDistance(this.vertices[i], this.vertices[j]);
                this.dm.setQuick(i, j, dist);
                this.dm.setQuick(j, i, dist);
            }
        }
    }

    protected double getDistance(Vertex v1, Vertex v2) {
        Number n = this.dsp.getDistance((ArchetypeVertex)v1, (ArchetypeVertex)v2);
        if (n == null) {
            return this.diameter + 1.0;
        }
        return n.intValue();
    }

    protected void initialize_local_vertex(Vertex v) {
    }

    public void advancePositions() {
        int i;
        ++this.currentIteration;
        double energy = this.calcEnergy();
        this.status = "Kamada-Kawai V=" + this.getVisibleVertices().size() + "(" + this.getGraph().numVertices() + ")" + " IT: " + this.currentIteration + " E=" + energy;
        int n = this.getVisibleGraph().numVertices();
        if (n == 0) {
            return;
        }
        double maxDeltaM = 0.0;
        int pm = -1;
        for (i = 0; i < n; ++i) {
            double deltam;
            if (this.dontMove(this.vertices[i]) || !(maxDeltaM < (deltam = this.calcDeltaM(i)))) continue;
            maxDeltaM = deltam;
            pm = i;
        }
        if (pm == -1) {
            return;
        }
        for (i = 0; i < 100; ++i) {
            double[] dxy = this.calcDeltaXY(pm);
            this.xydata[pm].add(dxy[0], dxy[1]);
            double deltam = this.calcDeltaM(pm);
            if (deltam < this.EPSILON) break;
        }
        if (this.adjustForGravity) {
            this.adjustForGravity();
        }
        if (this.exchangeVertices && maxDeltaM < this.EPSILON) {
            energy = this.calcEnergy();
            for (i = 0; i < n - 1; ++i) {
                if (this.dontMove(this.vertices[i])) continue;
                for (int j = i + 1; j < n; ++j) {
                    double xenergy;
                    if (this.dontMove(this.vertices[j]) || !(energy > (xenergy = this.calcEnergyIfExchanged(i, j)))) continue;
                    double sx = this.xydata[i].getX();
                    double sy = this.xydata[i].getY();
                    this.xydata[i].setX(this.xydata[j].getX());
                    this.xydata[i].setY(this.xydata[j].getY());
                    this.xydata[j].setX(sx);
                    this.xydata[j].setY(sy);
                    return;
                }
            }
        }
    }

    public void adjustForGravity() {
        Dimension d = this.getCurrentSize();
        double height = d.getHeight();
        double width = d.getWidth();
        double gx = 0.0;
        double gy = 0.0;
        for (int i = 0; i < this.xydata.length; ++i) {
            gx += this.xydata[i].getX();
            gy += this.xydata[i].getY();
        }
        double diffx = width / 2.0 - (gx /= (double)this.xydata.length);
        double diffy = height / 2.0 - (gy /= (double)this.xydata.length);
        for (int i = 0; i < this.xydata.length; ++i) {
            this.xydata[i].add(diffx, diffy);
        }
    }

    public void setAdjustForGravity(boolean on) {
        this.adjustForGravity = on;
    }

    public boolean getAdjustForGravity() {
        return this.adjustForGravity;
    }

    public void setExchangeVertices(boolean on) {
        this.exchangeVertices = on;
    }

    public boolean getExchangeVertices() {
        return this.exchangeVertices;
    }

    private double[] calcDeltaXY(int m) {
        double dE_dxm = 0.0;
        double dE_dym = 0.0;
        double d2E_d2xm = 0.0;
        double d2E_dxmdym = 0.0;
        double d2E_dymdxm = 0.0;
        double d2E_d2ym = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == m) continue;
            double dist = this.dm.getQuick(m, i);
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            double dx = this.xydata[m].getX() - this.xydata[i].getX();
            double dy = this.xydata[m].getY() - this.xydata[i].getY();
            double d = Math.sqrt(dx * dx + dy * dy);
            double ddd = d * d * d;
            dE_dxm += k_mi * (1.0 - l_mi / d) * dx;
            dE_dym += k_mi * (1.0 - l_mi / d) * dy;
            d2E_d2xm += k_mi * (1.0 - l_mi * dy * dy / ddd);
            d2E_dxmdym += k_mi * l_mi * dx * dy / ddd;
            d2E_d2ym += k_mi * (1.0 - l_mi * dx * dx / ddd);
        }
        d2E_dymdxm = d2E_dxmdym;
        double denomi = d2E_d2xm * d2E_d2ym - d2E_dxmdym * d2E_dymdxm;
        double deltaX = (d2E_dxmdym * dE_dym - d2E_d2ym * dE_dxm) / denomi;
        double deltaY = (d2E_dymdxm * dE_dxm - d2E_d2xm * dE_dym) / denomi;
        return new double[]{deltaX, deltaY};
    }

    private double calcDeltaM(int m) {
        double dEdxm = 0.0;
        double dEdym = 0.0;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (i == m) continue;
            double dist = this.dm.getQuick(m, i);
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            double dx = this.xydata[m].getX() - this.xydata[i].getX();
            double dy = this.xydata[m].getY() - this.xydata[i].getY();
            double d = Math.sqrt(dx * dx + dy * dy);
            double common = k_mi * (1.0 - l_mi / d);
            dEdxm += common * dx;
            dEdym += common * dy;
        }
        return Math.sqrt(dEdxm * dEdxm + dEdym * dEdym);
    }

    private double calcEnergy() {
        double energy = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                double dist = this.dm.getQuick(i, j);
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = this.xydata[i].getX() - this.xydata[j].getX();
                double dy = this.xydata[i].getY() - this.xydata[j].getY();
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }

    private double calcEnergyIfExchanged(int p, int q) {
        if (p >= q) {
            throw new RuntimeException("p should be < q");
        }
        double energy = 0.0;
        for (int i = 0; i < this.vertices.length - 1; ++i) {
            for (int j = i + 1; j < this.vertices.length; ++j) {
                int ii = i;
                int jj = j;
                if (i == p) {
                    ii = q;
                }
                if (j == q) {
                    jj = p;
                }
                double dist = this.dm.getQuick(i, j);
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = this.xydata[ii].getX() - this.xydata[jj].getX();
                double dy = this.xydata[ii].getY() - this.xydata[jj].getY();
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }
}

