/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import com.hp.hpl.guess.piccolo.GuessPEdge;
import com.hp.hpl.guess.piccolo.Morpher;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import java.awt.Color;

public class GuessEdgeActivity
extends PInterpolatingActivity {
    private Color sourceColor;
    private Color[] destinationColor;
    private boolean sourceVisible;
    private boolean[] destinationVisible;
    private double sourceWidth;
    private double[] destinationWidth;
    private GuessPEdge target;
    private int loopC = 0;
    private boolean disappearEarly = false;
    private boolean appearLate = false;

    public GuessEdgeActivity(long duration, long stepRate, GuessPEdge aTarget) {
        super(duration, stepRate, 1, 1);
        this.target = aTarget;
        this.setStarts();
    }

    protected boolean isAnimation() {
        return true;
    }

    public void setStarts() {
        this.sourceWidth = this.target.getLineWidth();
        this.sourceColor = (Color)this.target.getColor();
        if (this.sourceColor == null) {
            this.sourceColor = VisFactory.getFactory().getDisplay().getDisplayBackground();
        }
        this.sourceVisible = this.target.getVisible();
    }

    public void setDestinationGone() {
        this.setDestination(null, false, this.sourceWidth);
    }

    public void setDestination(Color dC, boolean dV, double dWidth) {
        this.destinationColor = new Color[]{dC};
        this.destinationWidth = new double[]{dWidth};
        this.destinationVisible = new boolean[]{dV};
        if (dV) {
            if (!this.sourceVisible) {
                this.target.setColor(Morpher.getInvisible());
                this.target.setVisible(true);
                this.sourceColor = Morpher.getInvisible();
                this.appearLate = true;
            }
            this.destinationColor = new Color[]{dC};
        } else {
            this.disappearEarly = true;
            this.destinationColor = new Color[]{Morpher.getInvisible()};
        }
    }

    public void setDestinations(Color[] dC, boolean[] dV, double[] dWidth) {
        this.destinationWidth = dWidth;
        this.destinationVisible = dV;
        this.destinationColor = dC;
    }

    protected void activityStarted() {
        super.activityStarted();
    }

    public void setRelativeTargetValue(float zeroToOne) {
        super.setRelativeTargetValue(zeroToOne);
        if (this.disappearEarly) {
            if ((zeroToOne /= Morpher.getEdgeDisappearBy()) > 1.0f) {
                zeroToOne = 1.0f;
            }
        } else if (this.appearLate && (zeroToOne = (zeroToOne - Morpher.getEdgeAppearAfter()) / (1.0f - Morpher.getEdgeAppearAfter())) < 0.0f) {
            return;
        }
        float red = (float)this.sourceColor.getRed() + zeroToOne * (float)(this.destinationColor[this.loopC].getRed() - this.sourceColor.getRed());
        float green = (float)this.sourceColor.getGreen() + zeroToOne * (float)(this.destinationColor[this.loopC].getGreen() - this.sourceColor.getGreen());
        float blue = (float)this.sourceColor.getBlue() + zeroToOne * (float)(this.destinationColor[this.loopC].getBlue() - this.sourceColor.getBlue());
        float alpha = (float)this.sourceColor.getAlpha() + zeroToOne * (float)(this.destinationColor[this.loopC].getAlpha() - this.sourceColor.getAlpha());
        this.target.setColor(new Color(red / 255.0f, green / 255.0f, blue / 255.0f, alpha / 255.0f));
        double newWidth = this.sourceWidth + (double)zeroToOne * (this.destinationWidth[this.loopC] - this.sourceWidth);
        this.target.setLineWidth(newWidth);
    }

    protected void activityFinished() {
        PActivityScheduler scheduler = this.getActivityScheduler();
        super.activityFinished();
        ++this.loopC;
        if (this.loopC <= this.destinationColor.length - 1) {
            ++this.loopC;
            this.setStarts();
            this.setStartTime(this.getStartTime() + this.getDuration());
            scheduler.addActivity((PActivity)this);
        }
    }
}

