/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.piccolo.Morpher;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import java.awt.Color;

public class GuessNodeActivity
extends PInterpolatingActivity {
    private Color sourceColor;
    private Color[] destinationColor;
    private boolean sourceVisible;
    private boolean[] destinationVisible;
    private boolean sourceLabelVisible;
    private boolean[] destinationLabelVisible;
    private double sourceX;
    private double[] destinationX;
    private double sourceY;
    private double[] destinationY;
    private double sourceWidth;
    private double sourceHeight;
    private double[] destinationWidth;
    private double[] destinationHeight;
    private GuessPNode target;
    private int loopC = 0;
    private boolean disappearEarly = false;
    private boolean appearLate = false;

    public GuessNodeActivity(long duration, long stepRate, GuessPNode aTarget) {
        super(duration, stepRate, 1, 1);
        this.target = aTarget;
        this.setStarts();
    }

    protected boolean isAnimation() {
        return true;
    }

    public void setStarts() {
        this.sourceX = this.target.getX();
        this.sourceY = this.target.getY();
        this.sourceHeight = this.target.getHeight();
        this.sourceWidth = this.target.getWidth();
        this.sourceColor = (Color)this.target.getPaint();
        this.sourceVisible = ((PNode)this.target).getVisible();
        this.sourceLabelVisible = (Boolean)this.target.get("labelvisible");
    }

    public void setDestinationGone() {
        this.setDestination(this.sourceX, this.sourceY, null, false, false, this.sourceWidth, this.sourceHeight);
    }

    public void setDestination(double dX, double dY, Color dC, boolean dV, boolean dLV, double dWidth, double dHeight) {
        this.destinationX = new double[]{dX};
        this.destinationY = new double[]{dY};
        this.destinationWidth = new double[]{dWidth};
        this.destinationHeight = new double[]{dHeight};
        this.destinationVisible = new boolean[]{dV};
        if (dV) {
            if (!this.sourceVisible) {
                this.target.setColor(Morpher.getInvisible());
                ((PNode)this.target).setVisible(true);
                this.sourceColor = Morpher.getInvisible();
                this.appearLate = true;
            }
            this.destinationColor = new Color[]{dC};
        } else {
            this.disappearEarly = true;
            this.destinationColor = new Color[]{Morpher.getInvisible()};
        }
        this.destinationLabelVisible = new boolean[]{dLV};
    }

    public void setDestinations(double[] dX, double[] dY, Color[] dC, boolean[] dV, boolean[] dLV, double[] dWidth, double[] dHeight) {
        this.destinationX = dX;
        this.destinationY = dY;
        this.destinationWidth = dWidth;
        this.destinationHeight = dHeight;
        this.destinationVisible = dV;
        this.destinationColor = dC;
        this.destinationLabelVisible = dLV;
    }

    protected void activityStarted() {
        super.activityStarted();
    }

    public void setRelativeTargetValue(float zeroToOne) {
        super.setRelativeTargetValue(zeroToOne);
        if (this.disappearEarly) {
            if ((zeroToOne /= Morpher.getNodeDisappearBy()) > 1.0f) {
                zeroToOne = 1.0f;
            }
        } else if (this.appearLate && (zeroToOne = (zeroToOne - Morpher.getNodeAppearAfter()) / (1.0f - Morpher.getNodeAppearAfter())) < 0.0f) {
            return;
        }
        float red = (float)this.sourceColor.getRed() + zeroToOne * (float)(this.destinationColor[this.loopC].getRed() - this.sourceColor.getRed());
        float green = (float)this.sourceColor.getGreen() + zeroToOne * (float)(this.destinationColor[this.loopC].getGreen() - this.sourceColor.getGreen());
        float blue = (float)this.sourceColor.getBlue() + zeroToOne * (float)(this.destinationColor[this.loopC].getBlue() - this.sourceColor.getBlue());
        float alpha = (float)this.sourceColor.getAlpha() + zeroToOne * (float)(this.destinationColor[this.loopC].getAlpha() - this.sourceColor.getAlpha());
        this.target.setColor(new Color(red / 255.0f, green / 255.0f, blue / 255.0f, alpha / 255.0f));
        double newX = this.sourceX + (double)zeroToOne * (this.destinationX[this.loopC] - this.sourceX);
        double newY = this.sourceY + (double)zeroToOne * (this.destinationY[this.loopC] - this.sourceY);
        double newWidth = this.sourceWidth + (double)zeroToOne * (this.destinationWidth[this.loopC] - this.sourceWidth);
        double newHeight = this.sourceHeight + (double)zeroToOne * (this.destinationHeight[this.loopC] - this.sourceHeight);
        this.target.setLocation(newX, newY, newWidth, newHeight);
    }

    protected void activityFinished() {
        PActivityScheduler scheduler = this.getActivityScheduler();
        super.activityFinished();
        ++this.loopC;
        if (this.loopC <= this.destinationX.length - 1) {
            ++this.loopC;
            this.setStarts();
            this.setStartTime(this.getStartTime() + this.getDuration());
            scheduler.addActivity((PActivity)this);
        }
    }
}

