/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.piccolo.CursorFactory;
import com.hp.hpl.guess.piccolo.GFrame;
import com.hp.hpl.guess.piccolo.GuessPEdge;
import com.hp.hpl.guess.piccolo.GuessPNode;
import com.hp.hpl.guess.ui.EdgeEditorPopup;
import com.hp.hpl.guess.ui.GraphElementEditorPopup;
import com.hp.hpl.guess.ui.NodeEditorPopup;
import com.hp.hpl.guess.ui.VisFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolo.util.PPickPath;
import java.awt.Component;
import java.awt.geom.Point2D;
import java.util.HashSet;

public class MyZoomHandler
extends PZoomEventHandler {
    private GFrame owner = null;
    private Point2D lastClicked = null;

    public MyZoomHandler(GFrame owner) {
        this.owner = owner;
    }

    private boolean isNodeOrEdge(PInputEvent e) {
        PPickPath pp = e.getPath();
        PNode t = pp.getPickedNode();
        if (t instanceof GuessPNode) {
            return true;
        }
        return t instanceof GuessPEdge;
    }

    public void mousePressed(PInputEvent e) {
        if (e.isRightMouseButton()) {
            if (this.isNodeOrEdge(e)) {
                return;
            }
            e.pushCursor(CursorFactory.getCursor(2));
            super.mousePressed(e);
        }
    }

    public void mouseReleased(PInputEvent e) {
        super.mouseReleased(e);
        try {
            if (this.isNodeOrEdge(e)) {
                return;
            }
            e.popCursor();
        }
        catch (Exception ex) {
            e.pushCursor(CursorFactory.getCursor(1));
        }
    }

    public Point2D getLastClickedPosition() {
        return this.lastClicked;
    }

    public void mouseClicked(PInputEvent e) {
        if (e.isRightMouseButton()) {
            this.lastClicked = e.getPosition();
            PPickPath pp = e.getPath();
            PNode t = pp.getPickedNode();
            GFrame frame = (GFrame)VisFactory.getFactory().getDisplay();
            HashSet<GraphElement> c = frame.getSelected();
            if (c == null || c.size() <= 0) {
                if (t instanceof GuessPNode) {
                    ((GuessPNode)t).mouseClicked(e);
                    c = new HashSet<GraphElement>();
                    c.add(((GuessPNode)t).getOwner());
                    Point2D p2d = e.getPositionRelativeTo((PNode)frame.getCamera());
                    NodeEditorPopup.getPopup().show((Component)((Object)frame), (int)p2d.getX(), (int)p2d.getY(), c, ((GuessPNode)t).getOwner());
                } else if (t instanceof GuessPEdge) {
                    ((GuessPEdge)t).mouseClicked(e);
                    c = new HashSet();
                    c.add(((GuessPEdge)t).getOwner());
                    Point2D p2d = e.getPositionRelativeTo((PNode)frame.getCamera());
                    EdgeEditorPopup.getPopup().show((Component)((Object)frame), (int)p2d.getX(), (int)p2d.getY(), c, ((GuessPEdge)t).getOwner());
                }
            } else {
                boolean nodes = false;
                boolean edges = false;
                if (c.size() <= 0) {
                    return;
                }
                HashSet<GraphElement> newhs = new HashSet<GraphElement>();
                for (Object e2 : c) {
                    if (e2 instanceof GuessPEdge) {
                        newhs.add(((GuessPEdge)e2).getOwner());
                        edges = true;
                        continue;
                    }
                    if (!(e2 instanceof GuessPNode)) continue;
                    newhs.add(((GuessPNode)e2).getOwner());
                    nodes = true;
                }
                c = newhs;
                Point2D p2d = e.getPositionRelativeTo((PNode)frame.getCamera());
                if (nodes && edges) {
                    GraphElementEditorPopup.getPopup().show((Component)((Object)frame), (int)p2d.getX(), (int)p2d.getY(), c, c);
                } else if (nodes) {
                    NodeEditorPopup.getPopup().show((Component)((Object)frame), (int)p2d.getX(), (int)p2d.getY(), c, c);
                } else if (edges) {
                    EdgeEditorPopup.getPopup().show((Component)((Object)frame), (int)p2d.getX(), (int)p2d.getY(), c, c);
                }
            }
            super.mouseClicked(e);
        }
    }
}

