/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.event;

import com.hp.hpl.guess.piccolo.GuessPNode;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolox.event.GuessSelectionEventHandler;
import edu.umd.cs.piccolox.handles.GuessPHandle;
import java.util.Iterator;

public class MySelectionHandler
extends GuessSelectionEventHandler {
    private double xclick = 0.0;
    private double yclick = 0.0;
    private boolean moved = false;
    private boolean moveAllowed = true;

    public MySelectionHandler(PLayer layer1, PLayer layer2) {
        super((PNode)layer1, (PNode)layer2);
    }

    public void switchTo(PLayer layer2) {
        this.switchTo(layer2, true);
    }

    public void switchTo(PLayer layer2, boolean moveAllowed) {
        super.switchTo((PNode)layer2);
        this.moveAllowed = moveAllowed;
        GuessPHandle.setResizeable(moveAllowed);
    }

    @Override
    protected void startDrag(PInputEvent e) {
        if (e.isLeftMouseButton()) {
            PNode pressNode = e.getPath().getPickedNode();
            if (pressNode instanceof PCamera && !e.isShiftDown()) {
                this.unselectAll();
                return;
            }
            this.xclick = e.getPosition().getX();
            this.yclick = e.getPosition().getY();
            super.startDrag(e);
        }
    }

    @Override
    protected void drag(PInputEvent e) {
        if (e.isLeftMouseButton()) {
            super.drag(e);
        }
    }

    @Override
    protected void endDrag(PInputEvent e) {
        if (e.isLeftMouseButton()) {
            super.endDrag(e);
        }
        if (this.moved) {
            double deltaX = e.getPosition().getX() - this.xclick;
            double deltaY = e.getPosition().getY() - this.yclick;
            this.xclick = e.getPosition().getX();
            this.yclick = e.getPosition().getY();
            for (PNode node : this.getSelectionReference()) {
                if (node instanceof GuessPNode) {
                    ((GuessPNode)node).moveDone(node.getX() + deltaX, node.getY() + deltaY);
                    continue;
                }
                if (!this.moveAllowed) continue;
                node.setBounds(node.getX() + deltaX, node.getY() + deltaY, node.getWidth(), node.getHeight());
            }
            this.moved = false;
        }
    }

    @Override
    protected void dragStandardSelection(PInputEvent e) {
        double deltaX = e.getPosition().getX() - this.xclick;
        double deltaY = e.getPosition().getY() - this.yclick;
        this.xclick = e.getPosition().getX();
        this.yclick = e.getPosition().getY();
        Iterator selectionEn = this.getSelectionReference().iterator();
        if (!this.moved) {
            while (selectionEn.hasNext()) {
                PNode node = (PNode)selectionEn.next();
                node.moveToFront();
                if (node instanceof GuessPNode) {
                    ((GuessPNode)node).inTransition(node.getX() + deltaX, node.getY() + deltaY);
                    continue;
                }
                if (!this.moveAllowed) continue;
                node.setBounds(node.getX() + deltaX, node.getY() + deltaY, node.getWidth(), node.getHeight());
            }
            this.moved = true;
        } else {
            while (selectionEn.hasNext()) {
                PNode node = (PNode)selectionEn.next();
                if (node instanceof GuessPNode) {
                    ((GuessPNode)node).inTransition(node.getX() + deltaX, node.getY() + deltaY);
                    continue;
                }
                if (!this.moveAllowed) continue;
                node.setBounds(node.getX() + deltaX, node.getY() + deltaY, node.getWidth(), node.getHeight());
            }
        }
    }
}

