/*
 * Decompiled with CFR 0.152.
 */
package jxxload_help;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import jxxload_help.PathVFS;
import org.python.core.Options;

public class PathVFSJavaLoader
extends ClassLoader {
    private ClassLoader parent;
    private PathVFS vfs;
    public Vector interfaces = new Vector();

    public PathVFSJavaLoader(PathVFS vfs, ClassLoader parent) {
        this.vfs = vfs;
        this.parent = parent;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        try {
            if (this.parent != null) {
                return this.parent.loadClass(name);
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        InputStream in = this.vfs.open(name.replace('.', '/') + ".class");
        if (in == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            int av = in.available();
            byte[] buf = new byte[av];
            in.read(buf);
            in.close();
            return this.loadClassFromBytes(name, buf);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name);
        }
    }

    private Class loadClassFromBytes(String name, byte[] data) {
        Class<?> c = this.defineClass(name, data, 0, data.length);
        this.resolveClass(c);
        if (c.isInterface()) {
            this.interfaces.addElement(c);
        }
        if (!Options.skipCompile) {
            Compiler.compileClass(c);
        }
        return c;
    }
}

