/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import org.python.core.CompilerFlags;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.SimpleNode;

public class Future
implements PythonGrammarTreeConstants {
    private boolean nested_scopes;
    private static final String FUTURE = "__future__";

    private boolean check(SimpleNode cand) throws Exception {
        SimpleNode dotted_name = cand.getChild(0);
        if (dotted_name.getNumChildren() != 1 || !((String)dotted_name.getChild(0).getInfo()).equals(FUTURE)) {
            return false;
        }
        int n = cand.getNumChildren();
        if (n == 1) {
            throw new ParseException("future statement does not support import *", cand);
        }
        for (int i = 1; i < n; ++i) {
            String feature;
            SimpleNode imp2 = cand.getChild(i);
            switch (imp2.id) {
                default: {
                    feature = (String)imp2.getInfo();
                    break;
                }
                case 34: {
                    feature = (String)imp2.getChild(0).getInfo();
                }
            }
            if (!feature.equals("nested_scopes")) {
                throw new ParseException("future feature " + feature + " is not defined", cand);
            }
            this.nested_scopes = true;
        }
        return true;
    }

    public void preprocessFutures(SimpleNode node, CompilerFlags cflags) throws Exception {
        if (cflags != null) {
            this.nested_scopes = cflags.nested_scopes;
        }
        if (node.id != 1 && node.id != 0) {
            return;
        }
        int n = node.getNumChildren();
        if (n == 0) {
            return;
        }
        int beg = 0;
        if (node.id == 1 && node.getChild((int)0).id == 10 && node.getChild((int)0).getChild((int)0).id == 104) {
            ++beg;
        }
        for (int i = beg; i < n; ++i) {
            SimpleNode stmt = node.getChild(i);
            if (stmt.id != 31) break;
            stmt.from_future_checked = true;
            if (!this.check(stmt)) break;
        }
        if (cflags != null) {
            cflags.nested_scopes = cflags.nested_scopes || this.nested_scopes;
        }
    }

    public static void checkFromFuture(SimpleNode node) throws Exception {
        if (node.from_future_checked) {
            return;
        }
        SimpleNode dotted_name = node.getChild(0);
        if (dotted_name.getNumChildren() == 1 && ((String)dotted_name.getChild(0).getInfo()).equals(FUTURE)) {
            throw new ParseException("from __future__ imports must occur at the beginning of the file", node);
        }
        node.from_future_checked = true;
    }

    public boolean areNestedScopesOn() {
        return this.nested_scopes;
    }
}

