/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Stack;
import org.python.compiler.ArgListCompiler;
import org.python.compiler.CompilationContext;
import org.python.compiler.Future;
import org.python.compiler.ScopeConstants;
import org.python.compiler.ScopeInfo;
import org.python.core.parser;
import org.python.parser.ParseException;
import org.python.parser.SimpleNode;
import org.python.parser.Visitor;

public class ScopesCompiler
extends Visitor
implements ScopeConstants {
    private CompilationContext code_compiler;
    private boolean nested_scopes = false;
    private Stack scopes;
    private ScopeInfo cur = null;
    private int mode;
    private static final int GET = 0;
    private static final int SET = 1;
    private static final int DEL = 2;
    private static final int AUGSET = 4;
    private int level = 0;
    private int func_level = 0;

    public ScopesCompiler(CompilationContext code_compiler) {
        this.code_compiler = code_compiler;
        this.scopes = new Stack();
        this.mode = 0;
        this.nested_scopes = code_compiler.getFutures().areNestedScopesOn();
    }

    public Object set(SimpleNode node) throws Exception {
        return this.modal(node, 1);
    }

    public Object del(SimpleNode node) throws Exception {
        return this.modal(node, 2);
    }

    public Object augset(SimpleNode node) throws Exception {
        return this.modal(node, 4);
    }

    public Object modal(SimpleNode node, int newmode) throws Exception {
        this.mode = newmode;
        node.visit(this);
        this.mode = 0;
        return null;
    }

    public void beginScope(String name, int kind, SimpleNode node, ArgListCompiler ac) {
        if (this.cur != null) {
            this.scopes.push(this.cur);
        }
        if (kind == 1) {
            ++this.func_level;
        }
        node.scope = this.cur = new ScopeInfo(name, node, this.level++, kind, this.func_level, ac, this.nested_scopes);
    }

    public void endScope() throws Exception {
        if (this.cur.kind == 1) {
            --this.func_level;
        }
        --this.level;
        ScopeInfo up = !this.scopes.empty() ? (ScopeInfo)this.scopes.pop() : null;
        this.cur.cook(up, this.code_compiler);
        this.cur.dump();
        this.cur = up;
    }

    public void parse(SimpleNode node) throws Exception {
        try {
            node.visit(this);
        }
        catch (Throwable t) {
            throw parser.fixParseError(null, t, this.code_compiler.getFilename());
        }
    }

    @Override
    public Object single_input(SimpleNode node) throws Exception {
        this.beginScope("<single-top>", 0, node, null);
        this.suite(node);
        this.endScope();
        return null;
    }

    @Override
    public Object file_input(SimpleNode node) throws Exception {
        this.beginScope("<file-top>", 0, node, null);
        this.suite(node);
        this.endScope();
        return null;
    }

    @Override
    public Object eval_input(SimpleNode node) throws Exception {
        this.beginScope("<eval-top>", 0, node, null);
        this.return_stmt(node);
        this.endScope();
        return null;
    }

    private String def(SimpleNode node) {
        String name = (String)node.getChild(0).getInfo();
        this.cur.addBound(name);
        return name;
    }

    @Override
    public Object funcdef(SimpleNode node) throws Exception {
        SimpleNode suite;
        String my_name = this.def(node);
        ArgListCompiler ac = new ArgListCompiler();
        if (node.getNumChildren() == 3) {
            suite = node.getChild(2);
            node.getChild(1).visit(ac);
        } else {
            suite = node.getChild(1);
        }
        SimpleNode[] defaults = ac.getDefaults();
        int defc = defaults.length;
        for (int i = 0; i < defc; ++i) {
            defaults[i].visit(this);
        }
        this.beginScope(my_name, 1, node, ac);
        int n = ac.names.size();
        for (int i = 0; i < n; ++i) {
            this.cur.addParam((String)ac.names.elementAt(i));
        }
        ac.init_code.visit(this);
        this.cur.markFromParam();
        suite.visit(this);
        this.endScope();
        return null;
    }

    @Override
    public Object expr_stmt(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        node.getChild(n - 1).visit(this);
        for (int i = 0; i < n - 1; ++i) {
            this.set(node.getChild(i));
        }
        return null;
    }

    @Override
    public Object print_ext(SimpleNode node) throws Exception {
        node.getChild(0).visit(this);
        return null;
    }

    @Override
    public Object print_stmt(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                node.getChild(i).visit(this);
            }
            if (node.getChild((int)(n - 1)).id != 93) {
                node.getChild(n - 1).visit(this);
            }
        }
        return null;
    }

    @Override
    public Object del_stmt(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        for (int i = 0; i < n; ++i) {
            this.del(node.getChild(i));
        }
        return null;
    }

    @Override
    public Object pass_stmt(SimpleNode n) throws Exception {
        return null;
    }

    @Override
    public Object break_stmt(SimpleNode n) throws Exception {
        return null;
    }

    @Override
    public Object continue_stmt(SimpleNode n) throws Exception {
        return null;
    }

    @Override
    public Object return_stmt(SimpleNode node) throws Exception {
        if (node.getNumChildren() == 1) {
            node.getChild(0).visit(this);
        }
        return null;
    }

    public void stmt(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        for (int i = 0; i < n; ++i) {
            node.getChild(i).visit(this);
        }
    }

    @Override
    public Object raise_stmt(SimpleNode node) throws Exception {
        this.stmt(node);
        return null;
    }

    @Override
    public Object Import(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        block4: for (int i = 0; i < n; ++i) {
            SimpleNode imp2 = node.getChild(i);
            switch (imp2.id) {
                case 33: {
                    this.cur.addBound((String)imp2.getChild(0).getInfo());
                    continue block4;
                }
                case 32: {
                    this.cur.addBound((String)imp2.getChild(1).getInfo());
                }
            }
        }
        return null;
    }

    @Override
    public Object ImportFrom(SimpleNode node) throws Exception {
        Future.checkFromFuture(node);
        int n = node.getNumChildren();
        if (n == 1) {
            this.cur.from_import_star = true;
            return null;
        }
        block4: for (int i = 1; i < n; ++i) {
            SimpleNode imp2 = node.getChild(i);
            switch (imp2.id) {
                case 103: {
                    this.cur.addBound((String)imp2.getInfo());
                    continue block4;
                }
                case 34: {
                    this.cur.addBound((String)imp2.getChild(1).getInfo());
                }
            }
        }
        return null;
    }

    @Override
    public Object global_stmt(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        for (int i = 0; i < n; ++i) {
            String name = (String)node.getChild(i).getInfo();
            int prev = this.cur.addGlobal(name);
            if (prev < 0) continue;
            if ((prev & 8) != 0) {
                this.code_compiler.error("name '" + name + "' is local and global", true, node);
            }
            if ((prev & 0x42) != 0) continue;
            String what = (prev & 1) != 0 ? "assignment" : "use";
            this.code_compiler.error("name '" + name + "' declared global after " + what, false, node);
        }
        return null;
    }

    @Override
    public Object exec_stmt(SimpleNode node) throws Exception {
        this.cur.exec = true;
        int n = node.getNumChildren();
        if (n == 1) {
            this.cur.unqual_exec = true;
        }
        for (int i = 0; i < n; ++i) {
            node.getChild(i).visit(this);
        }
        return null;
    }

    @Override
    public Object assert_stmt(SimpleNode node) throws Exception {
        this.stmt(node);
        return null;
    }

    @Override
    public Object if_stmt(SimpleNode node) throws Exception {
        this.stmt(node);
        return null;
    }

    @Override
    public Object while_stmt(SimpleNode node) throws Exception {
        this.stmt(node);
        return null;
    }

    @Override
    public Object for_stmt(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        this.set(node.getChild(0));
        node.getChild(1).visit(this);
        node.getChild(2).visit(this);
        if (node.getNumChildren() > 3) {
            node.getChild(3).visit(this);
        }
        return null;
    }

    @Override
    public Object try_stmt(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        for (int i = 0; i < n; ++i) {
            if (i % 2 == 1 && i != n - 1) {
                switch (node.getChild(i).getNumChildren()) {
                    case 2: {
                        this.set(node.getChild(i).getChild(1));
                    }
                    case 1: {
                        node.getChild(i).getChild(0).visit(this);
                    }
                }
                continue;
            }
            node.getChild(i).visit(this);
        }
        return null;
    }

    @Override
    public Object suite(SimpleNode node) throws Exception {
        this.stmt(node);
        return null;
    }

    private static void illassign(SimpleNode node) throws Exception {
        String target = "operator";
        if (node.id == 81) {
            target = "function call";
        } else if (node.id == 40) {
            target = "list comprehension";
        }
        throw new ParseException("can't assign to " + target, node);
    }

    public void binaryop(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        node.getChild(0).visit(this);
        node.getChild(1).visit(this);
    }

    public void unaryop(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        node.getChild(0).visit(this);
    }

    @Override
    public Object or_boolean(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object and_boolean(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object not_1op(SimpleNode node) throws Exception {
        this.unaryop(node);
        return null;
    }

    @Override
    public Object comparision(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        int n = node.getNumChildren();
        for (int i = 0; i < n; ++i) {
            if (i % 2 != 0) continue;
            node.getChild(i).visit(this);
        }
        return null;
    }

    @Override
    public Object or_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object xor_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object and_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object lshift_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object rshift_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object add_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object sub_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object mul_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object div_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object mod_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object pos_1op(SimpleNode node) throws Exception {
        this.unaryop(node);
        return null;
    }

    @Override
    public Object neg_1op(SimpleNode node) throws Exception {
        this.unaryop(node);
        return null;
    }

    @Override
    public Object invert_1op(SimpleNode node) throws Exception {
        this.unaryop(node);
        return null;
    }

    @Override
    public Object pow_2op(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object str_1op(SimpleNode node) throws Exception {
        this.unaryop(node);
        return null;
    }

    @Override
    public Object strjoin(SimpleNode node) throws Exception {
        this.binaryop(node);
        return null;
    }

    @Override
    public Object Call_Op(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        node.getChild(0).visit(this);
        if (node.getNumChildren() > 1) {
            SimpleNode args = node.getChild(1);
            int n = args.getNumChildren();
            block4: for (int i = 0; i < n; ++i) {
                SimpleNode arg = args.getChild(i);
                switch (arg.id) {
                    case 99: {
                        arg.getChild(1).visit(this);
                        continue block4;
                    }
                    case 97: 
                    case 98: {
                        arg.getChild(0).visit(this);
                        continue block4;
                    }
                    default: {
                        arg.visit(this);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Object Index_Op(SimpleNode node) throws Exception {
        int prevmode = this.mode;
        this.mode = 0;
        node.getChild(0).visit(this);
        node.getChild(1).visit(this);
        this.mode = prevmode;
        return null;
    }

    @Override
    public Object Dot_Op(SimpleNode node) throws Exception {
        int prevmode = this.mode;
        this.mode = 0;
        node.getChild(0).visit(this);
        this.mode = prevmode;
        return null;
    }

    @Override
    public Object tuple(SimpleNode node) throws Exception {
        if (this.mode == 4) {
            throw new ParseException("augmented assign to tuple not possible", node);
        }
        int n = node.getNumChildren();
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                node.getChild(i).visit(this);
            }
            if (node.getChild((int)(n - 1)).id != 93) {
                node.getChild(n - 1).visit(this);
            }
        }
        return null;
    }

    @Override
    public Object fplist(SimpleNode node) throws Exception {
        return this.list(node);
    }

    @Override
    public Object list(SimpleNode node) throws Exception {
        if (this.mode == 4) {
            throw new ParseException("augmented assign to list not possible", node);
        }
        int n = node.getNumChildren();
        if (n > 0) {
            for (int i = 0; i < n - 1; ++i) {
                node.getChild(i).visit(this);
            }
            if (node.getChild((int)(n - 1)).id != 93) {
                node.getChild(n - 1).visit(this);
            }
        }
        return null;
    }

    @Override
    public Object list_iter(SimpleNode node) throws Exception {
        if (node.getNumChildren() == 1) {
            node.getChild(0).visit(this);
        }
        return null;
    }

    @Override
    public Object dictionary(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        this.stmt(node);
        return null;
    }

    @Override
    public Object lambdef(SimpleNode node) throws Exception {
        SimpleNode expr;
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        ArgListCompiler ac = new ArgListCompiler();
        if (node.getNumChildren() == 2) {
            expr = node.getChild(1);
            node.getChild(0).visit(ac);
        } else {
            expr = node.getChild(0);
        }
        SimpleNode[] defaults = ac.getDefaults();
        int defc = defaults.length;
        for (int i = 0; i < defc; ++i) {
            defaults[i].visit(this);
        }
        this.beginScope("<lambda>", 1, node, ac);
        int n = ac.names.size();
        for (int i = 0; i < n; ++i) {
            this.cur.addParam((String)ac.names.elementAt(i));
        }
        ac.init_code.visit(this);
        this.cur.markFromParam();
        expr.visit(this);
        this.endScope();
        return null;
    }

    @Override
    public Object Ellipses(SimpleNode n) throws Exception {
        return null;
    }

    @Override
    public Object Slice(SimpleNode node) throws Exception {
        int n = node.getNumChildren();
        for (int i = 0; i < n; ++i) {
            SimpleNode snode = node.getChild(i);
            if (snode.id == 92) continue;
            snode.visit(this);
        }
        return null;
    }

    @Override
    public Object classdef(SimpleNode node) throws Exception {
        String cl_name = this.def(node);
        int n = node.getNumChildren();
        SimpleNode suite = node.getChild(n - 1);
        for (int i = 1; i < n - 1; ++i) {
            node.getChild(i).visit(this);
        }
        this.beginScope(cl_name, 2, node, null);
        suite.visit(this);
        this.endScope();
        return null;
    }

    @Override
    public Object Int(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        return null;
    }

    @Override
    public Object Float(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        return null;
    }

    @Override
    public Object Complex(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        return null;
    }

    @Override
    public Object Name(SimpleNode node) throws Exception {
        String name = (String)node.getInfo();
        if (this.mode != 0) {
            if (name.equals("__debug__")) {
                this.code_compiler.error("can not assign to __debug__", false, node);
            }
            this.cur.addBound(name);
        } else {
            this.cur.addUsed(name);
        }
        return null;
    }

    @Override
    public Object String(SimpleNode node) throws Exception {
        if (this.mode != 0) {
            ScopesCompiler.illassign(node);
        }
        return null;
    }

    public void aug_assign(SimpleNode node) throws Exception {
        this.augset(node.getChild(0));
        node.getChild(1).visit(this);
    }

    @Override
    public Object aug_plus(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_minus(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_multiply(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_divide(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_modulo(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_and(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_or(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_xor(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_lshift(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_rshift(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }

    @Override
    public Object aug_power(SimpleNode node) throws Exception {
        this.aug_assign(node);
        return null;
    }
}

