/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Vector;
import org.python.core.BytecodeLoader1;
import org.python.core.Loader;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyRunnable;
import org.python.core.imp;

public class BytecodeLoader {
    private static Class loaderClass = null;

    static Vector init() {
        Vector<ClassLoader> parents = new Vector<ClassLoader>();
        parents.addElement(imp.getSyspathJavaLoader());
        return parents;
    }

    static Class findParentClass(Vector parents, String name) throws ClassNotFoundException {
        for (int i = 0; i < parents.size(); ++i) {
            try {
                return ((ClassLoader)parents.elementAt(i)).loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        throw new ClassNotFoundException(name);
    }

    static void compileClass(Class c) {
        if (!Options.skipCompile) {
            Compiler.compileClass((Class)c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Loader makeLoader() {
        if (loaderClass == null) {
            Class<BytecodeLoader> clazz = BytecodeLoader.class;
            // MONITORENTER : org.python.core.BytecodeLoader.class
            String version = System.getProperty("java.version");
            if (version.compareTo("1.2") >= 0) {
                try {
                    loaderClass = Class.forName("org.python.core.BytecodeLoader2");
                }
                catch (Throwable e) {
                    loaderClass = BytecodeLoader1.class;
                }
            } else {
                loaderClass = BytecodeLoader1.class;
            }
            // MONITOREXIT : clazz
        }
        try {
            return (Loader)loaderClass.newInstance();
        }
        catch (Exception e) {
            return new BytecodeLoader1();
        }
    }

    public static Class makeClass(String name, Vector referents, byte[] data) {
        Loader loader = BytecodeLoader.makeLoader();
        if (referents != null) {
            for (int i = 0; i < referents.size(); ++i) {
                try {
                    Class cls = (Class)referents.elementAt(i);
                    ClassLoader cur = cls.getClassLoader();
                    if (cur == null) continue;
                    loader.addParent(cur);
                    continue;
                }
                catch (SecurityException e) {
                    // empty catch block
                }
            }
        }
        return loader.loadClassFromBytes(name, data);
    }

    public static PyCode makeCode(String name, byte[] data) {
        try {
            Class c = BytecodeLoader.makeClass(name, null, data);
            return ((PyRunnable)c.newInstance()).getMain();
        }
        catch (Exception e) {
            throw Py.JavaError(e);
        }
    }
}

