/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;

public class PyArray
extends PySequence {
    Object data;
    Class type;
    public static PyClass __class__;

    public PyArray(Class type, Object data) {
        super(__class__);
        this.type = type;
        this.data = data;
    }

    public PyArray(Class type, int n) {
        this(type, Array.newInstance(type, n));
    }

    public static PyArray zeros(int n, Class ctype) {
        return new PyArray(ctype, n);
    }

    public static PyArray array(PyObject seq, Class ctype) {
        PyObject o;
        PyArray array = new PyArray(ctype, seq.__len__());
        int i = 0;
        while ((o = seq.__finditem__(i)) != null) {
            array.set(i, o);
            ++i;
        }
        return array;
    }

    public static Class char2class(char type) {
        switch (type) {
            case 'z': {
                return Boolean.TYPE;
            }
            case 'c': {
                return Character.TYPE;
            }
            case 'b': {
                return Byte.TYPE;
            }
            case 'h': {
                return Short.TYPE;
            }
            case 'i': {
                return Integer.TYPE;
            }
            case 'l': {
                return Long.TYPE;
            }
            case 'f': {
                return Float.TYPE;
            }
            case 'd': {
                return Double.TYPE;
            }
        }
        throw Py.ValueError("typecode must be in [zcbhilfd]");
    }

    @Override
    public Object __tojava__(Class c) {
        if (c == Object.class || c.isArray() && c.getComponentType().isAssignableFrom(this.type)) {
            return this.data;
        }
        if (c.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    public int __len__() {
        return Array.getLength(this.data);
    }

    @Override
    protected PyObject get(int i) {
        return Py.java2py(Array.get(this.data, i));
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step != 1) {
            throw Py.TypeError("step != 1 not implemented yet");
        }
        int n = stop - start;
        PyArray ret = new PyArray(this.type, n);
        System.arraycopy(this.data, start, ret.data, 0, n);
        return ret;
    }

    @Override
    protected PyObject repeat(int count) {
        throw Py.TypeError("can't apply '*' to arrays");
    }

    @Override
    protected void del(int i) {
        throw Py.TypeError("can't remove from array");
    }

    @Override
    protected void delRange(int start, int stop, int step) {
        throw Py.TypeError("can't remove from array");
    }

    @Override
    protected void set(int i, PyObject value) {
        Object o = Py.tojava(value, this.type);
        Array.set(this.data, i, o);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        if (value instanceof PyString && this.type == Character.TYPE) {
            char[] chars = value.toString().toCharArray();
            if (chars.length != stop - start || step != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(chars, 0, this.data, start, chars.length);
            return;
        } else {
            if (!(value instanceof PyString) || this.type != Byte.TYPE) throw Py.TypeError("can't set slice in array (except from string)");
            byte[] chars = value.toString().getBytes();
            if (chars.length != stop - start || step != 1) throw Py.ValueError("invalid bounds for setting from string");
            System.arraycopy(chars, 0, this.data, start, chars.length);
        }
    }

    public String tostring() {
        if (this.type == Character.TYPE) {
            return new String((char[])this.data);
        }
        if (this.type == Byte.TYPE) {
            return new String((byte[])this.data, 0);
        }
        throw Py.TypeError("can only convert arrays of byte and char to string");
    }

    @Override
    public PyString __repr__() {
        StringBuffer buf = new StringBuffer("array([");
        for (int i = 0; i < this.__len__() - 1; ++i) {
            buf.append(this.get(i).__repr__().toString());
            buf.append(", ");
        }
        if (this.__len__() > 0) {
            buf.append(this.get(this.__len__() - 1).__repr__().toString());
        }
        buf.append("], ");
        buf.append(this.type.getName());
        buf.append(")");
        return new PyString(buf.toString());
    }
}

