/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyFile
extends PyObject {
    public String name;
    public String mode;
    public boolean softspace;
    public boolean closed;
    private FileWrapper file;

    private static InputStream _pb(InputStream s, String mode) {
        if (mode.indexOf(98) < 0) {
            try {
                s = (PushbackInputStream)s;
            }
            catch (ClassCastException e) {
                s = new PushbackInputStream(s);
            }
        }
        return s;
    }

    public PyFile(FileWrapper file, String name, String mode) {
        file.setMode(mode);
        this.name = name;
        this.mode = mode;
        this.softspace = false;
        this.closed = false;
        this.file = mode.indexOf(98) < 0 ? new TextWrapper(file) : file;
    }

    public PyFile(InputStream istream, OutputStream ostream, String name, String mode) {
        this(new IOStreamWrapper(PyFile._pb(istream, mode), ostream), name, mode);
    }

    public PyFile(InputStream istream, OutputStream ostream, String name) {
        this(istream, ostream, name, "r+");
    }

    public PyFile(InputStream istream, OutputStream ostream) {
        this(istream, ostream, "<???>", "r+");
    }

    public PyFile(InputStream istream, String name, String mode) {
        this(new InputStreamWrapper(PyFile._pb(istream, mode)), name, mode);
    }

    public PyFile(InputStream istream, String name) {
        this(istream, name, "r");
    }

    public PyFile(InputStream istream) {
        this(istream, "<???>", "r");
    }

    public PyFile(OutputStream ostream, String name, String mode) {
        this(new OutputStreamWrapper(ostream), name, mode);
    }

    public PyFile(OutputStream ostream, String name) {
        this(ostream, name, "w");
    }

    public PyFile(OutputStream ostream) {
        this(ostream, "<???>", "w");
    }

    public PyFile(Writer ostream, String name, String mode) {
        this(new WriterWrapper(ostream), name, mode);
    }

    public PyFile(Writer ostream, String name) {
        this(ostream, name, "w");
    }

    public PyFile(Writer ostream) {
        this(ostream, "<???>", "w");
    }

    public PyFile(RandomAccessFile file, String name, String mode) {
        this(new RFileWrapper(file), name, mode);
    }

    public PyFile(RandomAccessFile file, String name) {
        this(file, name, "r+");
    }

    public PyFile(RandomAccessFile file) {
        this(file, "<???>", "r+");
    }

    public PyFile(String name, String mode, int bufsize) {
        this(PyFile._setup(name, mode, bufsize), name, mode);
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        if (name != "softspace") {
            if (name == "mode" || name == "closed" || name == "name") {
                throw Py.TypeError("readonly attribute: " + name);
            }
            throw Py.AttributeError(name);
        }
        this.softspace = value.__nonzero__();
    }

    @Override
    public Object __tojava__(Class cls) {
        Object o = null;
        try {
            o = this.file.__tojava__(cls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (o == null) {
            o = super.__tojava__(cls);
        }
        return o;
    }

    private static FileWrapper _setup(String name, String mode, int bufsize) {
        int c1 = 32;
        int c2 = 32;
        int c3 = 32;
        int n = mode.length();
        if (n > 0) {
            c1 = mode.charAt(0);
            if (n > 1) {
                c2 = mode.charAt(1);
                if (n > 2) {
                    c3 = mode.charAt(2);
                }
            }
        }
        String jmode = "r";
        if (c1 == 114) {
            jmode = c2 == 43 || c3 == 43 ? "rw" : "r";
        } else if (c1 == 119 || c1 == 97) {
            jmode = "rw";
        }
        try {
            File f = new File(name);
            if (c1 == 119) {
                FileOutputStream fo = new FileOutputStream(f);
                fo.close();
                fo = null;
            }
            RandomAccessFile rfile = new RandomAccessFile(f, jmode);
            RFileWrapper iofile = new RFileWrapper(rfile);
            if (c1 == 97) {
                iofile.seek(0L, 2);
            }
            return iofile;
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public PyString read(int n) {
        if (this.closed) {
            this.err_closed();
        }
        StringBuffer data = new StringBuffer();
        try {
            String s;
            int len;
            while (n != 0 && (len = (s = this.file.read(n)).length()) != 0) {
                data.append(s);
                if (n <= 0 || (n -= len) > 0) continue;
                break;
            }
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
        return new PyString(data.toString());
    }

    public PyString read() {
        return this.read(-1);
    }

    public PyString readline(int max) {
        if (this.closed) {
            this.err_closed();
        }
        StringBuffer s = new StringBuffer();
        while (max < 0 || s.length() < max) {
            int c;
            try {
                c = this.file.read();
            }
            catch (IOException e) {
                throw Py.IOError(e);
            }
            if (c < 0) break;
            s.append((char)c);
            if ((char)c != '\n') continue;
            break;
        }
        return new PyString(s.toString());
    }

    public PyString readline() {
        return this.readline(-1);
    }

    public PyObject readlines(int sizehint) {
        PyString s;
        int len;
        if (this.closed) {
            this.err_closed();
        }
        PyList list = new PyList();
        int bytesread = 0;
        while ((len = (s = this.readline()).__len__()) != 0) {
            list.append(s);
            if (sizehint <= 0 || (bytesread += len) <= sizehint) continue;
            break;
        }
        return list;
    }

    public PyObject readlines() {
        return this.readlines(0);
    }

    public void write(String s) {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.write(s);
            this.softspace = false;
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void writelines(PyObject a) {
        PyObject item = null;
        int i = 0;
        while ((item = a.__finditem__(i)) != null) {
            if (!(item instanceof PyString)) {
                throw Py.TypeError("writelines() argument must be a sequence of strings");
            }
            this.write(item.toString());
            ++i;
        }
    }

    public long tell() {
        if (this.closed) {
            this.err_closed();
        }
        try {
            return this.file.tell();
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void seek(long pos, int how) {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.seek(pos, how);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void seek(long pos) {
        this.seek(pos, 0);
    }

    public void flush() {
        if (this.closed) {
            this.err_closed();
        }
        try {
            this.file.flush();
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
        this.closed = true;
        this.file = new FileWrapper();
    }

    public void truncate() {
        try {
            this.file.truncate(this.file.tell());
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public void truncate(long position) {
        try {
            this.file.truncate(position);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public PyObject fileno() {
        throw Py.IOError("fileno() is not supported in jpython");
    }

    public String toString() {
        return "<file " + this.name + ", mode " + this.mode + " at " + Py.id(this) + ">";
    }

    private void err_closed() {
        throw Py.ValueError("I/O operation on closed file");
    }

    private static class TextWrapper
    extends FileWrapper {
        private FileWrapper file;
        private String sep;
        private boolean sep_is_nl;

        public TextWrapper(FileWrapper file) {
            this.file = file;
            this.sep = System.getProperty("line.separator");
            this.sep_is_nl = this.sep == "\n";
        }

        @Override
        public String read(int n) throws IOException {
            int c;
            String s = this.file.read(n);
            int index = s.indexOf(13);
            if (index < 0) {
                return s;
            }
            StringBuffer buf = new StringBuffer();
            int start = 0;
            int end = s.length();
            do {
                buf.append(s.substring(start, index));
                buf.append('\n');
                start = index + 1;
                if (start >= end || s.charAt(start) != '\n') continue;
                ++start;
            } while ((index = s.indexOf(13, start)) >= 0);
            buf.append(s.substring(start));
            if (s.endsWith("\r") && this.file.available() > 0 && (c = this.file.read()) != -1 && c != 10) {
                this.file.unread(c);
            }
            return buf.toString();
        }

        @Override
        public int read() throws IOException {
            int c = this.file.read();
            if (c != 13) {
                return c;
            }
            if (this.file.available() > 0 && (c = this.file.read()) != -1 && c != 10) {
                this.file.unread(c);
            }
            return 10;
        }

        @Override
        public void write(String s) throws IOException {
            int index;
            if (!this.sep_is_nl && (index = s.indexOf(10)) >= 0) {
                StringBuffer buf = new StringBuffer();
                int start = 0;
                do {
                    buf.append(s.substring(start, index));
                    buf.append(this.sep);
                } while ((index = s.indexOf(10, start = index + 1)) >= 0);
                buf.append(s.substring(start));
                s = buf.toString();
            }
            this.file.write(s);
        }

        @Override
        public long tell() throws IOException {
            return this.file.tell();
        }

        @Override
        public void seek(long pos, int how) throws IOException {
            this.file.seek(pos, how);
        }

        @Override
        public void flush() throws IOException {
            this.file.flush();
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }

        @Override
        public void truncate(long position) throws IOException {
            this.file.truncate(position);
        }

        @Override
        public Object __tojava__(Class cls) throws IOException {
            return this.file.__tojava__(cls);
        }
    }

    private static class RFileWrapper
    extends FileWrapper {
        protected static final int defaultBufferSize = 4096;
        protected RandomAccessFile file;
        protected long filePosition;
        protected byte[] buffer;
        protected long bufferStart;
        protected long dataEnd;
        protected int dataSize;
        protected boolean endOfFile;
        boolean bufferModified = false;

        public RFileWrapper(RandomAccessFile file) {
            this(file, 8092);
        }

        public RFileWrapper(RandomAccessFile file, int bufferSize) {
            this.file = file;
            this.bufferStart = 0L;
            this.dataEnd = 0L;
            this.dataSize = 0;
            this.filePosition = 0L;
            this.buffer = new byte[bufferSize];
            this.endOfFile = false;
        }

        @Override
        public String read(int n) throws IOException {
            byte[] buf;
            if (n < 0 && (n = (int)(this.file.length() - this.file.getFilePointer())) < 0) {
                n = 0;
            }
            if ((n = this.readBytes(buf = new byte[n], 0, n)) < 0) {
                n = 0;
            }
            return this.getString(buf, 0, n);
        }

        private int readBytes(byte[] b, int off, int len) throws IOException {
            if (this.endOfFile) {
                return -1;
            }
            int bytesAvailable = (int)(this.dataEnd - this.filePosition);
            if (bytesAvailable < 1) {
                this.seek(this.filePosition, 0);
                return this.readBytes(b, off, len);
            }
            int copyLength = bytesAvailable >= len ? len : bytesAvailable;
            System.arraycopy(this.buffer, (int)(this.filePosition - this.bufferStart), b, off, copyLength);
            this.filePosition += (long)copyLength;
            if (copyLength < len) {
                int extraCopy = len - copyLength;
                if (extraCopy > this.buffer.length) {
                    this.file.seek(this.filePosition);
                    extraCopy = this.file.read(b, off + copyLength, len - copyLength);
                } else {
                    this.seek(this.filePosition, 0);
                    if (!this.endOfFile) {
                        extraCopy = extraCopy > this.dataSize ? this.dataSize : extraCopy;
                        System.arraycopy(this.buffer, 0, b, off + copyLength, extraCopy);
                    } else {
                        extraCopy = -1;
                    }
                }
                if (extraCopy > 0) {
                    this.filePosition += (long)extraCopy;
                    return copyLength + extraCopy;
                }
            }
            return copyLength;
        }

        @Override
        public int read() throws IOException {
            if (this.filePosition < this.dataEnd) {
                return this.buffer[(int)(this.filePosition++ - this.bufferStart)] & 0xFF;
            }
            if (this.endOfFile) {
                return -1;
            }
            this.seek(this.filePosition, 0);
            return this.read();
        }

        @Override
        public int available() throws IOException {
            return 1;
        }

        @Override
        public void unread(int c) throws IOException {
            --this.filePosition;
        }

        @Override
        public void write(String s) throws IOException {
            byte[] b = this.getBytes(s);
            int len = b.length;
            if (len < this.buffer.length) {
                long myDataEnd;
                int spaceInBuffer = 0;
                int copyLength = 0;
                if (this.filePosition >= this.bufferStart) {
                    spaceInBuffer = (int)(this.bufferStart + (long)this.buffer.length - this.filePosition);
                }
                if (spaceInBuffer > 0) {
                    copyLength = spaceInBuffer > len ? len : spaceInBuffer;
                    System.arraycopy(b, 0, this.buffer, (int)(this.filePosition - this.bufferStart), copyLength);
                    this.bufferModified = true;
                    myDataEnd = this.filePosition + (long)copyLength;
                    this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)copyLength;
                }
                if (copyLength < len) {
                    this.seek(this.filePosition, 0);
                    System.arraycopy(b, copyLength, this.buffer, (int)(this.filePosition - this.bufferStart), len - copyLength);
                    this.bufferModified = true;
                    myDataEnd = this.filePosition + (long)(len - copyLength);
                    this.dataEnd = myDataEnd > this.dataEnd ? myDataEnd : this.dataEnd;
                    this.dataSize = (int)(this.dataEnd - this.bufferStart);
                    this.filePosition += (long)(len - copyLength);
                }
            } else {
                if (this.bufferModified) {
                    this.flush();
                    this.dataSize = 0;
                    this.bufferStart = this.dataEnd = (long)0;
                }
                this.file.write(b, 0, len);
                this.filePosition += (long)len;
            }
        }

        @Override
        public long tell() throws IOException {
            return this.filePosition;
        }

        @Override
        public void seek(long pos, int how) throws IOException {
            if (how == 1) {
                pos += this.filePosition;
            } else if (how == 2) {
                pos += this.file.length();
            }
            if (pos < 0L) {
                pos = 0L;
            }
            if (pos >= this.bufferStart && pos < this.dataEnd) {
                this.filePosition = pos;
                this.endOfFile = false;
                return;
            }
            if (this.bufferModified) {
                this.flush();
            }
            this.file.seek(pos);
            this.bufferStart = this.filePosition = this.file.getFilePointer();
            this.dataSize = this.file.read(this.buffer);
            if (this.dataSize < 0) {
                this.dataSize = 0;
                this.endOfFile = true;
            } else {
                this.endOfFile = false;
            }
            this.dataEnd = this.bufferStart + (long)this.dataSize;
        }

        @Override
        public void flush() throws IOException {
            this.file.seek(this.bufferStart);
            this.file.write(this.buffer, 0, this.dataSize);
            this.bufferModified = false;
            this.file.getFD().sync();
        }

        @Override
        public void close() throws IOException {
            if (this.writing && this.bufferModified) {
                this.file.seek(this.bufferStart);
                this.file.write(this.buffer, 0, this.dataSize);
            }
            this.file.close();
        }

        @Override
        public void truncate(long position) throws IOException {
            this.flush();
            try {
                Method m = this.file.getClass().getMethod("setLength", Long.TYPE);
                m.invoke((Object)this.file, new Long(position));
            }
            catch (NoSuchMethodException exc) {
                super.truncate(position);
            }
            catch (SecurityException exc) {
                super.truncate(position);
            }
            catch (IllegalAccessException exc) {
                super.truncate(position);
            }
            catch (InvocationTargetException exc) {
                if (exc.getTargetException() instanceof IOException) {
                    throw (IOException)exc.getTargetException();
                }
                super.truncate(position);
            }
        }

        @Override
        public Object __tojava__(Class cls) throws IOException {
            if (OutputStream.class.isAssignableFrom(cls) && this.writing) {
                return new FileOutputStream(this.file.getFD());
            }
            if (InputStream.class.isAssignableFrom(cls) && this.reading) {
                return new FileInputStream(this.file.getFD());
            }
            return super.__tojava__(cls);
        }
    }

    private static class WriterWrapper
    extends FileWrapper {
        private Writer writer;
        private static final int MAX_WRITE = 30000;

        public WriterWrapper(Writer s) {
            this.writer = s;
        }

        @Override
        public void write(String s) throws IOException {
            this.writer.write(s);
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static class IOStreamWrapper
    extends InputStreamWrapper {
        private OutputStream ostream;

        public IOStreamWrapper(InputStream istream, OutputStream ostream) {
            super(istream);
            this.ostream = ostream;
        }

        @Override
        public void write(String s) throws IOException {
            this.ostream.write(this.getBytes(s));
        }

        @Override
        public void flush() throws IOException {
            this.ostream.flush();
        }

        @Override
        public void close() throws IOException {
            this.ostream.close();
            this.istream.close();
        }

        @Override
        public Object __tojava__(Class cls) throws IOException {
            if (OutputStream.class.isAssignableFrom(cls)) {
                return this.ostream;
            }
            return super.__tojava__(cls);
        }
    }

    private static class OutputStreamWrapper
    extends FileWrapper {
        private OutputStream ostream;
        private static final int MAX_WRITE = 30000;

        public OutputStreamWrapper(OutputStream s) {
            this.ostream = s;
        }

        @Override
        public void write(String s) throws IOException {
            int sz;
            byte[] bytes = this.getBytes(s);
            int n = bytes.length;
            for (int i = 0; i < n; i += sz) {
                sz = n - i;
                sz = sz > 30000 ? 30000 : sz;
                this.ostream.write(bytes, i, sz);
            }
        }

        @Override
        public void flush() throws IOException {
            this.ostream.flush();
        }

        @Override
        public void close() throws IOException {
            this.ostream.close();
        }

        @Override
        public Object __tojava__(Class cls) throws IOException {
            if (OutputStream.class.isAssignableFrom(cls)) {
                return this.ostream;
            }
            return null;
        }
    }

    private static class InputStreamWrapper
    extends FileWrapper {
        InputStream istream;

        public InputStreamWrapper(InputStream s) {
            this.istream = s;
        }

        @Override
        public String read(int n) throws IOException {
            if (n == 0) {
                return "";
            }
            if (n < 0) {
                byte[] buf = new byte[1024];
                StringBuffer sbuf = new StringBuffer();
                int read = 0;
                while (read >= 0) {
                    sbuf.append(this.getString(buf, 0, read));
                    read = this.istream.read(buf);
                }
                return sbuf.toString();
            }
            int avail = this.istream.available();
            byte[] buf = new byte[n];
            int read = this.istream.read(buf);
            if (read < 0) {
                return "";
            }
            return new String(buf, 0, 0, read);
        }

        @Override
        public int read() throws IOException {
            return this.istream.read();
        }

        @Override
        public int available() throws IOException {
            return this.istream.available();
        }

        @Override
        public void unread(int c) throws IOException {
            ((PushbackInputStream)this.istream).unread(c);
        }

        @Override
        public void close() throws IOException {
            this.istream.close();
        }

        @Override
        public Object __tojava__(Class cls) throws IOException {
            if (InputStream.class.isAssignableFrom(cls)) {
                return this.istream;
            }
            return null;
        }
    }

    private static class FileWrapper {
        protected boolean reading;
        protected boolean writing;
        protected boolean binary;

        private FileWrapper() {
        }

        void setMode(String mode) {
            this.reading = mode.indexOf(114) >= 0;
            this.writing = mode.indexOf(119) >= 0 || mode.indexOf("+") >= 0 || mode.indexOf(97) >= 0;
            this.binary = mode.indexOf(98) >= 0;
        }

        public String read(int n) throws IOException {
            throw new IOException("file not open for reading");
        }

        public int read() throws IOException {
            throw new IOException("file not open for reading");
        }

        public int available() throws IOException {
            throw new IOException("file not open for reading");
        }

        public void unread(int c) throws IOException {
            throw new IOException("file doesn't support unread");
        }

        public void write(String s) throws IOException {
            throw new IOException("file not open for writing");
        }

        public long tell() throws IOException {
            throw new IOException("file doesn't support tell/seek");
        }

        public void seek(long pos, int how) throws IOException {
            throw new IOException("file doesn't support tell/seek");
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        public void truncate(long position) throws IOException {
            throw new IOException("file doesn't support truncate");
        }

        public Object __tojava__(Class cls) throws IOException {
            return null;
        }

        protected byte[] getBytes(String s) {
            if (this.binary) {
                byte[] buf = new byte[s.length()];
                s.getBytes(0, s.length(), buf, 0);
                return buf;
            }
            return s.getBytes();
        }

        protected String getString(byte[] buf, int offset, int len) {
            if (this.binary) {
                return new String(buf, 0, offset, len);
            }
            return new String(buf, offset, len);
        }
    }
}

