/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class PyFloat
extends PyObject {
    private double value;
    public static PyClass __class__;

    public PyFloat(double v) {
        this.value = v;
    }

    public PyFloat(float v) {
        this((double)v);
    }

    @Override
    public String safeRepr() throws PyIgnoreMethodTag {
        return "'float' object";
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        String s = Double.toString(this.value);
        if (s.indexOf(69) == -1) {
            int n;
            while ((n = s.length()) > 2 && s.charAt(n - 1) == '0' && s.charAt(n - 2) != '.') {
                s = s.substring(0, n - 1);
            }
        }
        return s;
    }

    @Override
    public int hashCode() {
        double intPart = Math.floor(this.value);
        double fractPart = this.value - intPart;
        if (fractPart == 0.0) {
            if (intPart <= 2.147483647E9 && intPart >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long v = Double.doubleToLongBits(this.value);
        return (int)v ^ (int)(v >> 32);
    }

    @Override
    public boolean __nonzero__() {
        return this.value != 0.0;
    }

    @Override
    public Object __tojava__(Class c) {
        if (c == Double.TYPE || c == Number.class || c == Double.class || c == Object.class || c == Serializable.class) {
            return new Double(this.value);
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(this.value);
        }
        return super.__tojava__(c);
    }

    @Override
    public int __cmp__(PyObject other) {
        double v = ((PyFloat)other).value;
        return this.value < v ? -1 : (this.value > v ? 1 : 0);
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyFloat) {
            return other;
        }
        if (other instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)other).getValue());
        }
        if (other instanceof PyLong) {
            return new PyFloat(((PyLong)other).doubleValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private static final double coerce(PyObject other) {
        if (other instanceof PyFloat) {
            return ((PyFloat)other).value;
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        if (other instanceof PyLong) {
            return ((PyLong)other).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value + rightv);
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.__add__(left);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value - rightv);
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(leftv - this.value);
    }

    @Override
    public PyObject __mul__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value * rightv);
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        return this.__mul__(left);
    }

    @Override
    public PyObject __div__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / rightv);
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(leftv / this.value);
    }

    private static double modulo(double x, double y) {
        if (y == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double z = Math.IEEEremainder(x, y);
        if (z * y < 0.0) {
            z += y;
        }
        return z;
    }

    @Override
    public PyObject __mod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(PyFloat.modulo(this.value, rightv));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(PyFloat.modulo(leftv, this.value));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(this.value / rightv);
        return new PyTuple(new PyObject[]{new PyFloat(z), new PyFloat(this.value - z * rightv)});
    }

    @Override
    public PyObject __rdivmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(leftv / this.value);
        return new PyTuple(new PyObject[]{new PyFloat(z), new PyFloat(leftv - z * this.value)});
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyFloat.canCoerce(modulo)) {
            return null;
        }
        return PyFloat._pow(this.value, PyFloat.coerce(right), modulo);
    }

    @Override
    public PyObject __rpow__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(left), this.value, null);
    }

    private static PyFloat _pow(double value, double iw, PyObject modulo) {
        if (iw == 0.0) {
            if (modulo != null) {
                return new PyFloat(PyFloat.modulo(1.0, PyFloat.coerce(modulo)));
            }
            return new PyFloat(1.0);
        }
        if (value == 0.0) {
            if (iw < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        double ret = Math.pow(value, iw);
        if (modulo == null) {
            return new PyFloat(ret);
        }
        return new PyFloat(PyFloat.modulo(ret, PyFloat.coerce(modulo)));
    }

    @Override
    public PyObject __neg__() {
        return new PyFloat(-this.value);
    }

    @Override
    public PyObject __pos__() {
        return this;
    }

    @Override
    public PyObject __abs__() {
        if (this.value >= 0.0) {
            return this;
        }
        return this.__neg__();
    }

    @Override
    public PyInteger __int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        throw Py.OverflowError("float too large to convert");
    }

    @Override
    public PyLong __long__() {
        return new PyLong(this.value);
    }

    @Override
    public PyFloat __float__() {
        return this;
    }

    @Override
    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    protected PyClass getPyClass() {
        return __class__;
    }
}

