/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyFloat;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyInteger
extends PyObject {
    private int value;
    public static PyClass __class__;

    public PyInteger(int v) {
        this.value = v;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String safeRepr() throws PyIgnoreMethodTag {
        return "'int' object";
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public boolean __nonzero__() {
        return this.value != 0;
    }

    @Override
    public Object __tojava__(Class c) {
        if (c == Integer.TYPE || c == Number.class || c == Object.class || c == Integer.class || c == Serializable.class) {
            return new Integer(this.value);
        }
        if (c == Boolean.TYPE || c == Boolean.class) {
            return new Boolean(this.value != 0);
        }
        if (c == Byte.TYPE || c == Byte.class) {
            return new Byte((byte)this.value);
        }
        if (c == Short.TYPE || c == Short.class) {
            return new Short((short)this.value);
        }
        if (c == Long.TYPE || c == Long.class) {
            return new Long(this.value);
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(this.value);
        }
        if (c == Double.TYPE || c == Double.class) {
            return new Double(this.value);
        }
        return super.__tojava__(c);
    }

    @Override
    public int __cmp__(PyObject other) {
        int v = ((PyInteger)other).value;
        return this.value < v ? -1 : (this.value > v ? 1 : 0);
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyInteger) {
            return other;
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyInteger;
    }

    private static final int coerce(PyObject other) {
        if (other instanceof PyInteger) {
            return ((PyInteger)other).value;
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int a = this.value;
        int rightv = PyInteger.coerce(right);
        int b = rightv;
        int x = a + b;
        if ((x ^ a) < 0 && (x ^ b) < 0) {
            throw Py.OverflowError("integer addition: " + this + " + " + right);
        }
        return Py.newInteger(x);
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.__add__(left);
    }

    private static PyInteger _sub(int a, int b) {
        int x = a - b;
        if ((x ^ a) < 0 && (x ^ ~b) < 0) {
            throw Py.OverflowError("integer subtraction: " + a + " - " + b);
        }
        return Py.newInteger(x);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return PyInteger._sub(this.value, PyInteger.coerce(right));
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return PyInteger._sub(PyInteger.coerce(left), this.value);
    }

    @Override
    public PyObject __mul__(PyObject right) {
        if (right instanceof PySequence) {
            return ((PySequence)right).repeat(this.value);
        }
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        double x = this.value;
        if ((x *= (double)rightv) > 2.147483647E9 || x < -2.147483648E9) {
            throw Py.OverflowError("integer multiplication: " + this + " * " + right);
        }
        return Py.newInteger((int)x);
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        return this.__mul__(left);
    }

    private static int divide(int x, int y) {
        if (y == 0) {
            throw Py.ZeroDivisionError("integer division or modulo");
        }
        if (y == -1 && x < 0 && x == -x) {
            throw Py.OverflowError("integer division: " + x + " + " + y);
        }
        int xdivy = x / y;
        int xmody = x - xdivy * y;
        if (xmody != 0 && (y ^ xmody) < 0) {
            xmody += y;
            --xdivy;
        }
        return xdivy;
    }

    @Override
    public PyObject __div__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(this.value, PyInteger.coerce(right)));
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.value));
    }

    private static int modulo(int x, int y, int xdivy) {
        return x - xdivy * y;
    }

    @Override
    public PyObject __mod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        return Py.newInteger(PyInteger.modulo(this.value, rightv, PyInteger.divide(this.value, rightv)));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        return Py.newInteger(PyInteger.modulo(leftv, this.value, PyInteger.divide(leftv, this.value)));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int xdivy = PyInteger.divide(this.value, rightv);
        return new PyTuple(new PyObject[]{new PyInteger(xdivy), new PyInteger(PyInteger.modulo(this.value, rightv, xdivy))});
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyInteger.canCoerce(modulo)) {
            return null;
        }
        return PyInteger._pow(this.value, PyInteger.coerce(right), modulo);
    }

    public PyObject __rpow__(PyObject left, PyObject modulo) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        if (modulo != null && !PyInteger.canCoerce(modulo)) {
            return null;
        }
        return PyInteger._pow(PyInteger.coerce(left), this.value, modulo);
    }

    private static PyInteger _pow(int value, int pow, PyObject modulo) {
        int mod = 0;
        long tmp = value;
        boolean neg = false;
        if (tmp < 0L) {
            tmp = -tmp;
            neg = (pow & 1) != 0;
        }
        long result = 1L;
        if (pow < 0) {
            if (value != 0) {
                throw Py.ValueError("cannot raise integer to a negative power");
            }
            throw Py.ZeroDivisionError("cannot raise 0 to a negative power");
        }
        if (modulo != null && (mod = PyInteger.coerce(modulo)) == 0) {
            throw Py.ValueError("pow(x, y, z) with z==0");
        }
        while (pow > 0) {
            if ((pow & 1) != 0) {
                result *= tmp;
                if (mod != 0) {
                    result %= (long)mod;
                }
                if (result > Integer.MAX_VALUE) {
                    throw Py.OverflowError("integer pow()");
                }
            }
            if ((pow >>= 1) == 0) break;
            tmp *= tmp;
            if (mod != 0) {
                tmp %= (long)mod;
            }
            if (tmp <= Integer.MAX_VALUE) continue;
            throw Py.OverflowError("integer pow()");
        }
        int ret = (int)result;
        if (neg) {
            ret = -ret;
        }
        if (mod != 0) {
            ret = PyInteger.modulo(ret, mod, PyInteger.divide(ret, mod));
        }
        return Py.newInteger(ret);
    }

    @Override
    public PyObject __lshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            return null;
        }
        int rightv = ((PyInteger)right).value;
        if (rightv > 31) {
            return new PyInteger(0);
        }
        return Py.newInteger(this.value << rightv);
    }

    @Override
    public PyObject __rshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            return null;
        }
        int rightv = ((PyInteger)right).value;
        return Py.newInteger(this.value >> rightv);
    }

    @Override
    public PyObject __and__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            return null;
        }
        int rightv = ((PyInteger)right).value;
        return Py.newInteger(this.value & rightv);
    }

    @Override
    public PyObject __xor__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            return null;
        }
        int rightv = ((PyInteger)right).value;
        return Py.newInteger(this.value ^ rightv);
    }

    @Override
    public PyObject __or__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            return null;
        }
        int rightv = ((PyInteger)right).value;
        return Py.newInteger(this.value | rightv);
    }

    @Override
    public PyObject __neg__() {
        int x = -this.value;
        if (this.value < 0 && x < 0) {
            throw Py.OverflowError("integer negation");
        }
        return Py.newInteger(x);
    }

    @Override
    public PyObject __pos__() {
        return this;
    }

    @Override
    public PyObject __abs__() {
        if (this.value >= 0) {
            return this;
        }
        return this.__neg__();
    }

    @Override
    public PyObject __invert__() {
        return Py.newInteger(~this.value);
    }

    @Override
    public PyInteger __int__() {
        return this;
    }

    @Override
    public PyLong __long__() {
        return new PyLong(this.value);
    }

    @Override
    public PyFloat __float__() {
        return new PyFloat((double)this.value);
    }

    @Override
    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    @Override
    public PyString __oct__() {
        if (this.value < 0) {
            return new PyString("0" + Long.toString(0x100000000L + (long)this.value, 8));
        }
        if (this.value > 0) {
            return new PyString("0" + Integer.toString(this.value, 8));
        }
        return new PyString("0");
    }

    @Override
    public PyString __hex__() {
        if (this.value < 0) {
            return new PyString("0x" + Long.toString(0x100000000L + (long)this.value, 16));
        }
        return new PyString("0x" + Integer.toString(this.value, 16));
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    protected PyClass getPyClass() {
        return __class__;
    }
}

