/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.Interesting;
import com.hp.hpl.guess.util.intervals.Tracker;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Modifier;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInstance;
import org.python.core.PyJavaClass;
import org.python.core.PyObject;
import org.python.core.PyReflectedConstructor;
import org.python.core.PyString;

public class PyJavaInstance
extends PyInstance
implements Externalizable {
    public PyJavaInstance() {
    }

    public PyJavaInstance(PyJavaClass iclass) {
        super(iclass, null);
    }

    public PyJavaInstance(Object proxy) {
        super(PyJavaClass.lookup(proxy.getClass()), null);
        this.javaProxy = proxy;
        if (proxy instanceof Node) {
            this.nodeType = true;
        } else if (proxy instanceof Edge) {
            this.edgeType = true;
        } else if (proxy instanceof Interesting) {
            this.typeOfInterest = true;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object o;
        this.javaProxy = o = in.readObject();
        this.__class__ = PyJavaClass.lookup(o.getClass());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.javaProxy);
    }

    @Override
    public void __init__(PyObject[] args, String[] keywords) {
        PyReflectedConstructor init;
        Class pc = this.__class__.proxyClass;
        if (pc != null) {
            int mods = pc.getModifiers();
            if (Modifier.isInterface(mods)) {
                throw Py.TypeError("can't instantiate interface (" + this.__class__.__name__ + ")");
            }
            if (Modifier.isAbstract(mods)) {
                throw Py.TypeError("can't instantiate abstract class (" + this.__class__.__name__ + ")");
            }
        }
        if ((init = ((PyJavaClass)this.__class__).__init__) == null) {
            throw Py.TypeError("no public constructors for " + this.__class__.__name__);
        }
        init.__call__((PyObject)this, args, keywords);
    }

    @Override
    protected void noField(String name, PyObject value) {
        PyObject method = this.__class__.lookup("__setattr__", false);
        if (method == null) {
            throw Py.TypeError("can't set arbitrary attribute in java instance: " + name);
        }
        method.__call__((PyObject)this, new PyString(name), value);
    }

    @Override
    protected PyObject ifindfunction(String name) {
        try {
            PyObject getter = this.__class__.__getattr__;
            if (getter == null) {
                getter = this.__class__.lookup("__getattr__", false);
            }
            if (getter == null) {
                return null;
            }
            try {
                return getter.__call__(this, new PyString(name));
            }
            catch (PyException exc) {
                if (Py.matchException(exc, Py.AttributeError)) {
                    return null;
                }
                throw exc;
            }
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    protected void unassignableField(String name, PyObject value) {
        throw Py.TypeError("can't assign to this attribute in java instance: " + name);
    }

    @Override
    public int hashCode() {
        if (this.javaProxy != null) {
            return this.javaProxy.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public PyObject _is(PyObject o) {
        if (o instanceof PyJavaInstance) {
            return this.javaProxy == ((PyJavaInstance)o).javaProxy ? Py.One : Py.Zero;
        }
        return Py.Zero;
    }

    @Override
    public PyObject _isnot(PyObject o) {
        return this._is(o).__not__();
    }

    @Override
    public int __cmp__(PyObject o) {
        if (!(o instanceof PyJavaInstance)) {
            return -2;
        }
        PyJavaInstance i = (PyJavaInstance)o;
        if (this.javaProxy.equals(i.javaProxy)) {
            return 0;
        }
        return -2;
    }

    @Override
    public PyString __str__() {
        String toRet = this.javaProxy.toString();
        if (this.javaProxy instanceof Node || this.javaProxy instanceof Edge || this.javaProxy instanceof Interesting) {
            Tracker.addNode(toRet.length() - 1, this);
        }
        Tracker.incrementLocation(toRet.length());
        return new PyString(toRet);
    }

    @Override
    public PyString __str2__() {
        return new PyString(this.javaProxy.toString());
    }

    public String toString() {
        return this.javaProxy.toString();
    }

    @Override
    public PyString __repr__() {
        return this.__str__();
    }

    @Override
    public void __delattr__(String attr) {
        throw Py.TypeError("can't delete attr from java instance: " + attr);
    }
}

