/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import com.hp.hpl.guess.util.AnnoHashSet;
import com.hp.hpl.guess.util.AnnoVector;
import com.hp.hpl.guess.util.intervals.Tracker;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.python.core.ClassDictInit;
import org.python.core.ListFunctions;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class PyList
extends PySequence
implements ClassDictInit,
Collection {
    protected PyObject[] list;
    protected int length;
    protected static PyObject __methods__;
    private static final int MINSIZE = 10;
    private static final int STACKSIZE = 64;
    public static PyClass __class__;

    public static void classDictInit(PyObject dict) {
        PySequence.classDictInit(dict);
        dict.__setitem__("reverse", (PyObject)new ListFunctions("reverse", 1, 0));
        dict.__setitem__("sort", (PyObject)new ListFunctions("sort", 2, 0, 1));
        dict.__setitem__("__len__", (PyObject)new ListFunctions("__len__", 3, 0));
        dict.__setitem__("append", (PyObject)new ListFunctions("append", 10, 1));
        dict.__setitem__("count", (PyObject)new ListFunctions("count", 11, 1));
        dict.__setitem__("index", (PyObject)new ListFunctions("index", 12, 1));
        dict.__setitem__("remove", (PyObject)new ListFunctions("remove", 13, 1));
        dict.__setitem__("extend", (PyObject)new ListFunctions("extend", 14, 1));
        dict.__setitem__("__add__", (PyObject)new ListFunctions("__add__", 15, 1));
        dict.__setitem__("insert", (PyObject)new ListFunctions("insert", 20, 2));
        dict.__setitem__("initModule", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("hashCode", null);
    }

    public PyList() {
        this(Py.EmptyObjects);
    }

    public PyList(Vector ilist) {
        this(new PyObject[ilist.size()]);
        for (int i = 0; i < ilist.size(); ++i) {
            this.list[i] = (PyObject)ilist.elementAt(i);
        }
    }

    public PyList(PyObject[] elements) {
        this.list = elements;
        this.length = elements.length;
    }

    public PyList(Collection collection) {
        this.length = collection.size();
        this.list = new PyObject[this.length];
        int i = 0;
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.list[i] = Py.java2py(it.next());
            ++i;
        }
        if (collection instanceof AnnoHashSet) {
            this.annotation = ((AnnoHashSet)collection).annotation;
        } else if (collection instanceof AnnoVector) {
            this.annotation = ((AnnoVector)collection).annotation;
        }
    }

    @Override
    public String safeRepr() throws PyIgnoreMethodTag {
        return "'list' object";
    }

    @Override
    public int __len__() {
        return this.length;
    }

    @Override
    public PyObject __findattr__(String name) {
        if (name.equals("__methods__")) {
            PyList mlist = (PyList)__methods__;
            PyObject[] methods = new PyString[mlist.length];
            for (int i = 0; i < mlist.length; ++i) {
                methods[i] = (PyString)mlist.list[i];
            }
            return new PyList(methods);
        }
        return super.__findattr__(name);
    }

    @Override
    protected PyObject get(int i) {
        return this.list[i];
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyList.sliceLength(start, stop, step);
        PyObject[] newList = new PyObject[n];
        if (step == 1) {
            System.arraycopy(this.list, start, newList, 0, stop - start);
            return new PyList(newList);
        }
        int j = 0;
        int i = start;
        while (j < n) {
            newList[j] = this.list[i];
            ++j;
            i += step;
        }
        return new PyList(newList);
    }

    @Override
    protected void del(int i) {
        --this.length;
        System.arraycopy(this.list, i + 1, this.list, i, this.length - i);
        this.list[this.length] = null;
    }

    @Override
    protected void delRange(int start, int stop, int step) {
        if (step != 1) {
            throw Py.ValueError("step size must be 1 for deleting list slice");
        }
        System.arraycopy(this.list, stop, this.list, start, this.length - stop);
        int newLength = this.length - (stop - start);
        int oldLength = this.length;
        for (int i = newLength; i < oldLength; ++i) {
            this.list[i] = null;
        }
        this.length = newLength;
    }

    @Override
    protected void set(int i, PyObject value) {
        this.list[i] = value;
    }

    @Override
    protected void setslice(int start, int stop, int step, PyObject value) {
        int i;
        PySequence seq;
        int n;
        int length;
        int newLength;
        if (!(value instanceof PySequence)) {
            throw Py.TypeError("rhs of setslice must be a sequence");
        }
        if (step != 1) {
            throw Py.ValueError("step size must be 1 for setting list slice");
        }
        if (stop < start) {
            stop = start;
        }
        if ((newLength = (length = this.length) - (stop - start) + (n = (seq = (PySequence)value).__len__())) > length || newLength < length) {
            this.resize(newLength);
            System.arraycopy(this.list, stop, this.list, stop + (newLength - length), length - stop);
            if (newLength < length) {
                for (i = newLength; i < length; ++i) {
                    this.list[i] = null;
                }
            }
        }
        PyObject[] otherList = null;
        if (value instanceof PyTuple) {
            otherList = ((PyTuple)value).list;
        }
        if (value instanceof PyList && (otherList = ((PyList)value).list) == this.list) {
            otherList = (PyObject[])otherList.clone();
        }
        if (otherList != null) {
            System.arraycopy(otherList, 0, this.list, start, n);
        } else {
            for (i = 0; i < n; ++i) {
                this.list[i + start] = seq.get(i);
            }
        }
    }

    @Override
    protected PyObject repeat(int count) {
        int l = this.length;
        PyObject[] newList = new PyObject[l * count];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(this.list, 0, newList, i * l, l);
        }
        return new PyList(newList);
    }

    @Override
    public PyObject __imul__(PyObject o) {
        if (!(o instanceof PyInteger) && !(o instanceof PyLong)) {
            throw Py.TypeError("can't multiply sequence to non-int");
        }
        int l = this.length;
        int count = o.__int__().getValue();
        this.resize(l * count);
        for (int i = 0; i < count; ++i) {
            System.arraycopy(this.list, 0, this.list, i * l, l);
        }
        return this;
    }

    @Override
    public PyObject __add__(PyObject genericOther) {
        if (genericOther instanceof PyList) {
            PyList other = (PyList)genericOther;
            PyObject[] newList = new PyObject[this.length + other.length];
            System.arraycopy(this.list, 0, newList, 0, this.length);
            System.arraycopy(other.list, 0, newList, this.length, other.length);
            return new PyList(newList);
        }
        return null;
    }

    @Override
    public PyString __str__() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return new PyString("[...]");
        }
        int start = Tracker.getLocation();
        StringBuffer buf = new StringBuffer("[");
        Tracker.incrementLocation(1);
        for (int i = 0; i < this.length - 1; ++i) {
            buf.append(this.list[i].__str__().toString());
            buf.append(", ");
            Tracker.incrementLocation(2);
        }
        if (this.length > 0) {
            buf.append(this.list[this.length - 1].__str__().toString());
        }
        buf.append("]");
        ts.exitRepr(this);
        String toRet = buf.toString();
        if (this.containsGraphElements()) {
            Tracker.addNode(start, toRet.length() - 1, this);
        }
        Tracker.setLocation(start + toRet.length());
        return new PyString(toRet);
    }

    public String toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        StringBuffer buf = new StringBuffer("[");
        for (int i = 0; i < this.length - 1; ++i) {
            buf.append(this.list[i].toString());
            buf.append(", ");
        }
        if (this.length > 0) {
            buf.append(this.list[this.length - 1].toString());
        }
        buf.append("]");
        ts.exitRepr(this);
        String toRet = buf.toString();
        return buf.toString();
    }

    protected void resize(int n) {
        if (this.list.length < n) {
            PyObject[] newList = new PyObject[(int)((double)n * 1.5)];
            System.arraycopy(this.list, 0, newList, 0, this.length);
            this.list = newList;
        }
        this.length = n;
    }

    public void append(PyObject o) {
        this.resize(this.length + 1);
        this.list[this.length - 1] = o;
    }

    public int count(PyObject o) {
        int count = 0;
        int n = this.length;
        PyObject[] list = this.list;
        for (int i = 0; i < n; ++i) {
            if (!list[i].equals(o)) continue;
            ++count;
        }
        return count;
    }

    public int index(PyObject o) {
        return this._index(o, "list.index(x): x not in list");
    }

    private int _index(PyObject o, String message) {
        int i;
        int n = this.length;
        PyObject[] list = this.list;
        for (i = 0; i < n && !list[i].equals(o); ++i) {
        }
        if (i == n) {
            throw Py.ValueError(message);
        }
        return i;
    }

    public void insert(int index, PyObject o) {
        if (index < 0) {
            index = 0;
        }
        if (index > this.length) {
            index = this.length;
        }
        this.resize(this.length + 1);
        System.arraycopy(this.list, index, this.list, index + 1, this.length - index - 1);
        this.list[index] = o;
    }

    public void remove(PyObject o) {
        this.del(this._index(o, "list.remove(x): x not in list"));
    }

    public void reverse() {
        int n = this.length;
        PyObject[] list = this.list;
        int j = n - 1;
        int i = 0;
        while (i < n / 2) {
            PyObject tmp = list[i];
            list[i] = list[j];
            list[j] = tmp;
            ++i;
            --j;
        }
    }

    public PyObject pop() {
        return this.pop(-1);
    }

    public PyObject pop(int n) {
        if (this.length == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (n < 0) {
            n += this.length;
        }
        if (n < 0 || n >= this.length) {
            throw Py.IndexError("pop index out of range");
        }
        PyObject v = this.list[n];
        this.setslice(n, n + 1, 1, Py.EmptyTuple);
        return v;
    }

    public void extend(PyObject o) {
        this.setslice(this.length, this.length, 1, o);
    }

    @Override
    public PyObject __iadd__(PyObject o) {
        this.extend(PyList.fastSequence(o, "argument to += must be a sequence"));
        return this;
    }

    private static int docompare(PyObject x, PyObject y, PyObject compare, String cmpop) {
        PyObject ret;
        if (compare == null) {
            if (cmpop == "<") {
                return x._lt(y).__nonzero__() ? -1 : 0;
            }
            if (cmpop == "<=") {
                return x._le(y).__nonzero__() ? -1 : 1;
            }
        }
        if ((ret = compare.__call__(new PyObject[]{x, y})) instanceof PyInteger) {
            int v = ((PyInteger)ret).getValue();
            return v < 0 ? -1 : (v > 0 ? 1 : 0);
        }
        throw Py.TypeError("comparision function must return int");
    }

    private static void insertionsort(PyObject[] array, int off, int size, PyObject compare) {
        int end = off + size;
        for (int i = off + 1; i < end; ++i) {
            PyObject q;
            PyObject key = array[i];
            int j = i;
            while (--j >= off && PyList.docompare(q = array[j], key, compare, "<=") > 0) {
                array[j + 1] = q;
                array[j] = key;
            }
        }
    }

    private static void quicksort(PyObject[] array, int off, int size, PyObject compare) {
        int[] lostack = new int[64];
        int[] histack = new int[64];
        lostack[0] = off;
        histack[0] = off + size;
        int top = 1;
        while (--top >= 0) {
            int hi = histack[top];
            int lo = lostack[top];
            int n = hi - lo;
            if (n < 10) continue;
            int l = lo + (n >> 1);
            int r = hi - 1;
            PyObject left = array[l];
            PyObject right = array[lo];
            if (PyList.docompare(left, right, compare, "<") < 0) {
                array[lo] = left;
                array[l] = right;
            }
            if (PyList.docompare(left = array[r], right = array[l], compare, "<") < 0) {
                array[r] = left;
                array[l] = right;
            }
            if (PyList.docompare(left = array[l], right = array[lo], compare, "<") < 0) {
                array[lo] = left;
                array[l] = right;
            }
            PyObject pivot = array[l];
            l = lo + 1;
            r = hi - 2;
            while (true) {
                if (l < hi && PyList.docompare(array[l], pivot, compare, "<") < 0) {
                    ++l;
                    continue;
                }
                while (r >= lo && PyList.docompare(pivot, array[r], compare, "<") < 0) {
                    --r;
                }
                if (l < r) {
                    PyObject tmp = array[l];
                    array[l] = array[r];
                    array[r] = tmp;
                    ++l;
                    --r;
                } else if (l == r) {
                    ++l;
                    --r;
                    break;
                }
                if (l > r) break;
            }
            n = r - lo;
            int n2 = hi - l;
            if (n > n2) {
                if (n <= 10) continue;
                lostack[top] = lo;
                histack[top++] = r;
                if (n2 <= 10) continue;
                lostack[top] = l;
                histack[top++] = hi;
                continue;
            }
            if (n2 <= 10) continue;
            lostack[top] = l;
            histack[top++] = hi;
            if (n <= 10) continue;
            lostack[top] = lo;
            histack[top++] = r;
        }
        PyList.insertionsort(array, off, size, compare);
    }

    public synchronized void sort(PyObject compare) {
        PyList.quicksort(this.list, 0, this.length, compare);
    }

    public void sort() {
        this.sort(null);
    }

    @Override
    protected PyClass getPyClass() {
        return __class__;
    }

    @Override
    public int hashCode() {
        throw Py.TypeError("unhashable type");
    }

    public boolean add(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof PyObject) {
            this.append((PyObject)o);
        } else {
            this.append(new PyJavaInstance(o));
        }
        return true;
    }

    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    @Override
    public void clear() {
        throw new Error("Not implemented");
    }

    @Override
    public boolean contains(Object o) {
        throw new Error("Not implemented");
    }

    public boolean containsAll(Collection c) {
        throw new Error("Not implemented");
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public boolean isEmpty() {
        return this.length > 0;
    }

    @Override
    public Iterator iterator() {
        return new PyListIterator(this);
    }

    @Override
    public boolean remove(Object o) {
        throw new Error("Not implemented");
    }

    public boolean removeAll(Collection c) {
        throw new Error("Not implemented");
    }

    public boolean retainAll(Collection c) {
        throw new Error("Not implemented");
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Object[] toArray() {
        throw new Error("Not implemented");
    }

    public Object[] toArray(Object[] a) {
        throw new Error("Not implemented");
    }

    static {
        PyList list = new PyList();
        String[] methods = new String[]{"append", "count", "extend", "index", "insert", "pop", "remove", "reverse", "sort"};
        for (int i = 0; i < methods.length; ++i) {
            list.append(new PyString(methods[i]));
        }
        __methods__ = list;
    }

    class PyListIterator
    implements Iterator {
        private PyList pl = null;
        private int loc = 0;

        public PyListIterator(PyList pl) {
            this.pl = pl;
        }

        @Override
        public boolean hasNext() {
            return this.loc < this.pl.size();
        }

        public Object next() {
            ++this.loc;
            return this.pl.__finditem__(this.loc);
        }

        @Override
        public void remove() {
        }
    }
}

