/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyLong
extends PyObject {
    private static final BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger minDouble = new BigDecimal(Double.MIN_VALUE).toBigInteger();
    private static final BigInteger maxDouble = new BigDecimal(Double.MAX_VALUE).toBigInteger();
    private BigInteger value;
    public static PyClass __class__;

    public PyLong(BigInteger v) {
        this.value = v;
    }

    public PyLong(double v) {
        this(new BigDecimal(v).toBigInteger());
    }

    public PyLong(long v) {
        this(BigInteger.valueOf(v));
    }

    public PyLong(String s) {
        this(new BigInteger(s));
    }

    public String toString() {
        return this.value.toString() + "L";
    }

    @Override
    public int hashCode() {
        return this.value.intValue();
    }

    @Override
    public boolean __nonzero__() {
        return !this.value.equals(BigInteger.valueOf(0L));
    }

    public double doubleValue() {
        double v = this.value.doubleValue();
        if (v == Double.NEGATIVE_INFINITY || v == Double.POSITIVE_INFINITY) {
            throw Py.OverflowError("long int too long to convert");
        }
        return v;
    }

    private long getLong(long min, long max) {
        long v;
        if (this.value.compareTo(maxLong) <= 0 && this.value.compareTo(minLong) >= 0 && (v = this.value.longValue()) >= min && v <= max) {
            return v;
        }
        throw Py.OverflowError("long int too long to convert");
    }

    @Override
    public Object __tojava__(Class c) {
        try {
            if (c == Byte.TYPE || c == Byte.class) {
                return new Byte((byte)this.getLong(-128L, 127L));
            }
            if (c == Short.TYPE || c == Short.class) {
                return new Short((short)this.getLong(-32768L, 32767L));
            }
            if (c == Integer.TYPE || c == Integer.class) {
                return new Integer((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
            }
            if (c == Long.TYPE || c == Long.class) {
                return new Long(this.getLong(Long.MIN_VALUE, Long.MAX_VALUE));
            }
            if (c == Float.TYPE || c == Double.TYPE || c == Float.class || c == Double.class) {
                return this.__float__().__tojava__(c);
            }
            if (c == BigInteger.class || c == Number.class || c == Object.class || c == Serializable.class) {
                return this.value;
            }
        }
        catch (PyException e) {
            return Py.NoConversion;
        }
        return super.__tojava__(c);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.value.compareTo(((PyLong)other).value);
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        if (other instanceof PyLong) {
            return other;
        }
        if (other instanceof PyInteger) {
            return new PyLong(((PyInteger)other).getValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyLong || other instanceof PyInteger;
    }

    private static final BigInteger coerce(PyObject other) {
        if (other instanceof PyLong) {
            return ((PyLong)other).value;
        }
        if (other instanceof PyInteger) {
            return BigInteger.valueOf(((PyInteger)other).getValue());
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.add(PyLong.coerce(right)));
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.__add__(left);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.subtract(PyLong.coerce(right)));
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        return new PyLong(PyLong.coerce(left).subtract(this.value));
    }

    @Override
    public PyObject __mul__(PyObject right) {
        if (right instanceof PySequence) {
            return ((PySequence)right).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.multiply(PyLong.coerce(right)));
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        if (left instanceof PySequence) {
            return ((PySequence)left).repeat(PyLong.coerceInt(this));
        }
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(PyLong.coerce(left).multiply(this.value));
    }

    private BigInteger divide(BigInteger x, BigInteger y) {
        BigInteger zero = BigInteger.valueOf(0L);
        if (y.equals(zero)) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        if (y.compareTo(zero) < 0) {
            if (x.compareTo(zero) > 0) {
                return x.subtract(y).subtract(BigInteger.valueOf(1L)).divide(y);
            }
        } else if (x.compareTo(zero) < 0) {
            return x.subtract(y).add(BigInteger.valueOf(1L)).divide(y);
        }
        return x.divide(y);
    }

    @Override
    public PyObject __div__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.divide(this.value, PyLong.coerce(right)));
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return new PyLong(this.divide(PyLong.coerce(left), this.value));
    }

    private BigInteger modulo(BigInteger x, BigInteger y, BigInteger xdivy) {
        return x.subtract(xdivy.multiply(y));
    }

    @Override
    public PyObject __mod__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        BigInteger rightv = PyLong.coerce(right);
        return new PyLong(this.modulo(this.value, rightv, this.divide(this.value, rightv)));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        BigInteger leftv = PyLong.coerce(left);
        return new PyLong(this.modulo(leftv, this.value, this.divide(leftv, this.value)));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        BigInteger rightv = PyLong.coerce(right);
        BigInteger xdivy = this.divide(this.value, rightv);
        return new PyTuple(new PyObject[]{new PyLong(xdivy), new PyLong(this.modulo(this.value, rightv, xdivy))});
    }

    @Override
    public PyObject __rdivmod__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        BigInteger leftv = PyLong.coerce(left);
        BigInteger xdivy = this.divide(leftv, this.value);
        return new PyTuple(new PyObject[]{new PyLong(xdivy), new PyLong(this.modulo(leftv, this.value, xdivy))});
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        if (modulo != null && !PyLong.canCoerce(right)) {
            return null;
        }
        return PyLong._pow(this.value, PyLong.coerce(right), modulo);
    }

    @Override
    public PyObject __rpow__(PyObject left) {
        if (!PyLong.canCoerce(left)) {
            return null;
        }
        return PyLong._pow(PyLong.coerce(left), this.value, null);
    }

    public static PyLong _pow(BigInteger value, BigInteger y, PyObject modulo) {
        if (y.compareTo(BigInteger.valueOf(0L)) < 0) {
            if (value.compareTo(BigInteger.valueOf(0L)) != 0) {
                throw Py.ValueError("long integer to a negative power");
            }
            throw Py.ZeroDivisionError("zero to a negative power");
        }
        if (modulo == null) {
            return new PyLong(value.pow(y.intValue()));
        }
        BigInteger z = PyLong.coerce(modulo);
        int zi = z.intValue();
        if (zi == 0) {
            throw Py.ValueError("pow(x, y, z) with z == 0");
        }
        if (zi == 1 || zi == -1) {
            return new PyLong(0L);
        }
        if (z.compareTo(BigInteger.valueOf(0L)) <= 0) {
            if ((y = value.modPow(y, z.negate())).compareTo(BigInteger.valueOf(0L)) > 0) {
                return new PyLong(z.add(y));
            }
            return new PyLong(y);
        }
        return new PyLong(value.modPow(y, z));
    }

    private static final int coerceInt(PyObject other) {
        if (other instanceof PyLong) {
            return (int)((PyLong)other).getLong(Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __lshift__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.shiftLeft(PyLong.coerceInt(right)));
    }

    @Override
    public PyObject __rshift__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.shiftRight(PyLong.coerceInt(right)));
    }

    @Override
    public PyObject __and__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.and(PyLong.coerce(right)));
    }

    @Override
    public PyObject __xor__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.xor(PyLong.coerce(right)));
    }

    @Override
    public PyObject __or__(PyObject right) {
        if (!PyLong.canCoerce(right)) {
            return null;
        }
        return new PyLong(this.value.or(PyLong.coerce(right)));
    }

    @Override
    public PyObject __neg__() {
        return new PyLong(this.value.negate());
    }

    @Override
    public PyObject __pos__() {
        return this;
    }

    @Override
    public PyObject __abs__() {
        return new PyLong(this.value.abs());
    }

    @Override
    public PyObject __invert__() {
        return new PyLong(this.value.not());
    }

    @Override
    public PyInteger __int__() {
        return new PyInteger((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    @Override
    public PyLong __long__() {
        return this;
    }

    @Override
    public PyFloat __float__() {
        return new PyFloat(this.doubleValue());
    }

    @Override
    public PyComplex __complex__() {
        return new PyComplex(this.doubleValue(), 0.0);
    }

    @Override
    public PyString __oct__() {
        String s = this.value.toString(8);
        if (s.startsWith("-")) {
            return new PyString("-0" + s.substring(1, s.length()) + "L");
        }
        if (s.startsWith("0")) {
            return new PyString(s + "L");
        }
        return new PyString("0" + s + "L");
    }

    @Override
    public PyString __hex__() {
        String s = this.value.toString(16).toUpperCase();
        if (s.startsWith("-")) {
            return new PyString("-0x" + s.substring(1, s.length()) + "L");
        }
        return new PyString("0x" + s + "L");
    }

    @Override
    public PyString __str__() {
        return Py.newString(this.value.toString());
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    protected PyClass getPyClass() {
        return __class__;
    }
}

