/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.python.core.JavaAccessibility;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyInstance;
import org.python.core.PyJavaClass;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyReflectedFunction;
import org.python.core.ReflectedArgs;
import org.python.core.ReflectedCallData;
import org.python.core.ThreadState;

public class PyReflectedConstructor
extends PyReflectedFunction {
    public static PyClass __class__;

    public PyReflectedConstructor(String name) {
        super(name, __class__);
        this.__name__ = name;
        this.argslist = new ReflectedArgs[1];
        this.nargs = 0;
    }

    public PyReflectedConstructor(Constructor c) {
        this(c.getDeclaringClass().getName());
        this.addConstructor(c);
    }

    private ReflectedArgs makeArgs(Constructor m) {
        return new ReflectedArgs(m, m.getParameterTypes(), m.getDeclaringClass(), true);
    }

    public void addConstructor(Constructor m) {
        int mods = m.getModifiers();
        if (!Modifier.isPublic(mods) && !JavaAccessibility.accessIsMutable()) {
            return;
        }
        this.addArgs(this.makeArgs(m));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PyObject __call__(PyObject self, PyObject[] args, String[] keywords) {
        ReflectedArgs[] argsl = this.argslist;
        if (self == null || !(self instanceof PyInstance)) {
            throw Py.TypeError("invalid self argument to constructor");
        }
        PyInstance iself = (PyInstance)self;
        Class javaClass = iself.__class__.proxyClass;
        boolean proxyConstructor = false;
        Class declaringClass = argsl[0].declaringClass;
        if (!PyProxy.class.isAssignableFrom(declaringClass) && !(iself instanceof PyJavaInstance)) {
            if (!declaringClass.isAssignableFrom(javaClass)) {
                throw Py.TypeError("invalid self argument");
            }
            proxyConstructor = true;
            PyJavaClass jc = PyJavaClass.lookup(javaClass);
            jc.initConstructors();
            return jc.__init__.__call__((PyObject)iself, args, keywords);
        }
        if (!declaringClass.isAssignableFrom(javaClass)) {
            throw Py.TypeError("self invalid - must implement: " + declaringClass.getName());
        }
        proxyConstructor = true;
        if (iself.javaProxy != null) {
            Class sup = iself.__class__.proxyClass;
            if (PyProxy.class.isAssignableFrom(sup)) {
                sup = sup.getSuperclass();
            }
            throw Py.TypeError("instance already instantiated for " + sup.getName());
        }
        ReflectedCallData callData = new ReflectedCallData();
        Object method = null;
        int nkeywords = keywords.length;
        PyObject[] allArgs = args;
        if (nkeywords > 0) {
            args = new PyObject[allArgs.length - nkeywords];
            System.arraycopy(allArgs, 0, args, 0, args.length);
        }
        int n = this.nargs;
        for (int i = 0; i < n; ++i) {
            ReflectedArgs rargs = argsl[i];
            if (!rargs.matches(null, args, Py.NoKeywords, callData)) continue;
            method = rargs.data;
            break;
        }
        if (method == null) {
            this.throwError(callData.errArg, args.length, self != null, false);
        }
        Object jself = null;
        ThreadState ts = Py.getThreadState();
        try {
            ts.pushInitializingProxy(iself);
            Constructor ctor = (Constructor)method;
            try {
                jself = ctor.newInstance(callData.getArgsArray());
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof InstantiationException) {
                    Class sup = iself.__class__.proxyClass.getSuperclass();
                    String msg = "Constructor failed for Java superclass";
                    if (sup != null) {
                        msg = msg + " " + sup.getName();
                    }
                    throw Py.TypeError(msg);
                }
                throw Py.JavaError(e);
            }
            catch (Throwable t) {
                throw Py.JavaError(t);
            }
        }
        finally {
            ts.popInitializingProxy();
        }
        iself.javaProxy = jself;
        int offset = args.length;
        for (int i = 0; i < nkeywords; ++i) {
            iself.__setattr__(keywords[i], allArgs[i + offset]);
        }
        return Py.None;
    }

    @Override
    public PyObject __call__(PyObject[] args, String[] keywords) {
        if (args.length < 1) {
            throw Py.TypeError("constructor requires self argument");
        }
        PyObject[] newArgs = new PyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        return this.__call__(args[0], newArgs, keywords);
    }

    @Override
    public String toString() {
        return "<java constructor " + this.__name__ + " at " + Py.id(this) + ">";
    }
}

