/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import com.hp.hpl.guess.Edge;
import com.hp.hpl.guess.Field;
import com.hp.hpl.guess.GraphElement;
import com.hp.hpl.guess.Guess;
import com.hp.hpl.guess.Node;
import com.hp.hpl.guess.ui.FrameListener;
import com.hp.hpl.guess.ui.VisFactory;
import java.util.Collection;
import java.util.HashSet;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyClass;
import org.python.core.PyException;
import org.python.core.PyInstance;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.SeqFuncs;

public abstract class PySequence
extends PyObject {
    public String annotation = null;

    public String getAnnotation() {
        return this.annotation;
    }

    public PySequence() {
    }

    public PySequence(PyClass c) {
        super(c);
    }

    public int size() {
        return this.__len__();
    }

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__nonzero__", (PyObject)new SeqFuncs("__nonzero__", 1, 0));
        dict.__setitem__("__getitem__", (PyObject)new SeqFuncs("__getitem__", 11, 1));
        dict.__setitem__("__delitem__", (PyObject)new SeqFuncs("__delitem__", 12, 1));
        dict.__setitem__("__mul__", (PyObject)new SeqFuncs("__mul__", 13, 1));
        dict.__setitem__("__rmul__", (PyObject)new SeqFuncs("__rmul__", 14, 1));
        dict.__setitem__("__cmp__", (PyObject)new SeqFuncs("__cmp__", 15, 1));
        dict.__setitem__("__setitem__", (PyObject)new SeqFuncs("__setitem__", 21, 2));
        dict.__setitem__("__getslice__", (PyObject)new SeqFuncs("__getslice__", 31, 3));
        dict.__setitem__("__delslice__", (PyObject)new SeqFuncs("__delslice__", 32, 3));
        dict.__setitem__("__setslice__", (PyObject)new SeqFuncs("__setslice__", 41, 4));
        dict.__setitem__("classDictInit", null);
    }

    protected abstract PyObject get(int var1);

    protected abstract PyObject getslice(int var1, int var2, int var3);

    protected abstract PyObject repeat(int var1);

    protected void set(int index, PyObject value) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void setslice(int start, int stop, int step, PyObject value) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void del(int i) throws PyException {
        throw Py.TypeError("can't remove from immutable object");
    }

    protected void delRange(int start, int stop, int step) {
        throw Py.TypeError("can't remove from immutable object");
    }

    @Override
    public boolean __nonzero__() {
        return this.__len__() != 0;
    }

    @Override
    public synchronized PyObject __eq__(PyObject o) {
        int ol;
        if (o.__class__ != this.__class__) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.Zero;
        }
        int i = PySequence.cmp(this, tl, o, ol);
        return i < 0 ? Py.One : Py.Zero;
    }

    @Override
    public synchronized PyObject __ne__(PyObject o) {
        int ol;
        if (o.__class__ != this.__class__) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.One;
        }
        int i = PySequence.cmp(this, tl, o, ol);
        return i < 0 ? Py.Zero : Py.One;
    }

    @Override
    public synchronized PyObject __lt__(PyObject o) {
        if (o.__class__ != this.__class__) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 ? Py.One : Py.Zero;
        }
        return this.__finditem__(i)._lt(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __le__(PyObject o) {
        if (o.__class__ != this.__class__) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 || i == -2 ? Py.One : Py.Zero;
        }
        return this.__finditem__(i)._le(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __gt__(PyObject o) {
        if (o.__class__ != this.__class__) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 ? Py.One : Py.Zero;
        }
        return this.__finditem__(i)._gt(o.__finditem__(i));
    }

    @Override
    public synchronized PyObject __ge__(PyObject o) {
        if (o.__class__ != this.__class__) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 || i == -2 ? Py.One : Py.Zero;
        }
        return this.__finditem__(i)._ge(o.__finditem__(i));
    }

    @Override
    public PyObject __and__(PyObject o) {
        HashSet<GraphElement> set1 = new HashSet<GraphElement>();
        if (o instanceof PySequence) {
            PySequence other = (PySequence)o;
            for (int j = 0; j < other.__len__(); ++j) {
                try {
                    if (!((PyInstance)other.get(j)).isGraphElementProxy()) continue;
                    GraphElement ge = (GraphElement)((PyInstance)other.get(j)).__tojava__(GraphElement.class);
                    set1.add(ge);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            PyList list = new PyList();
            for (int j = 0; j < this.__len__(); ++j) {
                try {
                    GraphElement ge;
                    if (!((PyInstance)this.get(j)).isGraphElementProxy() || !set1.contains(ge = (GraphElement)((PyInstance)this.get(j)).__tojava__(GraphElement.class))) continue;
                    list.append(new PyJavaInstance(ge));
                    set1.remove(ge);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return list;
        }
        return null;
    }

    @Override
    public PyObject __or__(PyObject o) {
        HashSet<GraphElement> set1 = new HashSet<GraphElement>();
        if (o instanceof PySequence) {
            GraphElement ge;
            int j;
            PySequence other = (PySequence)o;
            PyList list = new PyList();
            for (j = 0; j < other.__len__(); ++j) {
                try {
                    if (!((PyInstance)other.get(j)).isGraphElementProxy() || set1.contains(ge = (GraphElement)((PyInstance)other.get(j)).__tojava__(GraphElement.class))) continue;
                    list.append(new PyJavaInstance(ge));
                    set1.add(ge);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (j = 0; j < this.__len__(); ++j) {
                try {
                    if (!((PyInstance)this.get(j)).isGraphElementProxy() || set1.contains(ge = (GraphElement)((PyInstance)this.get(j)).__tojava__(GraphElement.class))) continue;
                    list.append(new PyJavaInstance(ge));
                    set1.add(ge);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return list;
        }
        return null;
    }

    private static int cmp(PyObject o1, int ol1, PyObject o2, int ol2) {
        if (ol1 < 0) {
            ol1 = o1.__len__();
        }
        if (ol2 < 0) {
            ol2 = o2.__len__();
        }
        for (int i = 0; i < ol1 && i < ol2; ++i) {
            if (o1.__getitem__(i)._eq(o2.__getitem__(i)).__nonzero__()) continue;
            return i;
        }
        if (ol1 == ol2) {
            return -2;
        }
        return ol1 < ol2 ? -1 : -3;
    }

    protected static PyObject fastSequence(PyObject seq, String msg) {
        PyObject item;
        if (seq instanceof PyList || seq instanceof PyTuple) {
            return seq;
        }
        if (!seq.isSequenceType()) {
            throw Py.TypeError(msg);
        }
        int n = seq.__len__();
        PyList list = new PyList();
        int i = 0;
        while ((item = list.__finditem__(i)) != null) {
            list.append(item);
            ++i;
        }
        return list;
    }

    protected static final int sliceLength(int start, int stop, int step) {
        int ret = step > 0 ? (stop - start + step - 1) / step : (stop - start + step + 1) / step;
        if (ret < 0) {
            return 0;
        }
        return ret;
    }

    private static final int getIndex(PyObject index, int defaultValue) {
        block6: {
            if (index == Py.None || index == null) {
                return defaultValue;
            }
            if (index instanceof PyLong) {
                try {
                    index = index.__int__();
                }
                catch (PyException exc) {
                    if (!Py.matchException(exc, Py.OverflowError)) break block6;
                    if (new PyLong(0L).__cmp__(index) < 0) {
                        return Integer.MAX_VALUE;
                    }
                    return 0;
                }
            }
        }
        if (!(index instanceof PyInteger)) {
            throw Py.TypeError("slice index must be int");
        }
        return ((PyInteger)index).getValue();
    }

    protected int fixindex(int index) {
        int l = this.__len__();
        if (index < 0) {
            index += l;
        }
        if (index < 0 || index >= l) {
            return -1;
        }
        return index;
    }

    @Override
    public synchronized PyObject __finditem__(int index) {
        if ((index = this.fixindex(index)) == -1) {
            return null;
        }
        return this.get(index);
    }

    @Override
    public PyObject __finditem__(PyObject index) {
        if (index instanceof PyInteger) {
            return this.__finditem__(((PyInteger)index).getValue());
        }
        if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            return this.__getslice__(s.start, s.stop, s.step);
        }
        if (index instanceof PyLong) {
            return this.__finditem__(index.__int__().getValue());
        }
        throw Py.TypeError("sequence subscript must be integer or slice");
    }

    @Override
    public PyObject __getitem__(PyObject index) {
        PyObject ret = this.__finditem__(index);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + index);
        }
        return ret;
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isNumberType() {
        return false;
    }

    protected static final int getStep(PyObject s_step) {
        int step = PySequence.getIndex(s_step, 1);
        if (step == 0) {
            throw Py.TypeError("slice step of zero not allowed");
        }
        return step;
    }

    protected static final int getStart(PyObject s_start, int step, int length) {
        int start = step < 0 ? PySequence.getIndex(s_start, length - 1) : PySequence.getIndex(s_start, 0);
        if (start < 0 && (start += length) < 0) {
            start = 0;
        }
        if (start > length) {
            start = length;
        }
        return start;
    }

    protected static final int getStop(PyObject s_stop, int start, int step, int length) {
        int stop;
        if (step < 0) {
            stop = PySequence.getIndex(s_stop, -1);
            if (stop < -1) {
                stop = length + stop;
            }
            if (stop < -1) {
                stop = -1;
            }
        } else {
            stop = PySequence.getIndex(s_stop, length);
            if (stop < 0) {
                stop = length + stop;
            }
            if (stop < 0) {
                stop = 0;
            }
        }
        if (stop > length) {
            stop = length;
        }
        return stop;
    }

    @Override
    public synchronized PyObject __getslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        int length = this.__len__();
        int step = PySequence.getStep(s_step);
        int start = PySequence.getStart(s_start, step, length);
        int stop = PySequence.getStop(s_stop, start, step, length);
        return this.getslice(start, stop, step);
    }

    @Override
    public synchronized void __setslice__(PyObject s_start, PyObject s_stop, PyObject s_step, PyObject value) {
        int length = this.__len__();
        int step = PySequence.getStep(s_step);
        int start = PySequence.getStart(s_start, step, length);
        int stop = PySequence.getStop(s_stop, start, step, length);
        this.setslice(start, stop, step, value);
    }

    @Override
    public synchronized void __delslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        int length = this.__len__();
        int step = PySequence.getStep(s_step);
        int start = PySequence.getStart(s_start, step, length);
        int stop = PySequence.getStop(s_stop, start, step, length);
        this.delRange(start, stop, step);
    }

    @Override
    public synchronized void __setitem__(int index, PyObject value) {
        int i = this.fixindex(index);
        if (i == -1) {
            throw Py.IndexError("index out of range: " + i);
        }
        this.set(i, value);
    }

    @Override
    public void __setitem__(PyObject index, PyObject value) {
        if (index instanceof PyInteger) {
            this.__setitem__(((PyInteger)index).getValue(), value);
        } else if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            this.__setslice__(s.start, s.stop, s.step, value);
        } else if (index instanceof PyLong) {
            this.__setitem__(index.__int__().getValue(), value);
        } else {
            throw Py.TypeError("sequence subscript must be integer or slice");
        }
    }

    @Override
    public synchronized void __delitem__(PyObject index) {
        if (index instanceof PyInteger) {
            int i = this.fixindex(((PyInteger)index).getValue());
            if (i == -1) {
                throw Py.IndexError("index out of range: " + i);
            }
            this.del(i);
        } else if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            this.__delslice__(s.start, s.stop, s.step);
        } else if (index instanceof PyLong) {
            int i = this.fixindex(index.__int__().getValue());
            if (i == -1) {
                throw Py.IndexError("index out of range: " + i);
            }
            this.del(i);
        } else {
            throw Py.TypeError("sequence subscript must be integer or slice");
        }
    }

    @Override
    public synchronized Object __tojava__(Class c) {
        if (c.isArray()) {
            Class<?> component = c.getComponentType();
            try {
                int n = this.__len__();
                PyArray array = new PyArray(component, n);
                for (int i = 0; i < n; ++i) {
                    PyObject o = this.get(i);
                    array.set(i, o);
                }
                return array.data;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__tojava__(c);
    }

    @Override
    public PyObject __findattr__(String name) {
        PyObject o = super.__findattr__(name);
        if (o != null) {
            return o;
        }
        PyList other = new PyList();
        for (int i = 0; i < this.__len__(); ++i) {
            try {
                o = this.get(i);
                if (o instanceof PyString) {
                    other.append(new PyNone());
                    continue;
                }
                other.append(this.get(i).__getattr__(name));
                continue;
            }
            catch (Exception ex) {
                other.append(new PyNone());
            }
        }
        return other;
    }

    public PySequence unroll() {
        PyList other = new PyList();
        this.unroll(other);
        return other;
    }

    protected void unroll(PyList other) {
        for (int i = 0; i < this.__len__(); ++i) {
            PyObject o = this.get(i);
            if (o instanceof PySequence && !(o instanceof PyString)) {
                ((PySequence)o).unroll(other);
                continue;
            }
            other.append(o);
        }
    }

    @Override
    public void __setattr__(String name, PyObject value) {
        FrameListener gf = VisFactory.getFactory().getDisplay();
        if (gf != null) {
            gf.setFrozen(true);
        }
        try {
            for (int i = 0; i < this.__len__(); ++i) {
                try {
                    if (this.get(i) instanceof PySequence) {
                        this.get(i).__setattr__(name, value);
                    }
                    if (!((PyInstance)this.get(i)).isGraphElementProxy()) continue;
                    GraphElement element = (GraphElement)((PyInstance)this.get(i)).__tojava__(GraphElement.class);
                    if (!(value instanceof PyString) && value instanceof PySequence) {
                        element.__setattr__(name, ((PySequence)value).__finditem__(i));
                        continue;
                    }
                    element.__setattr__(name, value);
                    continue;
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
            }
        }
        catch (Error e) {
            if (gf != null) {
                gf.setFrozen(false);
            }
            throw e;
        }
        if (gf != null) {
            gf.setFrozen(false);
        }
    }

    public void show() {
        this.__setattr__("visible", (PyObject)new PyInteger(1));
    }

    public void hide() {
        this.__setattr__("visible", (PyObject)new PyInteger(0));
    }

    @Override
    public PyObject __sub__(PyObject object) {
        return this.findEdges(object, "-");
    }

    @Override
    public PyObject __rde__(PyObject object) {
        return this.findEdges(object, "->");
    }

    @Override
    public PyObject __lde__(PyObject object) {
        return this.findEdges(object, "<-");
    }

    @Override
    public PyObject __bde__(PyObject object) {
        return this.findEdges(object, "<->");
    }

    @Override
    public PyObject __anye__(PyObject po) {
        if (po instanceof PySequence) {
            return this.findEdges(po, "?");
        }
        try {
            if (((PyInstance)po).isNodeProxy()) {
                Node n = (Node)((PyInstance)po).__tojava__(Node.class);
                PyList other = new PyList();
                other.append(po);
                return this.findEdges((PyObject)other, "?");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.__anye__(po);
    }

    private PyObject findEdges(PyObject object, String dir) {
        if (object instanceof PyJavaInstance) {
            PyList nodes = new PyList();
            nodes.append(object);
            return this.findEdges((PyObject)nodes, dir);
        }
        PySequence other = (PySequence)object;
        PyList edges = new PyList();
        HashSet<PyObject> seen = new HashSet<PyObject>();
        for (int i = 0; i < this.__len__(); ++i) {
            if (!((PyInstance)this.get(i)).isNodeProxy()) continue;
            Node node1 = (Node)((PyInstance)this.get(i)).__tojava__(Node.class);
            for (int j = 0; j < other.__len__(); ++j) {
                PySequence edge;
                if (!((PyInstance)other.get(j)).isNodeProxy()) continue;
                Node node2 = (Node)((PyInstance)other.get(j)).__tojava__(Node.class);
                if (dir.equals("-")) {
                    edge = node1.__sub__(node2);
                } else if (dir.equals("->")) {
                    edge = node1.__rde__(node2);
                } else if (dir.equals("<-")) {
                    edge = node1.__lde__(node2);
                } else if (dir.equals("<->")) {
                    edge = node1.__bde__(node2);
                } else if (dir.equals("?")) {
                    edge = node1.__anye__(node2);
                } else {
                    throw new Error("Invalid direction:  " + dir);
                }
                if (edge == null) continue;
                for (int z = 0; z < edge.__len__(); ++z) {
                    try {
                        if (seen.contains(edge.get(z))) continue;
                        edges.append(edge.get(z));
                        seen.add(edge.get(z));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return edges;
    }

    public Collection groupBy(Field f) {
        return Guess.getGraph().groupBy(this, f);
    }

    public Collection groupAndSortBy(Field f) {
        return Guess.getGraph().groupAndSortBy(this, f);
    }

    public Collection sortBy(Field f) {
        return Guess.getGraph().sortBy(this, f);
    }

    public Collection findNodes() {
        HashSet fe = new HashSet();
        this.findNodes(this, fe);
        return fe;
    }

    public void findNodes(PySequence seq, Collection s) {
        for (int i = 0; i < seq.__len__(); ++i) {
            Object element = seq.__finditem__(i);
            if (element instanceof PyInstance) {
                element = ((PyInstance)element).__tojava__(Object.class);
            }
            if (element instanceof PyString) continue;
            if (element instanceof Node) {
                s.add((Node)element);
                continue;
            }
            if (!(element instanceof PySequence)) continue;
            this.findNodes((PySequence)element, s);
        }
    }

    public Collection findEdges() {
        HashSet fe = new HashSet();
        this.findEdges(this, fe);
        return fe;
    }

    public void findEdges(PySequence seq, Collection s) {
        for (int i = 0; i < seq.__len__(); ++i) {
            Object element = seq.__finditem__(i);
            if (element instanceof PyInstance) {
                element = ((PyInstance)element).__tojava__(Object.class);
            }
            if (element instanceof PyString) continue;
            if (element instanceof Edge) {
                s.add((Edge)element);
                continue;
            }
            if (!(element instanceof PySequence)) continue;
            this.findEdges((PySequence)element, s);
        }
    }

    public void findNodesAndEdges(Collection n, Collection e) {
        this.findNodesAndEdges(this, n, e);
    }

    public void findNodesAndEdges(PySequence seq, Collection n, Collection e) {
        for (int i = 0; i < seq.__len__(); ++i) {
            Object element = seq.__finditem__(i);
            if (element instanceof PyInstance) {
                element = ((PyInstance)element).__tojava__(Object.class);
            }
            if (element instanceof PyString) continue;
            if (element instanceof Edge) {
                e.add((Edge)element);
                continue;
            }
            if (element instanceof Node) {
                n.add((Node)element);
                continue;
            }
            if (!(element instanceof PySequence)) continue;
            this.findNodesAndEdges((PySequence)element, n, e);
        }
    }

    public boolean containsGraphElements() {
        for (int i = 0; i < this.__len__(); ++i) {
            boolean test;
            Object element = this.__finditem__(i);
            if (element instanceof PyInstance) {
                element = ((PyInstance)element).__tojava__(Object.class);
            }
            if (element instanceof PyString) continue;
            if (element instanceof GraphElement) {
                return true;
            }
            if (!(element instanceof PySequence) || !(test = ((PySequence)element).containsGraphElements())) continue;
            return true;
        }
        return false;
    }

    public Collection findGraphElements() {
        HashSet hs = new HashSet();
        this.findGraphElements(this, hs);
        return hs;
    }

    public void findGraphElements(PySequence seq, Collection c) {
        for (int i = 0; i < seq.__len__(); ++i) {
            Object element = seq.__finditem__(i);
            if (element instanceof PyInstance) {
                element = ((PyInstance)element).__tojava__(Object.class);
            }
            if (element instanceof PyString) continue;
            if (element instanceof GraphElement) {
                c.add(element);
                continue;
            }
            if (!(element instanceof PySequence)) continue;
            this.findGraphElements((PySequence)element, c);
        }
    }
}

