/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import com.hp.hpl.guess.util.intervals.Tracker;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.TupleFunctions;

public class PyTuple
extends PySequence
implements ClassDictInit {
    public PyObject[] list;

    public static void classDictInit(PyObject dict) {
        PySequence.classDictInit(dict);
        dict.__setitem__("__len__", (PyObject)new TupleFunctions("__len__", 3, 0));
        dict.__setitem__("__add__", (PyObject)new TupleFunctions("__add__", 15, 1));
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("hashCode", null);
    }

    public PyTuple() {
        this(Py.EmptyObjects);
    }

    public PyTuple(PyObject[] elements) {
        this.list = elements;
    }

    @Override
    public String safeRepr() throws PyIgnoreMethodTag {
        return "'tuple' object";
    }

    @Override
    protected PyObject get(int i) {
        return this.list[i];
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyTuple.sliceLength(start, stop, step);
        PyObject[] newList = new PyObject[n];
        if (step == 1) {
            System.arraycopy(this.list, start, newList, 0, stop - start);
            return new PyTuple(newList);
        }
        int j = 0;
        int i = start;
        while (j < n) {
            newList[j] = this.list[i];
            ++j;
            i += step;
        }
        return new PyTuple(newList);
    }

    @Override
    protected PyObject repeat(int count) {
        int l = this.list.length;
        PyObject[] newList = new PyObject[l * count];
        for (int i = 0; i < count; ++i) {
            System.arraycopy(this.list, 0, newList, i * l, l);
        }
        return new PyTuple(newList);
    }

    @Override
    public int __len__() {
        return this.list.length;
    }

    @Override
    public PyObject __add__(PyObject generic_other) {
        if (generic_other instanceof PyTuple) {
            PyTuple other = (PyTuple)generic_other;
            PyObject[] new_list = new PyObject[this.list.length + other.list.length];
            System.arraycopy(this.list, 0, new_list, 0, this.list.length);
            System.arraycopy(other.list, 0, new_list, this.list.length, other.list.length);
            return new PyTuple(new_list);
        }
        return null;
    }

    @Override
    public int hashCode() {
        int len = this.list.length;
        int x = 3430008;
        --len;
        while (len >= 0) {
            int y = this.list[len].hashCode();
            x = x + x + x ^ y;
            --len;
        }
        return x ^= this.list.length;
    }

    private String subobjRepr(PyObject o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    @Override
    public PyString __str__() {
        int start = Tracker.getLocation();
        Tracker.incrementLocation(1);
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < this.list.length - 1; ++i) {
            buf.append(this.list[i].__str__());
            buf.append(", ");
            Tracker.incrementLocation(2);
        }
        if (this.list.length > 0) {
            buf.append(this.list[this.list.length - 1].__str__());
        }
        if (this.list.length == 1) {
            buf.append(",");
        }
        buf.append(")");
        String toRet = buf.toString();
        if (this.containsGraphElements()) {
            Tracker.addNode(start, toRet.length() - 1, this);
        }
        Tracker.setLocation(start + toRet.length());
        return new PyString(toRet);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(");
        for (int i = 0; i < this.list.length - 1; ++i) {
            buf.append(this.subobjRepr(this.list[i]));
            buf.append(", ");
        }
        if (this.list.length > 0) {
            buf.append(this.subobjRepr(this.list[this.list.length - 1]));
        }
        if (this.list.length == 1) {
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }
}

