/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;

public class PyXRange
extends PySequence {
    public int start;
    public int stop;
    public int step;
    int cycleLength;
    int copies;

    public PyXRange(int start, int stop, int step) {
        if (step == 0) {
            throw Py.ValueError("zero step for xrange()");
        }
        this.start = start;
        this.stop = stop;
        this.step = step;
        int oneLessThanStep = step + (step > 0 ? -1 : 1);
        this.cycleLength = (stop - start + oneLessThanStep) / step;
        if (this.cycleLength < 0) {
            this.cycleLength = 0;
        }
        this.copies = 1;
    }

    @Override
    public int __len__() {
        return this.cycleLength * this.copies;
    }

    private int getInt(int i) {
        if (this.cycleLength == 0) {
            return this.start;
        }
        return this.start + i % this.cycleLength * this.step;
    }

    @Override
    protected PyObject get(int i) {
        return new PyInteger(this.getInt(i));
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (this.copies != 1) {
            throw Py.TypeError("cannot slice a replicated range");
        }
        int len = PyXRange.sliceLength(start, stop, step);
        int xslice_start = this.getInt(start);
        int xslice_step = this.step * step;
        int xslice_stop = xslice_start + xslice_step * len;
        return new PyXRange(xslice_start, xslice_stop, xslice_step);
    }

    @Override
    protected PyObject repeat(int howmany) {
        PyXRange x = new PyXRange(this.start, this.stop, this.step);
        x.copies = this.copies * howmany;
        return x;
    }

    @Override
    public PyObject __add__(PyObject generic_other) {
        throw Py.TypeError("cannot concatenate xrange objects");
    }

    @Override
    public int hashCode() {
        return this.stop ^ this.start ^ this.step;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("(");
        int count = this.__len__();
        for (int i = 0; i < count - 1; ++i) {
            buf.append(this.get(i).__repr__().toString());
            buf.append(", ");
        }
        if (count > 0) {
            buf.append(this.get(count - 1).__repr__().toString());
        }
        if (count == 1) {
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    public PyList tolist() {
        PyList list = new PyList();
        int count = this.__len__();
        for (int i = 0; i < count; ++i) {
            list.append(this.get(i));
        }
        return list;
    }
}

