/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import com.hp.hpl.guess.util.intervals.Tracker;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.Vector;
import org.python.core.Py;
import org.python.core.PyCompositeString;
import org.python.core.PyFile;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;

public class StdoutWrapper
extends OutputStream {
    protected String name = "stdout";

    protected PyObject getObject(PySystemState ss) {
        return ss.stdout;
    }

    protected void setObject(PySystemState ss, PyObject obj) {
        ss.stdout = obj;
    }

    protected PyObject myFile() {
        PySystemState ss = Py.getSystemState();
        PyObject obj = this.getObject(ss);
        if (obj == null) {
            throw Py.AttributeError("missing sys." + this.name);
        }
        if (obj instanceof PyJavaInstance) {
            PyFile f = null;
            Object tmp = obj.__tojava__(OutputStream.class);
            if (tmp != Py.NoConversion && tmp != null) {
                OutputStream os2 = (OutputStream)tmp;
                f = new PyFile(os2, "<java OutputStream>");
            } else {
                tmp = obj.__tojava__(Writer.class);
                if (tmp != Py.NoConversion && tmp != null) {
                    Writer w = (Writer)tmp;
                    f = new PyFile(w, "<java Writer>");
                }
            }
            if (f != null) {
                this.setObject(ss, f);
                return f;
            }
        }
        return obj;
    }

    @Override
    public void flush() {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            ((PyFile)obj).flush();
        } else {
            obj.invoke("flush");
        }
    }

    public void write(String s) {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            ((PyFile)obj).write(s);
        } else {
            obj.invoke("write", new PyString(s));
        }
    }

    @Override
    public void write(int i) {
        this.write(new String(new char[]{(char)i}));
    }

    @Override
    public void write(byte[] data, int off, int len) {
        this.write(new String(data, off, len));
    }

    public void clearSoftspace() {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            PyFile file = (PyFile)obj;
            if (file.softspace) {
                file.write("\n");
                file.flush();
            }
            file.softspace = false;
        } else {
            PyObject ss = obj.__findattr__("softspace");
            if (ss != null && ss.__nonzero__()) {
                obj.invoke("write", Py.Newline);
            }
            obj.invoke("flush");
            obj.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }

    public void print(PyObject o, boolean space, boolean newline) {
        PyString string = o.__str__();
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            PyFile file = (PyFile)obj;
            String s = string.toString();
            if (newline) {
                s = s + "\n";
            }
            if (file.softspace) {
                s = " " + s;
            }
            file.write(s);
            file.flush();
            if (space && s.endsWith("\n")) {
                space = false;
            }
            file.softspace = space;
        } else {
            PyObject ss = obj.__findattr__("softspace");
            if (ss != null && ss.__nonzero__()) {
                obj.invoke("write", Py.Space);
            }
            obj.invoke("write", string);
            if (newline) {
                obj.invoke("write", Py.Newline);
            }
            if (space && string.toString().endsWith("\n")) {
                space = false;
            }
            obj.__setattr__("softspace", (PyObject)(space ? Py.One : Py.Zero));
        }
        if (o instanceof PyCompositeString) {
            Vector v = ((PyCompositeString)o).getLocations();
            Collections.sort(v);
            int whereTo = Tracker.getLocation();
            int lineloc = Tracker.getLocation() - string.__len__();
            for (int i = 0; i < v.size(); ++i) {
                PyCompositeString.Location loci = (PyCompositeString.Location)v.elementAt(i);
                Tracker.setLocation(lineloc + loci.start);
                Tracker.addNode(loci.length - 1, loci.po);
            }
            Tracker.setLocation(whereTo);
        }
    }

    public void print(String s) {
        this.print(new PyString(s), false, false);
    }

    public void println(String s) {
        this.print(new PyString(s), false, true);
    }

    public void print(PyObject o) {
        this.print(o, false, false);
    }

    public void printComma(PyObject o) {
        this.print(o, true, false);
    }

    public void println(PyObject o) {
        this.print(o, false, true);
    }

    public void println() {
        PyObject obj = this.myFile();
        if (obj instanceof PyFile) {
            PyFile file = (PyFile)obj;
            file.write("\n");
            file.flush();
            file.softspace = false;
        } else {
            obj.invoke("write", Py.Newline);
            obj.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }
}

