/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyBuiltinFunctionSet;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;

class StringFuncs
extends PyBuiltinFunctionSet {
    StringFuncs(String name, int index, int argcount) {
        super(name, index, argcount, argcount, true, null);
    }

    StringFuncs(String name, int index, int mincount, int maxcount) {
        super(name, index, mincount, maxcount, true, null);
    }

    private String tostring(PyObject o) {
        if (o == Py.None) {
            return null;
        }
        if (o instanceof PyString) {
            return ((PyString)o).toString();
        }
        throw Py.TypeError("1st arg can't be coerced to string");
    }

    private String tostring(PyObject o, String which) {
        if (o instanceof PyString) {
            return ((PyString)o).toString();
        }
        throw Py.TypeError(which + " arg can't be coerced to string");
    }

    private int toint(PyObject o) {
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        throw Py.TypeError("2nd arg can't be coerced to int");
    }

    private int toint(PyObject o, String which) {
        if (o instanceof PyInteger) {
            return ((PyInteger)o).getValue();
        }
        throw Py.TypeError(which + " arg can't be coerced to int");
    }

    @Override
    public PyObject __call__() {
        PyString s = (PyString)this.__self__;
        switch (this.index) {
            case 1: {
                return s.__str__();
            }
            case 2: {
                return new PyInteger(s.__len__());
            }
            case 3: {
                return s.__repr__();
            }
            case 4: {
                return Py.newBoolean(s.islower());
            }
            case 5: {
                return Py.newBoolean(s.isalpha());
            }
            case 6: {
                return Py.newBoolean(s.isdigit());
            }
            case 7: {
                return Py.newBoolean(s.isupper());
            }
            case 8: {
                return Py.newBoolean(s.isspace());
            }
            case 9: {
                return Py.newBoolean(s.istitle());
            }
            case 10: {
                return Py.newBoolean(s.isnumeric());
            }
            case 101: {
                return new PyString(s.lower());
            }
            case 102: {
                return new PyString(s.upper());
            }
            case 103: {
                return new PyString(s.swapcase());
            }
            case 104: {
                return new PyString(s.strip());
            }
            case 105: {
                return new PyString(s.lstrip());
            }
            case 106: {
                return new PyString(s.rstrip());
            }
            case 107: {
                return s.split();
            }
            case 113: {
                return new PyString(s.capitalize());
            }
        }
        throw this.argCountError(0);
    }

    @Override
    public PyObject __call__(PyObject arg) {
        PyString s = (PyString)this.__self__;
        switch (this.index) {
            case 11: {
                return new PyInteger(s.__cmp__(arg));
            }
            case 12: {
                return s.__add__(arg);
            }
            case 13: {
                return s.__mod__(arg);
            }
            case 107: {
                return s.split(this.tostring(arg));
            }
            case 108: {
                return new PyInteger(s.index(this.tostring(arg)));
            }
            case 109: {
                return new PyInteger(s.rindex(this.tostring(arg)));
            }
            case 110: {
                return new PyInteger(s.count(this.tostring(arg)));
            }
            case 111: {
                return new PyInteger(s.find(this.tostring(arg)));
            }
            case 112: {
                return new PyInteger(s.rfind(this.tostring(arg)));
            }
            case 114: {
                return new PyInteger(s.endswith(this.tostring(arg)) ? 1 : 0);
            }
            case 115: {
                return new PyString(s.join(arg));
            }
            case 117: {
                return new PyInteger(s.startswith(this.tostring(arg)) ? 1 : 0);
            }
            case 118: {
                if (arg instanceof PyString) {
                    return new PyString(s.translate(this.tostring(arg)));
                }
                return new PyString(s.translate(arg));
            }
        }
        throw this.argCountError(1);
    }

    @Override
    public PyObject __call__(PyObject arg1, PyObject arg2) {
        PyString s = (PyString)this.__self__;
        switch (this.index) {
            case 107: {
                String args = this.tostring(arg1);
                int argi = this.toint(arg2);
                return s.split(args, argi);
            }
            case 108: {
                String args = this.tostring(arg1);
                int argi = this.toint(arg2);
                return new PyInteger(s.index(args, argi));
            }
            case 109: {
                String args = this.tostring(arg1);
                int argi = this.toint(arg2);
                return new PyInteger(s.rindex(args, argi));
            }
            case 110: {
                String args = this.tostring(arg1);
                int argi = this.toint(arg2);
                return new PyInteger(s.count(args, argi));
            }
            case 111: {
                String args = this.tostring(arg1);
                int argi = this.toint(arg2);
                return new PyInteger(s.find(args, argi));
            }
            case 112: {
                String args = this.tostring(arg1);
                int argi = this.toint(arg2);
                return new PyInteger(s.rfind(args, argi));
            }
            case 114: {
                String args = this.tostring(arg1);
                int argi = this.toint(arg2);
                return new PyInteger(s.endswith(args, argi) ? 1 : 0);
            }
            case 116: {
                String args1 = this.tostring(arg1);
                String args2 = this.tostring(arg2, "2nd");
                return new PyString(s.replace(args1, args2));
            }
            case 117: {
                String args = this.tostring(arg1);
                int argi = this.toint(arg2);
                return new PyInteger(s.startswith(args, argi) ? 1 : 0);
            }
            case 118: {
                String args1 = this.tostring(arg1);
                String args2 = this.tostring(arg2, "2nd");
                return new PyString(s.translate(args1, args2));
            }
        }
        throw this.argCountError(2);
    }

    @Override
    public PyObject __call__(PyObject arg1, PyObject arg2, PyObject arg3) {
        PyString s = (PyString)this.__self__;
        switch (this.index) {
            case 108: {
                String args = this.tostring(arg1);
                int argi2 = this.toint(arg2);
                int argi3 = this.toint(arg3, "3rd");
                return new PyInteger(s.index(args, argi2, argi3));
            }
            case 109: {
                String args = this.tostring(arg1);
                int argi2 = this.toint(arg2);
                int argi3 = this.toint(arg3, "3rd");
                return new PyInteger(s.rindex(args, argi2, argi3));
            }
            case 110: {
                String args = this.tostring(arg1);
                int argi2 = this.toint(arg2);
                int argi3 = this.toint(arg3, "3rd");
                return new PyInteger(s.count(args, argi2, argi3));
            }
            case 111: {
                String args = this.tostring(arg1);
                int argi2 = this.toint(arg2);
                int argi3 = this.toint(arg3, "3rd");
                return new PyInteger(s.find(args, argi2, argi3));
            }
            case 112: {
                String args = this.tostring(arg1);
                int argi2 = this.toint(arg2);
                int argi3 = this.toint(arg3, "3rd");
                return new PyInteger(s.rfind(args, argi2, argi3));
            }
            case 114: {
                String args = this.tostring(arg1);
                int argi2 = this.toint(arg2);
                int argi3 = this.toint(arg3, "3rd");
                return new PyInteger(s.endswith(args, argi2, argi3) ? 1 : 0);
            }
            case 116: {
                String args1 = this.tostring(arg1);
                String args2 = this.tostring(arg2, "2nd");
                int argi = this.toint(arg3, "3rd");
                return new PyString(s.replace(args1, args2, argi));
            }
            case 117: {
                String args = this.tostring(arg1);
                int argi2 = this.toint(arg2);
                int argi3 = this.toint(arg3, "3rd");
                return new PyInteger(s.startswith(args, argi2, argi3) ? 1 : 0);
            }
        }
        throw this.argCountError(3);
    }
}

