/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.SyspathArchive;

public class SyspathJavaLoader
extends ClassLoader {
    @Override
    public InputStream getResourceAsStream(String res) {
        ClassLoader classLoader = Py.getSystemState().getClassLoader();
        if (classLoader != null) {
            return classLoader.getResourceAsStream(res);
        }
        classLoader = this.getClass().getClassLoader();
        InputStream ret = classLoader != null ? classLoader.getResourceAsStream(res) : ClassLoader.getSystemResourceAsStream(res);
        if (ret != null) {
            return ret;
        }
        if (res.charAt(0) == '/') {
            res = res.substring(1);
        }
        res.replace('/', File.separatorChar);
        PyList path = Py.getSystemState().path;
        for (int i = 0; i < path.__len__(); ++i) {
            PyObject entry = path.__getitem__(i);
            if (entry instanceof SyspathArchive) {
                SyspathArchive archive = (SyspathArchive)entry;
                ZipEntry ze = archive.getEntry(res);
                if (ze == null) continue;
                try {
                    return archive.getInputStream(ze);
                }
                catch (IOException e) {
                    continue;
                }
            }
            String dir = entry.__str__().toString();
            if (dir.length() == 0) {
                dir = null;
            }
            try {
                return new BufferedInputStream(new FileInputStream(new File(dir, res)));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader classLoader = Py.getSystemState().getClassLoader();
        if (classLoader != null) {
            return classLoader.loadClass(name);
        }
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            PyList path = Py.getSystemState().path;
            for (int i = 0; i < path.__len__(); ++i) {
                InputStream fis = null;
                PyObject entry = path.__getitem__(i);
                if (entry instanceof SyspathArchive) {
                    SyspathArchive archive = (SyspathArchive)entry;
                    String entryname = name.replace('.', File.separatorChar) + ".class";
                    ZipEntry ze = archive.getEntry(entryname);
                    if (ze != null) {
                        try {
                            fis = archive.getInputStream(ze);
                        }
                        catch (IOException exc) {}
                    }
                } else {
                    String dir = entry.__str__().toString();
                    fis = this.open(dir, name);
                }
                if (fis == null) continue;
                try {
                    int size = ((InputStream)fis).available();
                    byte[] buffer = new byte[size];
                    ((InputStream)fis).read(buffer);
                    ((InputStream)fis).close();
                    return this.loadClassFromBytes(name, buffer);
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    private FileInputStream open(String dir, String name) {
        String accum = "";
        boolean first = true;
        StringTokenizer t = new StringTokenizer(name, ".");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (!first) {
                accum = accum + File.separator;
            }
            accum = accum + token;
            first = false;
        }
        try {
            if (dir.length() == 0) {
                dir = null;
            }
            return new FileInputStream(new File(dir, accum + ".class"));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private Class loadClassFromBytes(String name, byte[] data) {
        Class<?> c = this.defineClass(name, data, 0, data.length);
        this.resolveClass(c);
        if (!Options.skipCompile) {
            Compiler.compileClass(c);
        }
        return c;
    }
}

