/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser;

import java.math.BigInteger;
import org.python.compiler.ScopeInfo;
import org.python.core.Py;
import org.python.core.PyString;
import org.python.parser.Node;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammar;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.Visitor;

public class SimpleNode
implements Node {
    protected Node parent;
    public SimpleNode[] children;
    public int id;
    protected PythonGrammar parser;
    public int endLine;
    public int endColumn;
    public int beginLine;
    public int beginColumn;
    Object info;
    public int aug_tmp1;
    public int aug_tmp2;
    public int aug_tmp3;
    public int aug_tmp4;
    public ScopeInfo scope;
    public boolean from_future_checked = false;

    public SimpleNode(int i) {
        this.id = i;
    }

    public SimpleNode(PythonGrammar p, int i) {
        this(i);
        this.parser = p;
    }

    public static Node jjtCreate(int id) {
        return new SimpleNode(id);
    }

    public static Node jjtCreate(PythonGrammar p, int id) {
        return new SimpleNode(p, id);
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n, int i) {
        if (this.children == null) {
            this.children = new SimpleNode[i + 1];
        } else if (i >= this.children.length) {
            SimpleNode[] c = new SimpleNode[i + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i] = (SimpleNode)n;
    }

    @Override
    public Node jjtGetChild(int i) {
        return this.children[i];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public SimpleNode getChild(int i) {
        return this.children[i];
    }

    public int getNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object o) {
        this.info = o;
    }

    public void setString(String s, int quotes) {
        this.info = SimpleNode.parseString(s, quotes, this.beginLine, this.beginColumn);
    }

    public static String parseString(String s, int quotes, int beginLine, int beginColumn) {
        int i;
        char quoteChar = s.charAt(0);
        int start = 0;
        boolean ustring = false;
        if (quoteChar == 'u' || quoteChar == 'U') {
            ustring = true;
            ++start;
        }
        if ((quoteChar = s.charAt(start)) == 'r' || quoteChar == 'R') {
            return s.substring(quotes + start + 1, s.length() - quotes);
        }
        StringBuffer sb = new StringBuffer(s.length());
        char[] ca = s.toCharArray();
        int n = ca.length - quotes;
        int last_i = i = quotes + start;
        return PyString.decode_UnicodeEscape(s, i, n, "strict", ustring);
    }

    public void setInteger(String s, int radix) {
        if (s.endsWith("j") || s.endsWith("J")) {
            this.setFloat(s);
        } else if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
            if (radix == 10) {
                this.setInfo(s);
            } else {
                this.setInfo(new BigInteger(s, radix).toString());
            }
        } else {
            int i;
            int ndigits = s.length();
            for (i = 0; i < ndigits && s.charAt(i) == '0'; ++i) {
            }
            if (ndigits - i > 11) {
                throw Py.OverflowError("integer literal too large");
            }
            long l = Long.valueOf(s, radix);
            if (l > 0xFFFFFFFFL || radix == 10 && l > Integer.MAX_VALUE) {
                throw Py.OverflowError("integer literal too large");
            }
            this.setInfo(new Integer((int)l));
        }
    }

    public void setFloat(String s) {
        if (s.endsWith("j") || s.endsWith("J")) {
            this.setInfo(Double.valueOf(s.substring(0, s.length() - 1)));
            this.id = 102;
        } else {
            this.setInfo(Double.valueOf(s));
        }
    }

    public String toString() {
        return PythonGrammarTreeConstants.jjtNodeName[this.id] + ":" + this.info + " at line " + this.beginLine;
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode n = this.children[i];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }

    public Object visit(Visitor visitor) throws Exception {
        switch (this.id) {
            case 0: {
                return visitor.single_input(this);
            }
            case 1: {
                return visitor.file_input(this);
            }
            case 2: {
                return visitor.eval_input(this);
            }
            case 3: {
                return visitor.funcdef(this);
            }
            case 5: {
                return visitor.varargslist(this);
            }
            case 6: {
                return visitor.ExtraArgList(this);
            }
            case 7: {
                return visitor.ExtraKeywordList(this);
            }
            case 8: {
                return visitor.defaultarg(this);
            }
            case 9: {
                return visitor.fplist(this);
            }
            case 10: {
                return visitor.expr_stmt(this);
            }
            case 22: {
                return visitor.print_stmt(this);
            }
            case 23: {
                return visitor.print_ext(this);
            }
            case 24: {
                return visitor.del_stmt(this);
            }
            case 25: {
                return visitor.pass_stmt(this);
            }
            case 26: {
                return visitor.break_stmt(this);
            }
            case 27: {
                return visitor.continue_stmt(this);
            }
            case 28: {
                return visitor.return_stmt(this);
            }
            case 29: {
                return visitor.raise_stmt(this);
            }
            case 30: {
                return visitor.Import(this);
            }
            case 31: {
                return visitor.ImportFrom(this);
            }
            case 33: {
                return visitor.dotted_name(this);
            }
            case 35: {
                return visitor.global_stmt(this);
            }
            case 36: {
                return visitor.exec_stmt(this);
            }
            case 37: {
                return visitor.assert_stmt(this);
            }
            case 38: {
                return visitor.if_stmt(this);
            }
            case 39: {
                return visitor.while_stmt(this);
            }
            case 40: {
                return visitor.for_stmt(this);
            }
            case 41: {
                return visitor.try_stmt(this);
            }
            case 42: {
                return visitor.except_clause(this);
            }
            case 43: {
                return visitor.suite(this);
            }
            case 44: {
                return visitor.or_boolean(this);
            }
            case 45: {
                return visitor.and_boolean(this);
            }
            case 46: {
                return visitor.not_1op(this);
            }
            case 47: {
                return visitor.comparision(this);
            }
            case 48: {
                return visitor.less_cmp(this);
            }
            case 49: {
                return visitor.greater_cmp(this);
            }
            case 50: {
                return visitor.equal_cmp(this);
            }
            case 51: {
                return visitor.greater_equal_cmp(this);
            }
            case 52: {
                return visitor.less_equal_cmp(this);
            }
            case 53: {
                return visitor.notequal_cmp(this);
            }
            case 54: {
                return visitor.leftdiredge(this);
            }
            case 57: {
                return visitor.questionm(this);
            }
            case 55: {
                return visitor.rightdiredge(this);
            }
            case 56: {
                return visitor.bidiredge(this);
            }
            case 58: {
                return visitor.like(this);
            }
            case 60: {
                return visitor.rcontains(this);
            }
            case 61: {
                return visitor.rexact(this);
            }
            case 62: {
                return visitor.rcontained(this);
            }
            case 59: {
                return visitor.roverlaps(this);
            }
            case 63: {
                return visitor.in_cmp(this);
            }
            case 64: {
                return visitor.not_in_cmp(this);
            }
            case 65: {
                return visitor.is_not_cmp(this);
            }
            case 66: {
                return visitor.is_cmp(this);
            }
            case 67: {
                return visitor.or_2op(this);
            }
            case 68: {
                return visitor.xor_2op(this);
            }
            case 69: {
                return visitor.and_2op(this);
            }
            case 70: {
                return visitor.lshift_2op(this);
            }
            case 71: {
                return visitor.rshift_2op(this);
            }
            case 72: {
                return visitor.add_2op(this);
            }
            case 73: {
                return visitor.sub_2op(this);
            }
            case 74: {
                return visitor.mul_2op(this);
            }
            case 75: {
                return visitor.div_2op(this);
            }
            case 76: {
                return visitor.mod_2op(this);
            }
            case 77: {
                return visitor.pos_1op(this);
            }
            case 78: {
                return visitor.neg_1op(this);
            }
            case 79: {
                return visitor.invert_1op(this);
            }
            case 80: {
                return visitor.pow_2op(this);
            }
            case 81: {
                return visitor.Call_Op(this);
            }
            case 82: {
                return visitor.Index_Op(this);
            }
            case 83: {
                return visitor.Dot_Op(this);
            }
            case 84: {
                return visitor.tuple(this);
            }
            case 85: {
                return visitor.list(this);
            }
            case 86: {
                return visitor.dictionary(this);
            }
            case 87: {
                return visitor.str_1op(this);
            }
            case 88: {
                return visitor.strjoin(this);
            }
            case 89: {
                return visitor.lambdef(this);
            }
            case 90: {
                return visitor.Ellipses(this);
            }
            case 91: {
                return visitor.Slice(this);
            }
            case 92: {
                return visitor.Colon(this);
            }
            case 93: {
                return visitor.Comma(this);
            }
            case 95: {
                return visitor.classdef(this);
            }
            case 96: {
                return visitor.arglist(this);
            }
            case 99: {
                return visitor.Keyword(this);
            }
            case 100: {
                return visitor.Int(this);
            }
            case 101: {
                return visitor.Float(this);
            }
            case 102: {
                return visitor.Complex(this);
            }
            case 103: {
                return visitor.Name(this);
            }
            case 104: {
                return visitor.String(this);
            }
            case 11: {
                return visitor.aug_plus(this);
            }
            case 12: {
                return visitor.aug_minus(this);
            }
            case 13: {
                return visitor.aug_multiply(this);
            }
            case 14: {
                return visitor.aug_divide(this);
            }
            case 15: {
                return visitor.aug_modulo(this);
            }
            case 16: {
                return visitor.aug_and(this);
            }
            case 17: {
                return visitor.aug_or(this);
            }
            case 18: {
                return visitor.aug_xor(this);
            }
            case 19: {
                return visitor.aug_lshift(this);
            }
            case 20: {
                return visitor.aug_rshift(this);
            }
            case 21: {
                return visitor.aug_power(this);
            }
            case 94: {
                return visitor.list_iter(this);
            }
        }
        throw new ParseException("Unexpected node: " + this);
    }
}

