/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRclient;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import org.rosuda.JRclient.RBool;
import org.rosuda.JRclient.RFactor;
import org.rosuda.JRclient.RList;
import org.rosuda.JRclient.Rconnection;
import org.rosuda.JRclient.Rtalk;

public class REXP {
    public static final int XT_NULL = 0;
    public static final int XT_INT = 1;
    public static final int XT_DOUBLE = 2;
    public static final int XT_STR = 3;
    public static final int XT_LANG = 4;
    public static final int XT_SYM = 5;
    public static final int XT_BOOL = 6;
    public static final int XT_VECTOR = 16;
    public static final int XT_LIST = 17;
    public static final int XT_CLOS = 18;
    public static final int XT_ARRAY_INT = 32;
    public static final int XT_ARRAY_DOUBLE = 33;
    public static final int XT_ARRAY_STR = 34;
    public static final int XT_ARRAY_BOOL_UA = 35;
    public static final int XT_ARRAY_BOOL = 36;
    public static final int XT_UNKNOWN = 48;
    public static final int XT_FACTOR = 127;
    int Xt;
    REXP attr;
    Object cont;
    long cachedBinaryLength = -1L;

    public REXP() {
        this.Xt = 0;
        this.attr = null;
        this.cont = null;
    }

    public REXP(int t, Object o) {
        this.Xt = t;
        this.cont = o;
        this.attr = null;
    }

    public REXP(int t, Object o, REXP at) {
        this.Xt = t;
        this.cont = o;
        this.attr = at;
    }

    public REXP(double[] val) {
        this(33, val);
    }

    public REXP(int[] val) {
        this(32, val);
    }

    public REXP(String[] val) {
        this(34, val);
    }

    public REXP getAttribute() {
        return this.attr;
    }

    public Object getContent() {
        return this.cont;
    }

    public int getType() {
        return this.Xt;
    }

    public static int parseREXP(REXP x, byte[] buf, int o) {
        int xl = Rtalk.getLen(buf, o);
        boolean hasAtt = (buf[o] & 0x80) != 0;
        boolean isLong = (buf[o] & 0x40) != 0;
        int xt = buf[o] & 0x3F;
        if (isLong) {
            o += 4;
        }
        int eox = (o += 4) + xl;
        x.Xt = xt;
        x.attr = null;
        if (hasAtt) {
            x.attr = new REXP();
            o = REXP.parseREXP(x.attr, buf, o);
        }
        if (xt == 0) {
            x.cont = null;
            return o;
        }
        if (xt == 2) {
            long lr = Rtalk.getLong(buf, o);
            x.cont = new Double(Double.longBitsToDouble(lr));
            if ((o += 8) != eox) {
                System.out.println("Warning: double SEXP size mismatch\n");
                o = eox;
            }
            return o;
        }
        if (xt == 33) {
            int as = (eox - o) / 8;
            int i = 0;
            double[] d = new double[as];
            while (o < eox) {
                d[i] = Double.longBitsToDouble(Rtalk.getLong(buf, o));
                o += 8;
                ++i;
            }
            if (o != eox) {
                System.out.println("Warning: double array SEXP size mismatch\n");
                o = eox;
            }
            x.cont = d;
            return o;
        }
        if (xt == 6) {
            x.cont = new RBool(buf[o]);
            if (++o != eox) {
                if (eox != o + 3) {
                    System.out.println("Warning: bool SEXP size mismatch\n");
                }
                o = eox;
            }
            return o;
        }
        if (xt == 35) {
            int as = eox - o;
            int i = 0;
            x.Xt = 36;
            RBool[] d = new RBool[as];
            while (o < eox) {
                d[i] = new RBool(buf[o]);
                ++i;
                ++o;
            }
            x.cont = d;
            return o;
        }
        if (xt == 36) {
            int i;
            int as = Rtalk.getInt(buf, o);
            o += 4;
            RBool[] d = new RBool[as];
            for (i = 0; o < eox && i < as; ++i, ++o) {
                d[i] = new RBool(buf[o]);
            }
            while ((i & 3) != 0) {
                ++i;
                ++o;
            }
            x.cont = d;
            return o;
        }
        if (xt == 1) {
            x.cont = new Integer(Rtalk.getInt(buf, o));
            if ((o += 4) != eox) {
                System.out.println("Warning: int SEXP size mismatch\n");
                o = eox;
            }
            return o;
        }
        if (xt == 32) {
            int as = (eox - o) / 4;
            int i = 0;
            int[] d = new int[as];
            while (o < eox) {
                d[i] = Rtalk.getInt(buf, o);
                o += 4;
                ++i;
            }
            if (o != eox) {
                System.out.println("Warning: int array SEXP size mismatch\n");
                o = eox;
            }
            x.cont = d;
            if (x.attr != null && x.attr.Xt == 17 && x.attr.cont != null && ((RList)x.attr.cont).head != null && ((RList)x.attr.cont).body != null && ((RList)x.attr.cont).head.cont != null && ((RList)x.attr.cont).body.cont != null && ((RList)x.attr.cont).head.Xt == 16 && ((RList)x.attr.cont).body.Xt == 17 && ((RList)((RList)x.attr.cont).body.cont).head != null && ((RList)((RList)x.attr.cont).body.cont).head.Xt == 3 && ((String)((RList)((RList)x.attr.cont).body.cont).head.cont).compareTo("factor") == 0) {
                RFactor f = new RFactor(d, (Vector)((RList)x.attr.cont).head.cont);
                x.cont = f;
                x.Xt = 127;
                x.attr = null;
            }
            return o;
        }
        if (xt == 16) {
            Vector<REXP> v = new Vector<REXP>();
            while (o < eox) {
                REXP xx = new REXP();
                o = REXP.parseREXP(xx, buf, o);
                v.addElement(xx);
            }
            if (o != eox) {
                System.out.println("Warning: int vector SEXP size mismatch\n");
                o = eox;
            }
            x.cont = v;
            if (x.attr != null && x.attr.Xt == 17 && x.attr.cont != null) {
                RList l = new RList();
                l.head = ((RList)x.attr.cont).head;
                l.body = new REXP(16, v);
                x.cont = l;
                x.Xt = 17;
                x.attr = x.attr.attr;
                if (l.head.Xt == 3) {
                    Vector<REXP> sv = new Vector<REXP>();
                    sv.addElement(l.head);
                    l.head = new REXP(16, sv, l.head.attr);
                    l.head.attr = null;
                }
            }
            return o;
        }
        if (xt == 3) {
            int i;
            for (i = o; buf[i] != 0 && i < eox; ++i) {
            }
            try {
                x.cont = new String(buf, o, i - o, Rconnection.transferCharset);
            }
            catch (Exception e) {
                System.out.println("unable to convert string\n");
                x.cont = null;
            }
            o = eox;
            return o;
        }
        if (xt == 17 || xt == 4) {
            RList rl = new RList();
            rl.head = new REXP();
            rl.body = new REXP();
            rl.tag = null;
            o = REXP.parseREXP(rl.head, buf, o);
            if ((o = REXP.parseREXP(rl.body, buf, o)) != eox) {
                rl.tag = new REXP();
                if ((o = REXP.parseREXP(rl.tag, buf, o)) != eox) {
                    System.out.println("Warning: list SEXP size mismatch\n");
                    o = eox;
                }
            }
            x.cont = rl;
            return o;
        }
        if (xt == 5) {
            REXP sym = new REXP();
            o = REXP.parseREXP(sym, buf, o);
            String s = null;
            s = sym.Xt == 3 ? (String)sym.cont : sym.toString();
            x.cont = s;
            o = eox;
            return o;
        }
        if (xt == 18) {
            REXP form = new REXP();
            REXP body = new REXP();
            o = REXP.parseREXP(form, buf, o);
            if ((o = REXP.parseREXP(body, buf, o)) != eox) {
                System.out.println("Warning: closure SEXP size mismatch\n");
                o = eox;
            }
            x.cont = body;
            return o;
        }
        if (xt == 48) {
            x.cont = new Integer(Rtalk.getInt(buf, o));
            o = eox;
            return o;
        }
        x.cont = null;
        o = eox;
        System.out.println("unhandled type: " + xt);
        return o;
    }

    public int getBinaryLength() {
        int l = 0;
        switch (this.Xt) {
            case 1: {
                l = 4;
                break;
            }
            case 2: {
                l = 8;
                break;
            }
            case 3: {
                l = this.cont == null ? 1 : ((String)this.cont).length() + 1;
                break;
            }
            case 32: {
                l = this.cont == null ? 0 : ((int[])this.cont).length * 4;
                break;
            }
            case 33: {
                l = this.cont == null ? 0 : ((double[])this.cont).length * 8;
                break;
            }
            case 34: {
                if (this.cachedBinaryLength < 0L) {
                    if (this.cont == null) {
                        this.cachedBinaryLength = 4L;
                    } else {
                        String[] sa = (String[])this.cont;
                        int io = 0;
                        for (int i = 0; i < sa.length; ++i) {
                            if (sa[i] != null) {
                                try {
                                    byte[] b = sa[i].getBytes(Rconnection.transferCharset);
                                    io += b.length;
                                    b = null;
                                }
                                catch (UnsupportedEncodingException uex) {
                                    // empty catch block
                                }
                            }
                            ++io;
                        }
                        while ((io & 3) != 0) {
                            ++io;
                        }
                        this.cachedBinaryLength = io + 4;
                        if (this.cachedBinaryLength > 0xFFFFF0L) {
                            this.cachedBinaryLength += 4L;
                        }
                    }
                }
                return (int)this.cachedBinaryLength;
            }
        }
        if (l > 0xFFFFF0) {
            l += 4;
        }
        return l + 4;
    }

    public int getBinaryRepresentation(byte[] buf, int off) {
        int myl = this.getBinaryLength();
        boolean isLarge = myl > 0xFFFFF0;
        Rtalk.setHdr(this.Xt, myl - (isLarge ? 8 : 4), buf, off);
        off += isLarge ? 8 : 4;
        switch (this.Xt) {
            case 1: {
                Rtalk.setInt(this.asInt(), buf, off);
                break;
            }
            case 2: {
                Rtalk.setLong(Double.doubleToLongBits(this.asDouble()), buf, off);
                break;
            }
            case 32: {
                if (this.cont == null) break;
                int[] ia = (int[])this.cont;
                int i = 0;
                int io = off;
                while (i < ia.length) {
                    Rtalk.setInt(ia[i++], buf, io);
                    io += 4;
                }
                break;
            }
            case 33: {
                if (this.cont == null) break;
                double[] da = (double[])this.cont;
                int i = 0;
                int io = off;
                while (i < da.length) {
                    Rtalk.setLong(Double.doubleToLongBits(da[i++]), buf, io);
                    io += 8;
                }
                break;
            }
            case 34: {
                int i;
                if (this.cont == null) break;
                String[] sa = (String[])this.cont;
                int io = off;
                for (i = 0; i < sa.length; ++i) {
                    if (sa[i] != null) {
                        try {
                            byte[] b = sa[i].getBytes(Rconnection.transferCharset);
                            System.arraycopy(b, 0, buf, io, b.length);
                            io += b.length;
                            b = null;
                        }
                        catch (UnsupportedEncodingException uex) {
                            // empty catch block
                        }
                    }
                    buf[io++] = 0;
                }
                i = io - off;
                while ((i & 3) != 0) {
                    buf[io++] = 1;
                    ++i;
                }
                break;
            }
        }
        return off + myl;
    }

    public static String xtName(int xt) {
        if (xt == 0) {
            return "NULL";
        }
        if (xt == 1) {
            return "INT";
        }
        if (xt == 3) {
            return "STRING";
        }
        if (xt == 2) {
            return "REAL";
        }
        if (xt == 6) {
            return "BOOL";
        }
        if (xt == 32) {
            return "INT*";
        }
        if (xt == 34) {
            return "STRING*";
        }
        if (xt == 33) {
            return "REAL*";
        }
        if (xt == 36) {
            return "BOOL*";
        }
        if (xt == 5) {
            return "SYMBOL";
        }
        if (xt == 4) {
            return "LANG";
        }
        if (xt == 17) {
            return "LIST";
        }
        if (xt == 18) {
            return "CLOS";
        }
        if (xt == 16) {
            return "VECTOR";
        }
        if (xt == 127) {
            return "FACTOR";
        }
        if (xt == 48) {
            return "UNKNOWN";
        }
        return "<unknown " + xt + ">";
    }

    public String asString() {
        return this.Xt == 3 ? (String)this.cont : null;
    }

    public int asInt() {
        int[] i;
        if (this.Xt == 32 && (i = (int[])this.cont) != null && i.length > 0) {
            return i[0];
        }
        return this.Xt == 1 ? (Integer)this.cont : 0;
    }

    public double asDouble() {
        double[] d;
        if (this.Xt == 33 && (d = (double[])this.cont) != null && d.length > 0) {
            return d[0];
        }
        return this.Xt == 2 ? (Double)this.cont : 0.0;
    }

    public Vector asVector() {
        return this.Xt == 16 ? (Vector)this.cont : null;
    }

    public RFactor asFactor() {
        return this.Xt == 127 ? (RFactor)this.cont : null;
    }

    public RList asList() {
        return this.Xt == 17 ? (RList)this.cont : null;
    }

    public RBool asBool() {
        return this.Xt == 6 ? (RBool)this.cont : null;
    }

    public double[] asDoubleArray() {
        if (this.Xt == 33) {
            return (double[])this.cont;
        }
        if (this.Xt == 2) {
            double[] d = new double[]{this.asDouble()};
            return d;
        }
        if (this.Xt == 1) {
            double[] d = new double[]{((Integer)this.cont).doubleValue()};
            return d;
        }
        if (this.Xt == 32) {
            int[] i = this.asIntArray();
            if (i == null) {
                return null;
            }
            double[] d = new double[i.length];
            for (int j = 0; j < i.length; ++j) {
                d[j] = i[j];
            }
            return d;
        }
        return null;
    }

    public int[] asIntArray() {
        if (this.Xt == 32) {
            return (int[])this.cont;
        }
        if (this.Xt == 1) {
            int[] i = new int[]{this.asInt()};
            return i;
        }
        return null;
    }

    public double[][] asDoubleMatrix() {
        if (this.Xt != 33 || this.attr == null || this.attr.Xt != 17) {
            return null;
        }
        REXP dim = this.attr.asList().getHead();
        if (dim == null || dim.Xt != 32) {
            return null;
        }
        int[] ds = dim.asIntArray();
        if (ds == null || ds.length != 2) {
            return null;
        }
        int m = ds[0];
        int n = ds[1];
        double[][] r = new double[m][n];
        double[] ct = this.asDoubleArray();
        if (ct == null) {
            return null;
        }
        int k = 0;
        for (int i = 0; i < n; ++i) {
            int j = 0;
            while (j < m) {
                r[j++][i] = ct[k++];
            }
        }
        return r;
    }

    public double[][] asMatrix() {
        return this.asDoubleMatrix();
    }

    public String toString() {
        int i;
        Object[] d;
        StringBuffer sb = new StringBuffer("[" + REXP.xtName(this.Xt) + " ");
        if (this.attr != null) {
            sb.append("\nattr=" + this.attr + "\n ");
        }
        if (this.Xt == 2) {
            sb.append((Double)this.cont);
        }
        if (this.Xt == 1) {
            sb.append((Integer)this.cont);
        }
        if (this.Xt == 6) {
            sb.append((RBool)this.cont);
        }
        if (this.Xt == 127) {
            sb.append((RFactor)this.cont);
        }
        if (this.Xt == 33) {
            d = (double[])this.cont;
            sb.append("(");
            for (i = 0; i < d.length; ++i) {
                sb.append(d[i]);
                if (i < d.length - 1) {
                    sb.append(", ");
                }
                if (i != 99) continue;
                sb.append("... (" + (d.length - 100) + " more values follow)");
                break;
            }
            sb.append(")");
        }
        if (this.Xt == 32) {
            d = (int[])this.cont;
            sb.append("(");
            for (i = 0; i < d.length; ++i) {
                sb.append((int)d[i]);
                if (i < d.length - 1) {
                    sb.append(", ");
                }
                if (i != 99) continue;
                sb.append("... (" + (d.length - 100) + " more values follow)");
                break;
            }
            sb.append(")");
        }
        if (this.Xt == 36) {
            d = (RBool[])this.cont;
            sb.append("(");
            for (i = 0; i < d.length; ++i) {
                sb.append((Object)d[i]);
                if (i >= d.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        if (this.Xt == 16) {
            Vector v = (Vector)this.cont;
            sb.append("(");
            for (i = 0; i < v.size(); ++i) {
                sb.append(((REXP)v.elementAt(i)).toString());
                if (i >= v.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        if (this.Xt == 3) {
            sb.append("\"");
            sb.append((String)this.cont);
            sb.append("\"");
        }
        if (this.Xt == 5) {
            sb.append((String)this.cont);
        }
        if (this.Xt == 17 || this.Xt == 4) {
            RList l = (RList)this.cont;
            sb.append(l.head);
            sb.append(" <-> ");
            sb.append(l.body);
        }
        if (this.Xt == 48) {
            sb.append((Integer)this.cont);
        }
        sb.append("]");
        return sb.toString();
    }
}

