/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRclient;

import java.io.IOException;
import java.io.InputStream;
import org.rosuda.JRclient.Rpacket;
import org.rosuda.JRclient.Rtalk;

public class RFileInputStream
extends InputStream {
    Rtalk rt;
    boolean closed;
    boolean eof;

    RFileInputStream(Rtalk rti, String fn) throws IOException {
        this.rt = rti;
        Rpacket rp = this.rt.request(16, fn);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
        this.closed = false;
        this.eof = false;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b, 0, 1) < 1) {
            return -1;
        }
        return b[0];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("File is not open");
        }
        if (this.eof) {
            return -1;
        }
        Rpacket rp = this.rt.request(19, len);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
        byte[] rd = rp.getCont();
        if (rd == null) {
            this.eof = true;
            return -1;
        }
        for (int i = 0; i < rd.length; ++i) {
            b[off + i] = rd[i];
        }
        return rd.length;
    }

    @Override
    public void close() throws IOException {
        Rpacket rp = this.rt.request(18, (byte[])null);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
        this.closed = true;
    }
}

