/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRclient;

import java.io.IOException;
import java.io.OutputStream;
import org.rosuda.JRclient.Rpacket;
import org.rosuda.JRclient.Rtalk;

public class RFileOutputStream
extends OutputStream {
    Rtalk rt;
    boolean closed;

    RFileOutputStream(Rtalk rti, String fn) throws IOException {
        this.rt = rti;
        Rpacket rp = this.rt.request(17, fn);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
        this.closed = false;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] ba = new byte[1];
        this.write(ba, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("File is not open");
        }
        if (len < 0) {
            len = 0;
        }
        boolean isLarge = len > 0xFFFFF0;
        byte[] hdr = Rtalk.newHdr(5, len);
        Rpacket rp = this.rt.request(20, hdr, b, off, len);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
    }

    @Override
    public void close() throws IOException {
        Rpacket rp = this.rt.request(18, (byte[])null);
        if (rp == null || !rp.isOk()) {
            throw new IOException(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat());
        }
        this.closed = true;
    }

    @Override
    public void flush() {
    }
}

