/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.util.Trace;
import org.w3c.dom.Element;

public abstract class AbstractEdge
extends MascoptObject {
    private static int idGenerator = 0;
    private static int nbInstanceEdge;
    protected AbstractVertex[] vertices;

    public AbstractEdge(AbstractVertex n1, AbstractVertex n2) {
        this.id = "AE" + idGenerator++;
        this.vertices = new AbstractVertex[2];
        this.vertices[0] = n1;
        this.vertices[1] = n2;
        this.setValue("id", this.id);
        Trace.newObj(this.id);
        ++nbInstanceEdge;
    }

    public AbstractVertex[] getAbstractVertices() {
        return this.vertices;
    }

    public AbstractVertex getOppositeAbstractVertex(AbstractVertex vertex) {
        if (this.vertices[0] == vertex) {
            return this.vertices[1];
        }
        return this.vertices[0];
    }

    public abstract boolean leadsTo(AbstractVertex var1);

    public abstract boolean leaves(AbstractVertex var1);

    public abstract AbstractVertex getConnected(AbstractVertex var1);

    public boolean isLoop() {
        return this.vertices[0] == this.vertices[1];
    }

    protected void finalize() {
        --nbInstanceEdge;
    }

    public static int size() {
        return nbInstanceEdge;
    }

    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        this.vertices[0].toDOMTreeAsRef(node_to_go);
        this.vertices[1].toDOMTreeAsRef(node_to_go);
        return node_to_go;
    }
}

