/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSetFactory;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.abstractGraph.AbstractVertexSetFactory;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.abstractGraph.MascoptSet;
import mascoptLib.util.NotifyReason;
import mascoptLib.util.Trace;
import org.w3c.dom.Element;

public abstract class AbstractEdgeSet
extends MascoptSet {
    private static int idGenerator;
    private static long nbInstanceES;
    private static long nbInstanceNS;
    private AbstractVertexSet abstractVertexSet = null;
    HashMap ins;
    HashMap outs;
    HashMap inOuts;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractEdgeSet() {
        ++nbInstanceES;
        this.id = "AES" + idGenerator++;
        this.ins = new HashMap();
        this.outs = new HashMap();
        this.inOuts = new HashMap();
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        Trace.newObj(this.id);
    }

    public AbstractEdgeSet(AbstractVertexSet abstractVertexSet) {
        this(null, abstractVertexSet);
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
    }

    public AbstractEdgeSet(AbstractEdgeSet edgeSet) {
        this();
        if (edgeSet != null) {
            this.setSuperSet(edgeSet);
            this.abstractVertexSet = edgeSet.getAbstractVertexSet();
            if (this.abstractVertexSet != null) {
                this.abstractVertexSet.addRemoveObserver(this);
            }
        }
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
    }

    public AbstractEdgeSet(AbstractEdgeSet es, AbstractVertexSet abstractVertexSet) {
        super(es);
        ++nbInstanceES;
        this.abstractVertexSet = abstractVertexSet;
        if (abstractVertexSet != null) {
            abstractVertexSet.addRemoveObserver(this);
        }
        this.id = "AES" + idGenerator++;
        this.ins = new HashMap();
        this.outs = new HashMap();
        this.inOuts = new HashMap();
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        Trace.newObj(this.id);
    }

    public AbstractEdgeSet(AbstractEdgeSet originalSet, boolean copyElements) {
        this();
        this.setName("Copy of set " + originalSet.getName() + " (" + originalSet.getId() + ")");
        if (originalSet != null && copyElements) {
            AbstractVertexSetFactory ansf = originalSet.getAbstractVertexSet().getFactory();
            this.abstractVertexSet = ansf.newAbstractVertexSet(originalSet.getAbstractVertexSet(), true);
            HashMap<String, AbstractVertex> isomorphism = new HashMap<String, AbstractVertex>();
            Iterator itOSNS = originalSet.getAbstractVertexSet().iterator();
            Iterator itNS = null;
            block0: while (itOSNS.hasNext()) {
                itNS = this.getAbstractVertexSet().iterator();
                String osnId = ((AbstractVertex)itOSNS.next()).getId();
                AbstractVertex correspVertex = null;
                while (itNS.hasNext()) {
                    correspVertex = (AbstractVertex)itNS.next();
                    String pattren = "^[a-zA-Z ]* id=" + osnId + "$";
                    if (!correspVertex.getName().matches(pattren)) continue;
                    isomorphism.put(osnId, correspVertex);
                    continue block0;
                }
            }
            AbstractEdgeSetFactory aesf = originalSet.getFactory();
            Iterator itE = originalSet.iterator();
            while (itE.hasNext()) {
                AbstractEdge edgeToCopy = (AbstractEdge)itE.next();
                AbstractVertex[] extremities = edgeToCopy.getAbstractVertices();
                AbstractEdge newEdge = aesf.newAbstractEdge((AbstractVertex)isomorphism.get(extremities[0].getId()), (AbstractVertex)isomorphism.get(extremities[1].getId()));
                newEdge.copyValues(edgeToCopy);
                newEdge.setName("Copy of abstractEdge with id=" + edgeToCopy.getId());
                this.add(newEdge);
            }
        } else if (originalSet != null && !copyElements) {
            this.abstractVertexSet = originalSet.getAbstractVertexSet();
            Iterator itOS = originalSet.iterator();
            while (itOS.hasNext()) {
                this.add(itOS.next());
            }
        }
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
    }

    public abstract AbstractEdgeSetFactory getFactory();

    public void update(Observable o, Object arg) {
        if (!(arg instanceof NotifyReason)) {
            return;
        }
        NotifyReason nr = (NotifyReason)arg;
        Object[] objs = nr.getObjects();
        String message = nr.getMessage();
        Trace.print(this.getId() + ": message=" + message + " objs=" + objs + " =>");
        if (message.equalsIgnoreCase("Remove")) {
            if (objs[0] instanceof AbstractVertex) {
                AbstractVertex theRemovedVertex = (AbstractVertex)objs[0];
                Iterator it = this.iterator();
                while (it.hasNext()) {
                    AbstractEdge abstractEdge = (AbstractEdge)it.next();
                    if (!abstractEdge.leadsTo(theRemovedVertex) && !abstractEdge.leaves(theRemovedVertex)) continue;
                    Trace.println("> j'enleve?" + abstractEdge);
                    boolean tempEtat = this.isAddRemoveAllowed();
                    this.setAddRemoveAllowed(true);
                    it.remove();
                    this.setAddRemoveAllowed(tempEtat);
                }
                this.removeAdj(theRemovedVertex);
            } else if (objs[0] instanceof AbstractEdge) {
                boolean tempEtat = this.isAddRemoveAllowed();
                this.setAddRemoveAllowed(true);
                this.remove((AbstractEdge)objs[0]);
                this.setAddRemoveAllowed(tempEtat);
            }
        } else {
            Trace.println("Nothing to do.");
        }
    }

    public boolean add(AbstractEdge o) {
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        if (this.abstractVertexSet == null) {
            Trace.printErrln("Can't add " + o + " in " + this + ": vertexSet points to null.");
            System.out.println("Can't add " + o + " in " + this + ": vertexSet points to null.");
            return false;
        }
        AbstractEdge theAbstractEdge = o;
        AbstractVertex[] vertices = theAbstractEdge.getAbstractVertices();
        AbstractVertex vertex0 = vertices[0];
        AbstractVertex vertex1 = vertices[1];
        if (!(this.abstractVertexSet == null || this.abstractVertexSet.contains(vertex0) && this.abstractVertexSet.contains(vertex1))) {
            Trace.printErrln("Can't add " + o + " in " + this + ": the two vertices aren't in the vertexSet");
            return false;
        }
        boolean result = super.add(o);
        Trace.println("on ajoute un abstractEdge " + theAbstractEdge);
        Trace.println("on check pour " + vertex0 + " et " + vertex1);
        if (theAbstractEdge.leaves(vertex0)) {
            this.addOut(vertex0, theAbstractEdge);
        }
        if (theAbstractEdge.leadsTo(vertex0)) {
            this.addIn(vertex0, theAbstractEdge);
        }
        if (theAbstractEdge.leaves(vertex1)) {
            this.addOut(vertex1, theAbstractEdge);
        }
        if (theAbstractEdge.leadsTo(vertex1)) {
            this.addIn(vertex1, theAbstractEdge);
        }
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        return result;
    }

    public boolean addAll(AbstractEdgeSet es) {
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        Iterator it_edge = es.iterator();
        boolean ok = true;
        while (it_edge.hasNext()) {
            boolean adding_ok = this.add((AbstractEdge)it_edge.next());
            ok = ok && adding_ok;
        }
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        return ok;
    }

    public boolean removeAll(AbstractEdgeSet es) {
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        System.out.println("Using removeAll of AbstractEdgeSet");
        Iterator it_edge = es.iterator();
        boolean ok = false;
        while (it_edge.hasNext()) {
            ok &= this.remove((AbstractEdge)it_edge.next());
        }
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        return ok;
    }

    public boolean remove(AbstractEdge o) {
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        boolean result = super.remove(o);
        AbstractEdge theAbstractEdge = o;
        AbstractVertex[] vertices = theAbstractEdge.getAbstractVertices();
        AbstractVertex vertex0 = vertices[0];
        AbstractVertex vertex1 = vertices[1];
        if (theAbstractEdge.leaves(vertex0)) {
            this.removeOut(vertex0, theAbstractEdge);
        }
        if (theAbstractEdge.leadsTo(vertex0)) {
            this.removeIn(vertex0, theAbstractEdge);
        }
        if (theAbstractEdge.leaves(vertex1)) {
            this.removeOut(vertex1, theAbstractEdge);
        }
        if (theAbstractEdge.leadsTo(vertex1)) {
            this.removeIn(vertex1, theAbstractEdge);
        }
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        return result;
    }

    protected boolean setAbstractVertexSet(AbstractVertexSet ans) {
        AbstractVertex[] vertices;
        AbstractEdge theAbstractEdge;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            theAbstractEdge = (AbstractEdge)it.next();
            vertices = theAbstractEdge.getAbstractVertices();
            if (ans.contains(vertices[0]) && ans.contains(vertices[1])) continue;
            return false;
        }
        if (this.getAbstractVertexSet() != null) {
            this.getAbstractVertexSet().deleteRemoveObserver(this);
        }
        this.abstractVertexSet = ans;
        this.abstractVertexSet.addRemoveObserver(this);
        this.removeAdj(this.abstractVertexSet);
        it = this.iterator();
        while (it.hasNext()) {
            theAbstractEdge = (AbstractEdge)it.next();
            vertices = theAbstractEdge.getAbstractVertices();
            AbstractVertex vertex0 = vertices[0];
            AbstractVertex vertex1 = vertices[1];
            if (theAbstractEdge.leaves(vertex0)) {
                this.addOut(vertex0, theAbstractEdge);
            }
            if (theAbstractEdge.leadsTo(vertex0)) {
                this.addIn(vertex0, theAbstractEdge);
            }
            if (theAbstractEdge.leaves(vertex1)) {
                this.addOut(vertex1, theAbstractEdge);
            }
            if (!theAbstractEdge.leadsTo(vertex1)) continue;
            this.addIn(vertex1, theAbstractEdge);
        }
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        return true;
    }

    public AbstractVertexSet getAbstractVertexSet() {
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
        return this.abstractVertexSet;
    }

    private void updateAdd(AbstractVertex abstractVertex, AbstractEdge abstractEdge, HashMap v) {
        MascoptFixedSet theSet = AbstractEdgeSet.getSet(abstractVertex, v);
        if (theSet == null) {
            theSet = new MascoptFixedSet(this);
            theSet.setName("AdjSet of " + abstractVertex.getId());
            v.put(abstractVertex, theSet);
        }
        theSet.addProtected(abstractEdge);
    }

    private static void updateRemove(AbstractVertex abstractVertex, AbstractEdge abstractEdge, HashMap v) {
        MascoptFixedSet theSet = AbstractEdgeSet.getSet(abstractVertex, v);
        if (theSet != null) {
            theSet.removeProtected(abstractEdge);
        }
    }

    protected MascoptFixedSet getSetIn(AbstractVertex vertex) {
        MascoptFixedSet set = AbstractEdgeSet.getSet(vertex, this.ins);
        if (set == null && this.getAbstractVertexSet().contains(vertex)) {
            set = new MascoptFixedSet(this);
            set.setName("AdjSet of " + vertex.getId());
            this.ins.put(vertex, set);
        }
        return set;
    }

    protected MascoptFixedSet getSetOut(AbstractVertex vertex) {
        MascoptFixedSet set = AbstractEdgeSet.getSet(vertex, this.outs);
        if (set == null && this.getAbstractVertexSet().contains(vertex)) {
            set = new MascoptFixedSet(this);
            set.setName("AdjSet of " + vertex.getId());
            this.outs.put(vertex, set);
        }
        return set;
    }

    protected MascoptFixedSet getSetInOut(AbstractVertex vertex) {
        MascoptFixedSet set = AbstractEdgeSet.getSet(vertex, this.inOuts);
        if (set == null && this.getAbstractVertexSet().contains(vertex)) {
            set = new MascoptFixedSet(this);
            set.setName("AdjSet of " + vertex.getId());
            this.inOuts.put(vertex, set);
        }
        return set;
    }

    private static final MascoptFixedSet getSet(AbstractVertex vertex, HashMap v) {
        return (MascoptFixedSet)v.get(vertex);
    }

    private void removeAdj(AbstractVertex vertex) {
        this.ins.remove(vertex);
        this.outs.remove(vertex);
        this.inOuts.remove(vertex);
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
    }

    private void removeAdj(AbstractVertexSet vertexSet) {
        Iterator it = vertexSet.iterator();
        while (it.hasNext()) {
            this.removeAdj((AbstractVertex)it.next());
        }
        if (!$assertionsDisabled && !AbstractEdgeSet.classInvariant(this)) {
            throw new AssertionError();
        }
    }

    private void addIn(AbstractVertex abstractVertex, AbstractEdge abstractEdge) {
        Trace.println(abstractVertex + " : ADD " + abstractEdge + " [IN]");
        this.updateAdd(abstractVertex, abstractEdge, this.ins);
        Trace.println(abstractVertex + " : ADD " + abstractEdge + " [IN_OUT]");
        this.updateAdd(abstractVertex, abstractEdge, this.inOuts);
    }

    private void addOut(AbstractVertex abstractVertex, AbstractEdge abstractEdge) {
        Trace.println(abstractVertex + " : ADD " + abstractEdge + " [OUT]");
        this.updateAdd(abstractVertex, abstractEdge, this.outs);
        Trace.println(abstractVertex + " : ADD " + abstractEdge + " [IN_OUT]");
        this.updateAdd(abstractVertex, abstractEdge, this.inOuts);
    }

    private void removeIn(AbstractVertex abstractVertex, AbstractEdge abstractEdge) {
        AbstractEdgeSet.updateRemove(abstractVertex, abstractEdge, this.ins);
        AbstractEdgeSet.updateRemove(abstractVertex, abstractEdge, this.inOuts);
    }

    private void removeOut(AbstractVertex abstractVertex, AbstractEdge abstractEdge) {
        AbstractEdgeSet.updateRemove(abstractVertex, abstractEdge, this.outs);
        AbstractEdgeSet.updateRemove(abstractVertex, abstractEdge, this.inOuts);
    }

    protected void finalize() {
        super.finalize();
        --nbInstanceES;
        this.ins = null;
        this.outs = null;
        this.inOuts = null;
    }

    public static long countAllAbstractEdgeSets() {
        return nbInstanceES;
    }

    public void free() {
        super.free();
        if (this.abstractVertexSet != null) {
            this.abstractVertexSet.deleteRemoveObserver(this);
        }
    }

    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        this.getAbstractVertexSet().toDOMTreeAsRef(node_to_go);
        return node_to_go;
    }

    private static boolean classInvariant(AbstractEdgeSet current) {
        MascoptFixedSet edgeSet;
        if (current.setOfObjects == null) {
            return current.ins.isEmpty() && current.outs.isEmpty() && current.inOuts.isEmpty();
        }
        Iterator elementsIt = current.setOfObjects.iterator();
        while (elementsIt.hasNext()) {
            MascoptFixedSet outV0;
            MascoptFixedSet inV1;
            MascoptFixedSet outV1;
            MascoptFixedSet inV0;
            AbstractEdge edge = (AbstractEdge)elementsIt.next();
            AbstractVertex[] vertices = edge.getAbstractVertices();
            MascoptFixedSet inoutV0 = AbstractEdgeSet.getSet(vertices[0], current.inOuts);
            MascoptFixedSet inoutV1 = AbstractEdgeSet.getSet(vertices[1], current.inOuts);
            if (!inoutV0.contains(edge) || !inoutV1.contains(edge)) {
                return false;
            }
            if (edge.leadsTo(vertices[0])) {
                inV0 = AbstractEdgeSet.getSet(vertices[0], current.ins);
                outV1 = AbstractEdgeSet.getSet(vertices[1], current.outs);
                if (!inV0.contains(edge) || !outV1.contains(edge)) {
                    return false;
                }
            }
            if (edge.leadsTo(vertices[1])) {
                inV1 = AbstractEdgeSet.getSet(vertices[1], current.ins);
                outV0 = AbstractEdgeSet.getSet(vertices[0], current.outs);
                if (!inV1.contains(edge) || !outV0.contains(edge)) {
                    return false;
                }
            }
            if (edge.leaves(vertices[0])) {
                inV1 = AbstractEdgeSet.getSet(vertices[1], current.ins);
                outV0 = AbstractEdgeSet.getSet(vertices[0], current.outs);
                if (!inV1.contains(edge) || !outV0.contains(edge)) {
                    return false;
                }
            }
            if (!edge.leaves(vertices[1])) continue;
            inV0 = AbstractEdgeSet.getSet(vertices[0], current.ins);
            outV1 = AbstractEdgeSet.getSet(vertices[1], current.outs);
            if (inV0.contains(edge) && outV1.contains(edge)) continue;
            return false;
        }
        Iterator edgeInMap = current.ins.values().iterator();
        while (edgeInMap.hasNext()) {
            edgeSet = (MascoptFixedSet)edgeInMap.next();
            if (current.setOfObjects.containsAll(edgeSet)) continue;
            return false;
        }
        edgeInMap = current.outs.values().iterator();
        while (edgeInMap.hasNext()) {
            edgeSet = (MascoptFixedSet)edgeInMap.next();
            if (current.setOfObjects.containsAll(edgeSet)) continue;
            return false;
        }
        edgeInMap = current.inOuts.values().iterator();
        while (edgeInMap.hasNext()) {
            edgeSet = (MascoptFixedSet)edgeInMap.next();
            if (current.setOfObjects.containsAll(edgeSet)) continue;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !AbstractEdgeSet.class.desiredAssertionStatus();
        idGenerator = 0;
        nbInstanceES = 0L;
        nbInstanceNS = 0L;
    }
}

