/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.graphs.Vertex;
import mascoptLib.util.Trace;
import org.w3c.dom.Element;

public abstract class AbstractGraph
extends MascoptObject {
    private static int idGenerator = 0;
    private static int nbInstanceOfGraphs;
    private AbstractVertexSet abstractVertexSet;
    private AbstractEdgeSet abstractEdgeSet;
    private AbstractGraph superGraph;

    public AbstractGraph() {
        this.id = "G" + idGenerator++;
        this.setValue("id", this.id);
        Trace.newObj(this.id);
        ++nbInstanceOfGraphs;
    }

    public AbstractGraph(AbstractVertexSet abstractVertexSet, AbstractEdgeSet abstractEdgeSet) {
        this();
        if (abstractVertexSet != null || abstractEdgeSet != null && abstractEdgeSet.getAbstractVertexSet() != null) {
            if (abstractVertexSet == null) {
                this.abstractVertexSet = abstractEdgeSet.getAbstractVertexSet();
                this.abstractEdgeSet = abstractEdgeSet;
            } else if (abstractEdgeSet != null && abstractEdgeSet.getAbstractVertexSet() != null) {
                this.abstractVertexSet = abstractVertexSet;
                this.abstractEdgeSet = abstractEdgeSet;
                if (abstractVertexSet != abstractEdgeSet.getAbstractVertexSet()) {
                    this.syncAndAddObservers(abstractVertexSet, abstractEdgeSet.getAbstractVertexSet());
                }
            } else {
                this.abstractVertexSet = abstractVertexSet;
                if (abstractEdgeSet != null) {
                    this.abstractEdgeSet = abstractEdgeSet;
                    this.abstractEdgeSet.setAbstractVertexSet(this.abstractVertexSet);
                    this.addMissingVertices(this.abstractVertexSet, this.abstractEdgeSet);
                }
            }
        }
    }

    public AbstractGraph(AbstractGraph superGraph) {
        this();
        this.setSuperGraph(superGraph);
        AbstractGraphFactory agf = this.getFactory();
        AbstractVertexSet subVertexSet = agf.newAbstractVertexSet(superGraph.getAbstractVertexSet());
        subVertexSet.setName("Sub vertex set of " + superGraph.getAbstractVertexSet().getName() + " (" + superGraph.getAbstractVertexSet().getId() + ")");
        AbstractEdgeSet subEdgeSet = agf.newAbstractEdgeSet(superGraph.getAbstractEdgeSet(), subVertexSet);
        subEdgeSet.setName("Sub edge set of " + superGraph.getAbstractEdgeSet().getName() + " (" + superGraph.getAbstractEdgeSet().getId() + ")");
        this.abstractVertexSet = subVertexSet;
        this.abstractEdgeSet = subEdgeSet;
        if (this.abstractVertexSet != this.abstractEdgeSet.getAbstractVertexSet()) {
            this.syncAndAddObservers(this.abstractVertexSet, this.abstractEdgeSet.getAbstractVertexSet());
        }
        this.setName("Subgraph of " + superGraph.getName() + " (" + superGraph.getId() + ")");
    }

    public AbstractGraph(AbstractGraph graph, boolean copyElements) {
        this();
        this.abstractVertexSet = this.getFactory().newAbstractVertexSet();
        this.abstractEdgeSet = this.getFactory().newAbstractEdgeSet(this.abstractVertexSet);
        if (!copyElements) {
            this.setSuperGraph(graph.getSuperGraph());
        }
        this.abstractVertexSet.setName("NS of graph " + this.id);
        this.abstractEdgeSet.setName("ES of graph " + this.id);
        HashMap<AbstractVertex, AbstractVertex> vertexResolve = new HashMap<AbstractVertex, AbstractVertex>();
        Iterator it = graph.getAbstractVertexSet().iterator();
        while (it.hasNext()) {
            AbstractVertex oldVertex = (AbstractVertex)it.next();
            if (copyElements) {
                AbstractVertex newVertex = this.getFactory().newAbstractVertex();
                newVertex.setName("copy of " + oldVertex.getId() + " instancied by Graph " + this.id);
                vertexResolve.put(oldVertex, newVertex);
                this.abstractVertexSet.add(newVertex);
                newVertex.copyValues(oldVertex);
                continue;
            }
            this.abstractVertexSet.add(oldVertex);
        }
        it = graph.getAbstractEdgeSet().iterator();
        while (it.hasNext()) {
            AbstractEdge oldEdge = (AbstractEdge)it.next();
            if (copyElements) {
                AbstractVertex[] vertices = oldEdge.getAbstractVertices();
                AbstractEdge newEdge = this.getFactory().newAbstractEdge((AbstractVertex)vertexResolve.get(vertices[0]), (AbstractVertex)vertexResolve.get(vertices[1]));
                newEdge.setName("copy of " + oldEdge.getId() + " instancied by Graph " + this.id);
                this.abstractEdgeSet.add(newEdge);
                newEdge.copyValues(oldEdge);
                continue;
            }
            this.abstractEdgeSet.add(oldEdge);
        }
        this.setName("Copy of graph " + graph.getName() + " (" + graph.getId() + ")");
    }

    public String toString() {
        return "AG V=" + this.abstractVertexSet + " E=" + this.abstractEdgeSet;
    }

    public abstract AbstractGraphFactory getFactory();

    public boolean checkIntegrity() {
        return true;
    }

    public AbstractVertexSet getAbstractVertexSet() {
        return this.abstractVertexSet;
    }

    public AbstractEdgeSet getAbstractEdgeSet() {
        return this.abstractEdgeSet;
    }

    protected boolean setAbstractVertexSet(AbstractVertexSet ans) {
        boolean retour = true;
        if (ans == null) {
            return false;
        }
        if (this.abstractEdgeSet != null && this.abstractEdgeSet.getAbstractVertexSet() != null && this.abstractEdgeSet.getAbstractVertexSet() != ans) {
            this.abstractEdgeSet.getAbstractVertexSet().deleteAddObserver(this.abstractVertexSet);
            this.abstractEdgeSet.getAbstractVertexSet().deleteRemoveObserver(this.abstractVertexSet);
            this.abstractVertexSet.deleteAddObserver(this.abstractEdgeSet.getAbstractVertexSet());
            this.abstractVertexSet.deleteRemoveObserver(this.abstractEdgeSet.getAbstractVertexSet());
            this.abstractEdgeSet.getAbstractVertexSet().clear();
            retour = this.syncAndAddObservers(ans, this.abstractEdgeSet.getAbstractVertexSet());
        }
        if (retour) {
            this.abstractVertexSet = ans;
        }
        return retour;
    }

    protected boolean setAbstractEdgeSet(AbstractEdgeSet aes) {
        boolean retour = true;
        if (this.abstractEdgeSet != null) {
            this.abstractEdgeSet.getAbstractVertexSet().deleteAddObserver(this.abstractVertexSet);
            this.abstractEdgeSet.getAbstractVertexSet().deleteRemoveObserver(this.abstractVertexSet);
            this.abstractVertexSet.deleteAddObserver(this.abstractEdgeSet.getAbstractVertexSet());
            this.abstractVertexSet.deleteRemoveObserver(this.abstractEdgeSet.getAbstractVertexSet());
        }
        if (retour = this.syncAndAddObservers(this.abstractVertexSet, aes.getAbstractVertexSet())) {
            this.abstractEdgeSet = aes;
        }
        return retour;
    }

    public void replace(AbstractVertex vertex, AbstractGraph g) {
        Trace.println("Not implemented!");
    }

    public void replace(AbstractVertex vertex, AbstractVertexSet vertexSet) {
        Trace.println("Not implemented!");
    }

    public AbstractGraph copyAbstractGraph() {
        return this.getFactory().newAbstractCopyGraph(this, true);
    }

    public void free() {
        super.free();
        this.abstractEdgeSet.free();
        this.abstractVertexSet.free();
    }

    protected void finalize() {
        --nbInstanceOfGraphs;
    }

    public static int countAllAbstractGraphs() {
        return nbInstanceOfGraphs;
    }

    private boolean syncAndAddObservers(AbstractVertexSet ans1, AbstractVertexSet ans2) {
        Vertex candidateVertex = null;
        boolean retour = true;
        Iterator itesn = ans2.iterator();
        while (itesn.hasNext()) {
            candidateVertex = (Vertex)itesn.next();
            if (ans1.contains(candidateVertex)) continue;
            retour &= ans1.add(candidateVertex);
        }
        Iterator itnsn = ans1.iterator();
        while (itnsn.hasNext()) {
            candidateVertex = (Vertex)itnsn.next();
            if (ans2.contains(candidateVertex)) continue;
            retour &= ans2.add(candidateVertex);
        }
        ans1.addAddObserver(ans2);
        ans2.addAddObserver(ans1);
        ans1.addRemoveObserver(ans2);
        ans2.addRemoveObserver(ans1);
        return retour;
    }

    public AbstractGraph getSuperGraph() {
        return this.superGraph;
    }

    public boolean isSubGraph() {
        return this.superGraph != null;
    }

    public boolean setSuperGraph(AbstractGraph superGraph) {
        AbstractVertexSet potentiallySuperVertexSet = null;
        if (this.abstractVertexSet != null) {
            potentiallySuperVertexSet = (AbstractVertexSet)this.abstractVertexSet.getSuperSet();
        }
        AbstractEdgeSet potentiallySuperEdgeSet = null;
        if (this.abstractEdgeSet != null) {
            potentiallySuperEdgeSet = (AbstractEdgeSet)this.abstractEdgeSet.getSuperSet();
        }
        if (potentiallySuperVertexSet != null && potentiallySuperEdgeSet != null && potentiallySuperVertexSet == superGraph.getAbstractVertexSet() && potentiallySuperEdgeSet == superGraph.getAbstractEdgeSet()) {
            this.superGraph = superGraph;
            return true;
        }
        return false;
    }

    public Iterator breadthFirstIterator(AbstractVertex root) {
        Vector<AbstractEdge> bfs = new Vector<AbstractEdge>();
        Vector<AbstractVertex> queue = new Vector<AbstractVertex>();
        Vector<AbstractVertex> alreadyVisited = new Vector<AbstractVertex>();
        queue.add(root);
        alreadyVisited.add(root);
        while (!queue.isEmpty()) {
            AbstractVertex currentVertex = (AbstractVertex)queue.remove(0);
            MascoptFixedSet neighbors = currentVertex.getOutgoing(this.abstractEdgeSet);
            Iterator itN = neighbors.iterator();
            while (itN.hasNext()) {
                AbstractEdge currentEdge = (AbstractEdge)itN.next();
                AbstractVertex theNeighbor = currentEdge.getOppositeAbstractVertex(currentVertex);
                if (alreadyVisited.contains(theNeighbor)) continue;
                alreadyVisited.add(theNeighbor);
                queue.add(theNeighbor);
                bfs.add(currentEdge);
            }
        }
        return bfs.iterator();
    }

    public Iterator depthFirstIterator(AbstractVertex root) {
        Vector<AbstractEdge> dfs = new Vector<AbstractEdge>();
        Vector<AbstractVertex> queue = new Vector<AbstractVertex>();
        Vector<AbstractVertex> alreadyVisited = new Vector<AbstractVertex>();
        queue.add(root);
        alreadyVisited.add(root);
        while (!queue.isEmpty()) {
            AbstractVertex currentVertex = (AbstractVertex)queue.remove(queue.size() - 1);
            MascoptFixedSet neighbors = currentVertex.getOutgoing(this.abstractEdgeSet);
            Iterator itN = neighbors.iterator();
            while (itN.hasNext()) {
                AbstractEdge currentEdge = (AbstractEdge)itN.next();
                AbstractVertex theNeighbor = currentEdge.getOppositeAbstractVertex(currentVertex);
                if (alreadyVisited.contains(theNeighbor)) continue;
                alreadyVisited.add(theNeighbor);
                queue.add(theNeighbor);
                dfs.add(currentEdge);
            }
        }
        return dfs.iterator();
    }

    public void addMissingVertices(AbstractVertexSet avs, AbstractEdgeSet aes) {
        Iterator itaes = aes.iterator();
        AbstractEdge ae = null;
        AbstractVertex n0 = null;
        AbstractVertex n1 = null;
        while (itaes.hasNext()) {
            ae = (AbstractEdge)itaes.next();
            n0 = ae.getAbstractVertices()[0];
            n1 = ae.getAbstractVertices()[1];
            if (!avs.contains(n0)) {
                avs.add(n0);
            }
            if (avs.contains(n1)) continue;
            avs.add(n1);
        }
    }

    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        this.getAbstractVertexSet().toDOMTreeAsRef(node_to_go);
        this.getAbstractEdgeSet().toDOMTreeAsRef(node_to_go);
        return node_to_go;
    }
}

