/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import java.util.Iterator;
import java.util.Observable;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.MascoptSet;
import mascoptLib.util.NotifyReason;
import mascoptLib.util.Trace;

public abstract class AbstractGraphSet
extends MascoptSet {
    private static int idGenerator = 0;
    private static long nbInstanceGS = 0L;

    public AbstractGraphSet() {
        ++nbInstanceGS;
        this.id = "GS" + idGenerator++;
        Trace.newObj(this.id);
    }

    public AbstractGraphSet(AbstractGraphSet superSet) {
        super(superSet);
        ++nbInstanceGS;
        this.id = "GS" + idGenerator++;
        Trace.newObj(this.id);
    }

    public AbstractGraphSet(AbstractGraphSet originalSet, boolean copyElements) {
        block3: {
            block2: {
                this();
                this.setName("Copy of set " + originalSet.getName() + " (" + originalSet.getId() + ")");
                if (originalSet == null || !copyElements) break block2;
                AbstractGraphFactory ansf = originalSet.getFactory();
                Iterator itOS = originalSet.iterator();
                while (itOS.hasNext()) {
                    AbstractGraph graphToCopy = (AbstractGraph)itOS.next();
                    AbstractGraph newGraph = ansf.newAbstractCopyGraph(graphToCopy, false);
                    newGraph.copyValues(graphToCopy);
                    newGraph.setName("Copy of graph with id=" + graphToCopy.getId());
                    this.add(newGraph);
                }
                break block3;
            }
            if (originalSet == null || copyElements) break block3;
            Iterator itOS = originalSet.iterator();
            while (itOS.hasNext()) {
                this.add(itOS.next());
            }
        }
    }

    public abstract AbstractGraphFactory getFactory();

    public void update(Observable o, Object arg) {
        if (!(arg instanceof NotifyReason)) {
            return;
        }
    }

    public boolean add(AbstractGraph o) {
        return super.add(o);
    }

    public boolean remove(AbstractGraph o) {
        return super.remove(o);
    }

    protected void finalize() {
        super.finalize();
        --nbInstanceGS;
    }

    public static long countAllAbstractGraphSets() {
        return nbInstanceGS;
    }
}

