/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractGraphFactory;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.util.NotifyReason;
import mascoptLib.util.Trace;
import mascoptLib.util.exception.MascoptImpossibleOperationPathException;
import org.w3c.dom.Element;

public abstract class AbstractPath
extends AbstractGraph
implements Observer {
    private static long nbInstanceAC = 0L;
    private AbstractGraphFactory factory = this.getFactory();
    protected AbstractVertex start = null;
    protected AbstractVertex end = null;
    protected boolean isMulti;

    public AbstractPath(AbstractEdgeSet abstractEdgeSet) {
        ++nbInstanceAC;
        AbstractVertexSet abs = this.factory.newAbstractVertexSet(abstractEdgeSet.getAbstractVertexSet());
        abs.setName("VertexSet Of path" + this.id);
        AbstractEdgeSet aes = this.factory.newAbstractEdgeSet(abstractEdgeSet, abs);
        aes.setName("EdgeSet Of path" + this.id);
        this.setAbstractVertexSet(abs);
        this.setAbstractEdgeSet(aes);
        this.isMulti = false;
        abs.setAddRemoveAllowed(false);
        aes.setAddRemoveAllowed(false);
    }

    public AbstractPath(AbstractPath path) {
        super(path, false);
        ++nbInstanceAC;
        this.factory = path.getFactory();
        this.start = path.start;
        this.end = path.end;
        this.isMulti = path.isMulti;
        this.getAbstractVertexSet().setAddRemoveAllowed(false);
        this.getAbstractEdgeSet().setAddRemoveAllowed(false);
    }

    public String toString() {
        if (this.isMulti()) {
            return "multi-abstractpath (hard to display)";
        }
        String name = "" + this.start;
        AbstractVertex tmp = this.nextAbstractVertex(this.start);
        while (tmp != this.end) {
            name = name + "-" + tmp;
            tmp = this.nextAbstractVertex(tmp);
        }
        name = name + "-" + this.end;
        return name;
    }

    public boolean removeLastEdge() throws MascoptImpossibleOperationPathException {
        if (this.isMulti()) {
            throw new MascoptImpossibleOperationPathException("Cannot remove last edge of a multi-path !");
        }
        boolean bool = true;
        boolean bool_temp = true;
        AbstractVertex endCurrent = this.getAbstractEnd();
        AbstractEdge edgeEnd = this.predAbstractEdge(endCurrent);
        AbstractVertex newEnd = edgeEnd.getOppositeAbstractVertex(endCurrent);
        AbstractEdgeSet aes = this.getAbstractEdgeSet();
        aes.setAddRemoveAllowed(true);
        bool_temp = aes.remove(edgeEnd);
        bool = bool && bool_temp;
        aes.setAddRemoveAllowed(false);
        AbstractVertexSet abs = this.getAbstractVertexSet();
        abs.setAddRemoveAllowed(true);
        bool_temp = abs.remove(endCurrent);
        bool = bool && bool_temp;
        abs.setAddRemoveAllowed(false);
        this.end = newEnd;
        return bool;
    }

    private boolean addAndUpdate(AbstractVertex sourceVertex, AbstractEdge abstractEdge) {
        boolean bool = true;
        boolean bool_temp = true;
        AbstractVertex targetVertex = sourceVertex.getConnected(abstractEdge);
        AbstractVertexSet abs = this.getAbstractVertexSet();
        abs.setAddRemoveAllowed(true);
        bool_temp = abs.add(sourceVertex);
        bool = bool && bool_temp;
        bool_temp = abs.add(targetVertex);
        bool = bool && bool_temp;
        abs.setAddRemoveAllowed(false);
        AbstractEdgeSet aes = this.getAbstractEdgeSet();
        aes.setAddRemoveAllowed(true);
        bool_temp = aes.add(abstractEdge);
        bool = bool && bool_temp;
        aes.setAddRemoveAllowed(false);
        return bool;
    }

    private boolean addAndUpdate(AbstractVertex start, MascoptFixedSet abstractEdgeSet) {
        if (abstractEdgeSet == null) {
            throw new MascoptImpossibleOperationPathException();
        }
        boolean bool = true;
        boolean bool_temp = true;
        Iterator it = abstractEdgeSet.iterator();
        while (it.hasNext()) {
            bool_temp = this.addAndUpdate(start, (AbstractEdge)it.next());
            bool = bool && bool_temp;
        }
        return bool;
    }

    private void addAll(AbstractPath abstractPath, boolean reverse) {
        Iterator vertices = abstractPath.getAbstractVertexSet().iterator();
        while (vertices.hasNext()) {
            AbstractVertex tmp = (AbstractVertex)vertices.next();
            this.addAndUpdate(tmp, reverse ? abstractPath.predAbstractEdgeSet(tmp) : abstractPath.nextAbstractEdgeSet(tmp));
        }
    }

    private boolean concat(AbstractPath abstractPath, AbstractVertex connectedVertex, boolean reverse) {
        AbstractVertexSet currentVertexSet = this.getAbstractVertexSet();
        AbstractVertexSet newVertexSet = abstractPath.getAbstractVertexSet();
        Iterator vertices = newVertexSet.iterator();
        while (vertices.hasNext()) {
            AbstractVertex tmp = (AbstractVertex)vertices.next();
            if (!currentVertexSet.contains(tmp) || tmp == connectedVertex) continue;
            throw new MascoptImpossibleOperationPathException("Impossible to make a loop !");
        }
        this.addAll(abstractPath, reverse);
        return true;
    }

    public boolean concatAbstractEdge(AbstractEdge abstractEdge) {
        if (this.getAbstractStart() == null) {
            AbstractVertex[] vertices = abstractEdge.getAbstractVertices();
            this.init(vertices[0], vertices[1], abstractEdge);
            return true;
        }
        if (abstractEdge.isLoop()) {
            throw new MascoptImpossibleOperationPathException("We cannot add a loop !");
        }
        if (this.isClosed()) {
            throw new MascoptImpossibleOperationPathException("The path is closed (loop). We cannot add a other edge.");
        }
        Trace.println("concat: start = " + this.start + " add edg " + abstractEdge);
        AbstractVertex[] vertices = abstractEdge.getAbstractVertices();
        AbstractVertex vertex0 = vertices[0];
        AbstractVertex vertex1 = vertices[1];
        if (this.end == vertex0 && this.end.getConnected(abstractEdge) == vertex1 || this.end == vertex1 && this.end.getConnected(abstractEdge) == vertex0) {
            AbstractVertex newEnd = this.end.getConnected(abstractEdge);
            if (this.getAbstractVertexSet().contains(newEnd) && newEnd != this.getAbstractStart()) {
                throw new MascoptImpossibleOperationPathException("You cannot do a loop. A node of this edge is already in the path.");
            }
            this.addAndUpdate(this.end, abstractEdge);
            this.end = newEnd;
            return true;
        }
        if (this.start == vertex0 && vertex1.getConnected(abstractEdge) == this.start || this.start == vertex1 && vertex0.getConnected(abstractEdge) == this.start) {
            AbstractVertex newStart;
            AbstractVertex abstractVertex = newStart = this.start == vertex0 ? vertex1 : vertex0;
            if (this.getAbstractVertexSet().contains(newStart) && newStart != this.getAbstractEnd()) {
                throw new MascoptImpossibleOperationPathException("You cannot do a loop. A node of this edge is already in the path.");
            }
            this.addAndUpdate(newStart, abstractEdge);
            this.start = newStart;
            return true;
        }
        throw new MascoptImpossibleOperationPathException("Error unknown when adding an edge in a path.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean concatAbstractPath(AbstractPath abstractPath) {
        if (this.getAbstractEnd() == abstractPath.getAbstractStart()) {
            if (!this.concat(abstractPath, this.getAbstractEnd(), false)) return false;
            this.end = abstractPath.getAbstractEnd();
        } else if (this.getAbstractEnd() == abstractPath.getAbstractEnd()) {
            if (!this.concat(abstractPath, this.getAbstractEnd(), true)) return false;
            this.end = abstractPath.getAbstractStart();
        } else if (this.getAbstractStart() == abstractPath.getAbstractEnd()) {
            if (!this.concat(abstractPath, this.getAbstractStart(), false)) return false;
            this.start = abstractPath.getAbstractStart();
        } else if (this.getAbstractStart() == abstractPath.getAbstractStart()) {
            if (!this.concat(abstractPath, this.getAbstractStart(), true)) return false;
            this.start = abstractPath.getAbstractEnd();
        } else if (this.getAbstractStart() == null) {
            this.start = abstractPath.getAbstractStart();
            this.end = abstractPath.getAbstractEnd();
            this.concat(abstractPath, this.getAbstractEnd(), false);
        } else {
            Trace.printErrln("Concat failed");
            return false;
        }
        if (!abstractPath.isMulti()) return true;
        this.isMulti = true;
        return true;
    }

    public boolean mergeAbstractPath(AbstractPath abstractPath) {
        if (this.getAbstractStart() == abstractPath.getAbstractStart() && this.getAbstractEnd() == abstractPath.getAbstractEnd()) {
            this.addAll(abstractPath, false);
        } else if (this.getAbstractStart() == abstractPath.getAbstractEnd() && this.getAbstractEnd() == abstractPath.getAbstractStart()) {
            this.addAll(abstractPath, true);
        } else {
            Trace.printErrln("Merge failed");
            return false;
        }
        if (this.getAbstractVertexSet() != abstractPath.getAbstractVertexSet() || this.getAbstractEdgeSet() != abstractPath.getAbstractEdgeSet()) {
            this.isMulti = true;
        }
        return true;
    }

    protected void init(AbstractVertex start, AbstractVertex end, AbstractEdge first) {
        this.start = start;
        this.end = end;
        this.addAndUpdate(start, first);
    }

    protected void setStart(AbstractVertex start) {
        if (this.getAbstractStart() != null) {
            return;
        }
        this.start = start;
        AbstractVertexSet abs = this.getAbstractVertexSet();
        abs.setAddRemoveAllowed(true);
        abs.add(start);
        abs.setAddRemoveAllowed(false);
    }

    protected void setEnd(AbstractVertex end) {
        if (this.getAbstractEnd() != null) {
            return;
        }
        this.end = end;
        AbstractVertexSet abs = this.getAbstractVertexSet();
        abs.setAddRemoveAllowed(true);
        abs.add(end);
        abs.setAddRemoveAllowed(false);
    }

    public AbstractVertex getAbstractStart() {
        return this.start;
    }

    public AbstractVertex getAbstractEnd() {
        return this.end;
    }

    public boolean isStart(AbstractVertex aVertex) {
        return this.start == aVertex;
    }

    public boolean isEnd(AbstractVertex aVertex) {
        return this.end == aVertex;
    }

    public boolean isClosed() {
        return this.getAbstractStart() == this.getAbstractEnd() && this.getAbstractStart() != null;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public MascoptFixedSet nextAbstractEdgeSet(AbstractVertex vertex) {
        return vertex.getOutgoing(this.getAbstractEdgeSet());
    }

    public MascoptFixedSet predAbstractEdgeSet(AbstractVertex vertex) {
        return vertex.getIncoming(this.getAbstractEdgeSet());
    }

    public static long countAllAbstractPaths() {
        return nbInstanceAC;
    }

    protected void finalize() {
        super.finalize();
        --nbInstanceAC;
    }

    public AbstractEdge nextAbstractEdge(AbstractVertex vertex) {
        if (this.isMulti) {
            return null;
        }
        MascoptFixedSet aes = this.nextAbstractEdgeSet(vertex);
        if (aes == null) {
            return null;
        }
        if (aes.size() == 2) {
            throw new MascoptImpossibleOperationPathException("There is two possibilities to exit the vertex " + vertex + " and we cannot choose what edge to return.");
        }
        if (!aes.iterator().hasNext()) {
            return null;
        }
        return (AbstractEdge)aes.iterator().next();
    }

    public AbstractEdge predAbstractEdge(AbstractVertex vertex) {
        if (this.isMulti) {
            return null;
        }
        MascoptFixedSet aes = this.predAbstractEdgeSet(vertex);
        if (aes == null) {
            return null;
        }
        return (AbstractEdge)aes.iterator().next();
    }

    public AbstractVertex nextAbstractVertex(AbstractVertex vertex) {
        AbstractEdge ae = this.nextAbstractEdge(vertex);
        if (ae == null) {
            return null;
        }
        return ae.getConnected(vertex);
    }

    public boolean checkIntegrity() {
        return true;
    }

    public void update(Observable o, Object arg) {
        if (!(arg instanceof NotifyReason)) {
            return;
        }
        NotifyReason nr = (NotifyReason)arg;
        Object[] objs = nr.getObjects();
        String message = nr.getMessage();
        Trace.print(this.getId() + ": message=" + message + " objs=" + objs + " =>");
        if (message.equalsIgnoreCase("Remove")) {
            if (objs[0] instanceof AbstractEdge) {
                Trace.println("on enleve des edge sur mon edge set");
                if (this.getAbstractEdgeSet().contains(objs[0])) {
                    this.finalize();
                    this.start = null;
                    this.end = null;
                }
            }
        } else {
            Trace.println("nothing else to do.");
        }
    }

    public void free() {
        super.free();
        if (this.getSuperGraph() != null) {
            this.getSuperGraph().deleteRemoveObserver(this);
        }
    }

    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        this.getAbstractEdgeSet().toDOMTreeAsRef(node_to_go);
        return node_to_go;
    }
}

