/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractEdgeSet;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.abstractGraph.MascoptObject;

public abstract class AbstractVertex
extends MascoptObject {
    private static int idGenerator = 0;
    private static int nbInstanceVertex;
    private double x;
    private double y;
    HashMap inAbstractEdges;
    HashMap outAbstractEdges;
    HashMap inOutAbstractEdges;

    public AbstractVertex(double x, double y) {
        this.id = "V" + idGenerator++;
        this.setX(x);
        this.setY(y);
        this.setValue("id", this.id);
        ++nbInstanceVertex;
    }

    public AbstractVertex() {
        this(0.0, 0.0);
    }

    public String toString() {
        return this.getName();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
        this.setValue("x", "" + x);
    }

    public void setY(double y) {
        this.y = y;
        this.setValue("y", "" + y);
    }

    public int getDegree(AbstractEdgeSet es) {
        return this.getIncidentEdges(es).size();
    }

    public int getInDegree(AbstractEdgeSet es) {
        return this.getIncoming(es).size();
    }

    public int getOutDegree(AbstractEdgeSet es) {
        return this.getOutgoing(es).size();
    }

    public MascoptFixedSet getIncoming(AbstractEdgeSet es) {
        return es.getSetIn(this);
    }

    public MascoptFixedSet getOutgoing(AbstractEdgeSet es) {
        return es.getSetOut(this);
    }

    public MascoptFixedSet getIncidentEdges(AbstractEdgeSet es) {
        return es.getSetInOut(this);
    }

    public MascoptFixedSet getNeighbours(AbstractEdgeSet es) {
        MascoptFixedSet returnNs = new MascoptFixedSet();
        returnNs.setName("Fixed set created by vertex" + this.id + " for neighbours");
        MascoptFixedSet outAbstractEdges = this.getOutgoing(es);
        Iterator it = outAbstractEdges.iterator();
        while (it.hasNext()) {
            AbstractEdge abstractEdge = (AbstractEdge)it.next();
            returnNs.addProtected(abstractEdge.getConnected(this));
        }
        return returnNs;
    }

    public int getDegree(AbstractGraph graph) {
        return this.getDegree(graph.getAbstractEdgeSet());
    }

    public int getInDegree(AbstractGraph graph) {
        return this.getInDegree(graph.getAbstractEdgeSet());
    }

    public int getOutDegree(AbstractGraph graph) {
        return this.getOutDegree(graph.getAbstractEdgeSet());
    }

    public MascoptFixedSet getIncoming(AbstractGraph graph) {
        return this.getIncoming(graph.getAbstractEdgeSet());
    }

    public MascoptFixedSet getOutgoing(AbstractGraph graph) {
        return this.getOutgoing(graph.getAbstractEdgeSet());
    }

    public MascoptFixedSet getIncidentEdges(AbstractGraph graph) {
        return this.getIncidentEdges(graph.getAbstractEdgeSet());
    }

    public MascoptFixedSet getNeighbours(AbstractGraph graph) {
        return this.getNeighbours(graph.getAbstractEdgeSet());
    }

    public AbstractVertex getConnected(AbstractEdge abstractEdge) {
        return abstractEdge.getConnected(this);
    }

    public MascoptFixedSet getEdgesTo(AbstractEdgeSet aes, AbstractVertex abstractVertex) {
        MascoptFixedSet outs = this.getOutgoing(aes);
        MascoptFixedSet ret = new MascoptFixedSet(outs);
        ret.setName("Edge Set stored by vertex " + this.getId() + " for edgesTo");
        Iterator it = outs.iterator();
        while (it.hasNext()) {
            AbstractEdge edge = (AbstractEdge)it.next();
            if (!edge.leadsTo(abstractVertex)) continue;
            ret.addProtected(edge);
        }
        ret.free();
        return ret;
    }

    public MascoptFixedSet getEdgesTo(AbstractGraph ag, AbstractVertex abstractVertex) {
        return this.getEdgesTo(ag.getAbstractEdgeSet(), abstractVertex);
    }

    protected void finalize() {
        --nbInstanceVertex;
    }

    public static int order() {
        return nbInstanceVertex;
    }
}

