/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import java.util.Iterator;
import java.util.Observable;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSetFactory;
import mascoptLib.abstractGraph.MascoptSet;
import mascoptLib.util.NotifyReason;
import mascoptLib.util.Trace;

public abstract class AbstractVertexSet
extends MascoptSet {
    private static int idGenerator = 0;
    private static long nbInstanceNS = 0L;
    NotifyReason lastReason;

    public AbstractVertexSet() {
        this.lastReason = null;
        ++nbInstanceNS;
        this.id = "NS" + idGenerator++;
        Trace.newObj(this.id);
    }

    public AbstractVertexSet(AbstractVertexSet superSet) {
        super(superSet);
        this.lastReason = null;
        ++nbInstanceNS;
        this.id = "NS" + idGenerator++;
        Trace.newObj(this.id);
    }

    public AbstractVertexSet(AbstractVertexSet originalSet, boolean copyElements) {
        block3: {
            block2: {
                this();
                this.setName("Copy of set " + originalSet.getName() + " (" + originalSet.getId() + ")");
                if (originalSet == null || !copyElements) break block2;
                AbstractVertexSetFactory ansf = originalSet.getFactory();
                Iterator itOS = originalSet.iterator();
                while (itOS.hasNext()) {
                    AbstractVertex vertexToCopy = (AbstractVertex)itOS.next();
                    AbstractVertex newVertex = ansf.newAbstractVertex(vertexToCopy.getX(), vertexToCopy.getY());
                    newVertex.copyValues(vertexToCopy);
                    newVertex.setName("Copy of vertex with id=" + vertexToCopy.getId());
                    this.add(newVertex);
                }
                break block3;
            }
            if (originalSet == null || copyElements) break block3;
            Iterator itOS = originalSet.iterator();
            while (itOS.hasNext()) {
                this.add(itOS.next());
            }
        }
    }

    public abstract AbstractVertexSetFactory getFactory();

    public void update(Observable o, Object arg) {
        if (!(arg instanceof NotifyReason)) {
            return;
        }
        NotifyReason nr = (NotifyReason)arg;
        Object[] objs = nr.getObjects();
        String message = nr.getMessage();
        Trace.print(this.getId() + "message=" + message + " objs=" + objs + " =>");
        if (message.equalsIgnoreCase("Remove")) {
            if (objs[0] instanceof AbstractVertex && this.contains(objs[0])) {
                Trace.println("Je l'enleve je suis un subset");
                this.remove(objs[0]);
            } else if (message.equalsIgnoreCase("Add")) {
                // empty if block
            }
        } else {
            Trace.println("pas implemente");
        }
    }

    public boolean add(AbstractVertex o) {
        return super.add(o);
    }

    public boolean remove(AbstractVertex o) {
        return super.remove(o);
    }

    protected void finalize() {
        super.finalize();
        --nbInstanceNS;
    }

    public static long countAllAbstractVertexSets() {
        return nbInstanceNS;
    }
}

