/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import mascoptLib.abstractGraph.MascoptObject;
import mascoptLib.util.Pair;
import mascoptLib.util.exception.MascoptAddRemoveSetException;
import org.w3c.dom.Element;

public class MascoptFixedSet
extends MascoptObject
implements Set {
    private static int nbSetInstances;
    protected LinkedHashSet setOfObjects = new LinkedHashSet(initialCapacity, loadFactor);
    private MascoptFixedSet superSet;
    public static int initialCapacity;
    public static float loadFactor;

    public MascoptFixedSet() {
        ++nbSetInstances;
    }

    public MascoptFixedSet(MascoptFixedSet superSet) {
        this();
        ++nbSetInstances;
        this.setSuperSet(superSet);
        if (superSet != null) {
            superSet.addRemoveObserver(this);
        }
    }

    public MascoptFixedSet getSuperSet() {
        return this.superSet;
    }

    public boolean isSubSet() {
        return this.superSet != null;
    }

    public boolean setSuperSet(MascoptFixedSet superSet) {
        this.superSet = superSet;
        return true;
    }

    public int hashCode() {
        return this.setOfObjects.hashCode();
    }

    public boolean equals(Object object) {
        return this.setOfObjects.equals(object);
    }

    public boolean contains(Object object) {
        return this.setOfObjects.contains(object);
    }

    public int size() {
        return this.setOfObjects.size();
    }

    public Object[] toArray() {
        return this.setOfObjects.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.toArray((MascoptObject[])objectArray);
    }

    public MascoptObject[] toArray(MascoptObject[] mascoptObjectArray) {
        return (MascoptObject[])this.setOfObjects.toArray();
    }

    public Iterator iterator() {
        return this.setOfObjects.iterator();
    }

    public boolean isEmpty() {
        return this.setOfObjects.isEmpty();
    }

    public boolean containsAll(Collection collection) {
        return this.setOfObjects.containsAll(collection);
    }

    private Object find(String key, Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)v.elementAt(i);
            if (!key.equals((String)p.getKey())) continue;
            return p.getValue();
        }
        return null;
    }

    private Object find(Object key, Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)v.elementAt(i);
            if (key != p.getKey()) continue;
            return p.getValue();
        }
        return null;
    }

    private Pair getPair(Object key, Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)v.elementAt(i);
            if (key != p.getKey()) continue;
            return p;
        }
        return null;
    }

    public void free() {
        if (this.superSet != null) {
            this.superSet.deleteRemoveObserver(this);
        }
    }

    public static int countAllSets() {
        return nbSetInstances;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        Iterator elements = this.iterator();
        String toS = "{ " + elements.next();
        while (elements.hasNext()) {
            toS = toS + " , " + elements.next();
        }
        toS = toS + " }";
        return toS;
    }

    public boolean add(Object object) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    public boolean remove(Object object) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    public boolean addAll(Collection collection) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    public void clear() {
        this.throwExceptionForAddRemoveOperation();
    }

    public boolean removeAll(Collection collection) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    public boolean retainAll(Collection collection) {
        this.throwExceptionForAddRemoveOperation();
        return false;
    }

    protected boolean addProtected(MascoptObject mascoptobject) {
        boolean retour = this.setOfObjects.add(mascoptobject);
        Object[] t = new Object[]{mascoptobject, this};
        this.notifyAddObservers(t);
        return retour;
    }

    protected boolean removeProtected(MascoptObject mascoptobject) {
        boolean retour = this.setOfObjects.remove(mascoptobject);
        Object[] t = new Object[]{mascoptobject, this};
        this.notifyRemoveObservers(t);
        return retour;
    }

    protected void clearProtected() {
        this.setOfObjects.clear();
    }

    protected void throwExceptionForAddRemoveOperation() throws MascoptAddRemoveSetException {
        throw new MascoptAddRemoveSetException();
    }

    public Element toDOMTree(Element element) {
        Element node_to_go = super.toDOMTree(element);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MascoptObject object = (MascoptObject)it.next();
            object.toDOMTreeAsRef(node_to_go);
        }
        if (this.isSubSet()) {
            this.getSuperSet().toDOMTreeAsRef(node_to_go);
        }
        return node_to_go;
    }

    public String getDOMTagHierarchy() {
        return "SETS";
    }

    public String getDOMTagName() {
        return "FIXED_SET";
    }

    static {
        initialCapacity = 16;
        loadFactor = 0.75f;
    }
}

