/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.abstractGraph;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import mascoptLib.abstractGraph.MascoptObjectInterface;
import mascoptLib.abstractGraph.MascoptWritableInterface;
import mascoptLib.util.ObservableObject;
import mascoptLib.util.Pair;
import mascoptLib.util.Trace;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class MascoptObject
extends ObservableObject
implements MascoptObjectInterface,
Cloneable,
Observer,
MascoptWritableInterface {
    private static int nbInstance = 0;
    protected String id;
    private Vector entries = new Vector(10, 10);
    private boolean notifyChange = true;

    public MascoptObject() {
        ++nbInstance;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        if (this.existValue("name")) {
            return this.getValue("name");
        }
        return this.getId();
    }

    public boolean setName(String name) {
        this.setValue("name", name);
        Trace.setNameObj(this.id, name);
        return true;
    }

    public boolean notifyOnValueChange(boolean notify) {
        boolean old = this.notifyChange;
        this.notifyChange = notify;
        return old;
    }

    public String getValue(String name) {
        return this.getValue(name, this);
    }

    public Double getDoubleValue(String name) {
        Object o = this.getObjectValue(name, this);
        Trace.println("Objet retourn? par getDoubleValue: " + o);
        if (o instanceof Double) {
            return (Double)o;
        }
        return null;
    }

    public double getDouValue(String name) {
        Double myDouble = this.getDoubleValue(name);
        return myDouble;
    }

    public Integer getIntegerValue(String name) {
        Object o = this.getObjectValue(name, this);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return null;
    }

    public int getIntValue(String name) {
        Integer myInteger = this.getIntegerValue(name);
        return myInteger;
    }

    public String getValueDataType(String name) {
        String retour = null;
        if (this.getObjectValue(name, this) instanceof String) {
            retour = "String";
        } else if (this.getObjectValue(name, this) instanceof Integer) {
            retour = "Integer";
        } else if (this.getObjectValue(name, this) instanceof Double) {
            retour = "Double";
        }
        return retour;
    }

    public String getValueDataType(String name, MascoptObjectInterface o) {
        String retour = null;
        if (this.getObjectValue(name, o) instanceof String) {
            retour = "String";
        } else if (this.getObjectValue(name, o) instanceof Integer) {
            retour = "Integer";
        } else if (this.getObjectValue(name, o) instanceof Double) {
            retour = "Double";
        }
        return retour;
    }

    public String getValue(String name, MascoptObjectInterface o) {
        Object object = this.getObjectValue(name, o);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Integer) {
            return ((Integer)object).toString();
        }
        if (object instanceof Double) {
            return ((Double)object).toString();
        }
        return null;
    }

    public Double getDoubleValue(String name, MascoptObjectInterface o) {
        Object object = this.getObjectValue(name, o);
        if (object instanceof Double) {
            return (Double)object;
        }
        return null;
    }

    public double getDouValue(String name, MascoptObjectInterface o) {
        Double myDouble = this.getDoubleValue(name, o);
        return myDouble;
    }

    public Integer getIntegerValue(String name, MascoptObjectInterface o) {
        Object object = this.getObjectValue(name, o);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return null;
    }

    public int getIntValue(String name, MascoptObjectInterface o) {
        Integer myInteger = this.getIntegerValue(name, o);
        return myInteger;
    }

    public void setValue(String name, String value) {
        this.setValue(name, (MascoptObjectInterface)this, value);
    }

    public void setValue(String name, Integer value) {
        this.setValue(name, (MascoptObjectInterface)this, value);
    }

    public void setValue(String name, Double value) {
        this.setValue(name, (MascoptObjectInterface)this, value);
    }

    public void setDoubleValue(String name, Double value) {
        this.setDoubleValue(name, this, value);
    }

    public void setDouValue(String name, double value) {
        this.setDoubleValue(name, this, new Double(value));
    }

    public void setIntegerValue(String name, Integer value) {
        this.setIntegerValue(name, this, value);
    }

    public void setIntValue(String name, int value) {
        this.setIntegerValue(name, this, new Integer(value));
    }

    public void setValue(String name, MascoptObjectInterface o, String value) {
        this.setObjectValue(name, o, value);
    }

    public void setValue(String name, MascoptObjectInterface o, Integer value) {
        this.setObjectValue(name, o, value);
    }

    public void setValue(String name, MascoptObjectInterface o, Double value) {
        this.setObjectValue(name, o, value);
    }

    public void setIntegerValue(String name, MascoptObjectInterface o, Integer value) {
        this.setObjectValue(name, o, value);
    }

    public void setIntValue(String name, MascoptObjectInterface o, int value) {
        this.setIntegerValue(name, o, new Integer(value));
    }

    public void setDoubleValue(String name, MascoptObjectInterface o, Double value) {
        this.setObjectValue(name, o, value);
    }

    public void setDouValue(String name, MascoptObjectInterface o, double value) {
        this.setObjectValue(name, o, new Double(value));
    }

    public boolean deleteValue(String name) {
        return this.deleteValue(name, this);
    }

    public boolean deleteValue(String name, MascoptObjectInterface o) {
        if (o == null || name == null) {
            return false;
        }
        Vector v = (Vector)this.find(name, this.entries);
        if (v == null) {
            return false;
        }
        if (!this.remove(o, v)) {
            return false;
        }
        if (this.notifyChange) {
            Object[] t = new Object[]{this, name};
            this.notifyValueObservers("value changed", t);
            if (v.size() == 0) {
                this.remove(name, this.entries);
            }
        }
        return true;
    }

    public Iterator getValueEntries() {
        Vector<Object> entryName = new Vector<Object>(this.entries.size());
        for (int i = 0; i < this.entries.size(); ++i) {
            entryName.add(((Pair)this.entries.elementAt((int)i)).key);
        }
        return entryName.iterator();
    }

    public Iterator getValueContexts(String name) {
        if (name == null) {
            return null;
        }
        Vector v = (Vector)this.find(name, this.entries);
        if (v == null) {
            return null;
        }
        Vector<Object> contextName = new Vector<Object>(this.entries.size());
        for (int i = 0; i < v.size(); ++i) {
            contextName.add(((Pair)v.elementAt((int)i)).key);
        }
        return contextName.iterator();
    }

    public void removeAllValues(MascoptObjectInterface context) {
        Iterator itName = this.entries.iterator();
        while (itName.hasNext()) {
            Pair p = (Pair)itName.next();
            Vector v = (Vector)p.getValue();
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                Pair p2 = (Pair)v.elementAt(i);
                if (context != p2.getKey()) continue;
                v.remove(i);
                --i;
                --size;
            }
            if (size != 0) continue;
            this.entries.remove(p);
        }
    }

    public static int countAllObjects() {
        return nbInstance;
    }

    public void free() {
    }

    public void copyValues(MascoptObject mascoptObject) {
        Iterator itV = mascoptObject.getValueEntries();
        while (itV.hasNext()) {
            String entry = (String)itV.next();
            if (!this.existValue(entry)) continue;
            if (mascoptObject.getValueDataType(entry).equalsIgnoreCase("String")) {
                if (entry.equalsIgnoreCase("NAME")) continue;
                this.setValue(entry, mascoptObject.getValue(entry));
                continue;
            }
            if (mascoptObject.getValueDataType(entry).equalsIgnoreCase("Integer")) {
                this.setIntegerValue(entry, mascoptObject.getIntegerValue(entry));
                continue;
            }
            this.setDoubleValue(entry, mascoptObject.getDoubleValue(entry));
        }
    }

    public boolean existValue(String name) {
        return this.existValue(name, this);
    }

    public boolean existValue(String name, MascoptObjectInterface o) {
        Vector found = (Vector)this.find(name, this.entries);
        if (found == null) {
            return false;
        }
        Object value = this.find(o, found);
        return value != null;
    }

    public Element toDOMTree(Element element) {
        StringTokenizer st = new StringTokenizer(this.getDOMTagHierarchy(), "/");
        Element current_element = element;
        while (st.hasMoreTokens()) {
            current_element = this.existOrCreateNodeWithoutId(st.nextToken(), current_element);
        }
        current_element = this.existOrCreateNodeWithId(this.getDOMTagName(), current_element, this.getId(), true, "id");
        return current_element;
    }

    private Element existOrCreateNodeWithoutId(String tag, Element fromHere) {
        Element new_node = null;
        NodeList nodes = fromHere.getElementsByTagName(tag);
        if (nodes.getLength() == 0) {
            new_node = fromHere.getOwnerDocument().createElement(tag);
            fromHere.appendChild(new_node);
        } else {
            new_node = (Element)nodes.item(0);
        }
        return new_node;
    }

    private Element existOrCreateNodeWithId(String tag, Element fromHere, String id, boolean withValues, String the_id) {
        Element new_node = null;
        NodeList nodes = fromHere.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element current_node = (Element)nodes.item(i);
                NamedNodeMap node_map_attributes = current_node.getAttributes();
                Node attribute = node_map_attributes.getNamedItem(the_id);
                if (!attribute.getNodeValue().equals(this.getId())) continue;
                new_node = current_node;
            }
        }
        if (new_node == null) {
            new_node = fromHere.getOwnerDocument().createElement(tag);
            fromHere.appendChild(new_node);
            new_node.setAttribute(the_id, this.getId());
            if (withValues) {
                this.writeValuesToDOMTree(new_node);
            }
        }
        return new_node;
    }

    public void toDOMTreeAsRef(Element element) {
        this.existOrCreateNodeWithId(this.getDOMTagName() + "_REF", element, this.getId(), false, "idref");
        this.toDOMTree(element.getOwnerDocument().getDocumentElement());
    }

    public abstract String getDOMTagHierarchy();

    public abstract String getDOMTagName();

    private void writeValuesToDOMTree(Element element) {
        Iterator it = this.getValueEntries();
        if (it != null) {
            while (it.hasNext()) {
                Iterator itCont;
                String entry = (String)it.next();
                if (entry.equals("id") || (itCont = this.getValueContexts(entry)) == null) continue;
                while (itCont.hasNext()) {
                    Element node_position;
                    MascoptObject context = (MascoptObject)itCont.next();
                    String dataType = this.getValueDataType(entry, context);
                    Element new_node = null;
                    if (entry.equals("x")) {
                        node_position = this.existOrCreateNodeWithoutId("POSITION", element);
                        element.appendChild(node_position);
                        new_node = element.getOwnerDocument().createElement("X");
                        node_position.appendChild(new_node);
                    } else if (entry.equals("y")) {
                        node_position = this.existOrCreateNodeWithoutId("POSITION", element);
                        element.appendChild(node_position);
                        new_node = element.getOwnerDocument().createElement("Y");
                        node_position.appendChild(new_node);
                    } else if (entry.equals("name")) {
                        new_node = element.getOwnerDocument().createElement("NAME");
                        element.appendChild(new_node);
                    } else {
                        new_node = element.getOwnerDocument().createElement("VALUE");
                        new_node.setAttribute("type", entry);
                        new_node.setAttribute("dataType", dataType);
                        element.appendChild(new_node);
                    }
                    Text text = element.getOwnerDocument().createTextNode(this.getValue(entry));
                    new_node.appendChild(text);
                    if (context == this) continue;
                    context.toDOMTreeAsRef(new_node);
                }
            }
        }
    }

    private void setObjectValue(String name, MascoptObjectInterface o, Object value) {
        Pair old;
        if (o == null || name == null || value == null) {
            return;
        }
        Vector<Pair> v = (Vector<Pair>)this.find(name, this.entries);
        if (v == null) {
            v = new Vector<Pair>(10, 10);
            this.entries.add(new Pair(name, v));
        }
        if ((old = this.getPair(o, v)) == null) {
            v.add(new Pair(o, value));
        } else {
            old.value = value;
        }
        if (this.notifyChange) {
            Object[] t = new Object[]{this, name};
            this.notifyValueObservers("value changed", t);
        }
    }

    private Object find(String key, Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)v.elementAt(i);
            if (!key.equals((String)p.getKey())) continue;
            return p.getValue();
        }
        return null;
    }

    private Object find(Object key, Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)v.elementAt(i);
            if (key != p.getKey()) continue;
            return p.getValue();
        }
        return null;
    }

    private Pair getPair(Object key, Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)v.elementAt(i);
            if (key != p.getKey()) continue;
            return p;
        }
        return null;
    }

    private boolean remove(Object key, Vector v) {
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            Pair p = (Pair)v.elementAt(i);
            if (key != p.getKey()) continue;
            v.remove(i);
            return true;
        }
        return false;
    }

    protected void finalize() {
        Trace.println("Object " + this.getName() + " (" + this.getId() + ") finalized.", Trace.MEMORY);
        Trace.finalizeObj(this.id);
        --nbInstance;
    }

    private Object getObjectValue(String name, MascoptObjectInterface o) {
        if (name == null) {
            return null;
        }
        Vector v = (Vector)this.find(name, this.entries);
        if (v == null) {
            return null;
        }
        Object value = this.find(o, v);
        if (value == null) {
            value = this.find(this, v);
        }
        return value;
    }

    public void update(Observable observable, Object object) {
    }
}

