/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.abstractalgos;

import java.util.HashMap;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.algos.abstractalgos.StepAlgo;
import mascoptLib.util.Trace;

public class AutoArrangeGraphs
extends StepAlgo {
    AbstractGraph ag;
    double l = 100.0;
    double t = 1.0;
    double m = 2.0;
    int maxstep = 2000;
    double shift = 10000.0;
    double variation = 1000.0;
    int step = 0;
    HashMap D;

    public AutoArrangeGraphs(AbstractGraph g) {
        super(true);
        this.ag = g;
        this.D = new HashMap();
        Iterator it = this.ag.getAbstractVertexSet().iterator();
        while (it.hasNext()) {
            AbstractVertex node = (AbstractVertex)it.next();
            this.D.put(node, new Vecteur());
        }
        this.start();
    }

    public void run() {
        Vecteur currentFa = new Vecteur();
        Vecteur currentFr = new Vecteur();
        AbstractVertexSet ans = this.ag.getAbstractVertexSet();
        while (this.variation > 1.0E-4 && this.step < this.maxstep) {
            ++this.step;
            this.variation = 0.0;
            Trace.startTime(0);
            Iterator it = ans.iterator();
            while (it.hasNext()) {
                AbstractVertex node = (AbstractVertex)it.next();
                double nodeX = node.getX();
                double nodeY = node.getY();
                currentFa.init();
                Iterator neighbIt = node.getNeighbours(this.ag).iterator();
                while (neighbIt.hasNext()) {
                    AbstractVertex theNeighb = (AbstractVertex)neighbIt.next();
                    if (node == theNeighb) continue;
                    currentFa.add(-1.0 / (this.l * this.l * this.l) * (nodeX - theNeighb.getX()), -1.0 / (this.l * this.l * this.l) * (nodeY - theNeighb.getY()));
                }
                currentFr.init();
                Iterator allNodeIt = ans.iterator();
                while (allNodeIt.hasNext()) {
                    AbstractVertex nodeTmp = (AbstractVertex)allNodeIt.next();
                    if (nodeTmp == node) continue;
                    double dist = this.d(node, nodeTmp);
                    if (dist == 0.0) {
                        nodeTmp.setX(nodeTmp.getX() + 1.0);
                        nodeTmp.setY(nodeTmp.getY() + 1.0);
                        dist = this.d(node, nodeTmp);
                    }
                    double distCube = dist * dist * dist;
                    currentFr.add((nodeX - nodeTmp.getX()) / distCube, (nodeY - nodeTmp.getY()) / distCube);
                }
                Vecteur dV = (Vecteur)this.D.get(node);
                dV.x = dV.x / this.m + (currentFr.x + currentFa.x) * this.shift;
                dV.y = dV.y / this.m + (currentFr.y + currentFa.y) * this.shift;
                this.variation += dV.norme();
            }
            Iterator itN = ans.iterator();
            while (itN.hasNext()) {
                AbstractVertex node = (AbstractVertex)itN.next();
                Vecteur dV = (Vecteur)this.D.get(node);
                double xx = node.getX();
                double yy = node.getY();
                node.setX(xx += dV.x);
                node.setY(yy += dV.y);
            }
        }
        this.ends(true);
    }

    private double d(AbstractVertex n1, AbstractVertex n2) {
        return Math.sqrt((n1.getX() - n2.getX()) * (n1.getX() - n2.getX()) + (n1.getY() - n2.getY()) * (n1.getY() - n2.getY()));
    }

    class Vecteur {
        double x;
        double y;

        public Vecteur() {
            this(0.0, 0.0);
        }

        public Vecteur(double xx, double yy) {
            this.x = xx;
            this.y = yy;
        }

        public void init() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public void add(double xx, double yy) {
            this.x += xx;
            this.y += yy;
        }

        public double norme() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }
    }
}

