/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.abstractalgos;

import java.awt.Color;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.AbstractVertexSet;
import mascoptLib.abstractGraph.MascoptObjectInterface;
import mascoptLib.algos.abstractalgos.StepAlgo;

public class Dijkstra
extends StepAlgo {
    static final int DISTANCE_MAX = Integer.MAX_VALUE;
    private AbstractGraph g_;
    private Hashtable distance_;
    private Hashtable parcours_;
    private AbstractVertex start_;
    private boolean init_;
    private boolean demo_;
    private boolean thread_;
    public String DIJKSTRADISTANCE = "distanceDijkstra";

    public Dijkstra(AbstractGraph g) {
        super(false);
        this.g_ = g;
        this.parcours_ = new Hashtable();
        this.distance_ = new Hashtable();
        this.init_ = false;
        this.demo_ = false;
    }

    public void valuateFromSource(AbstractVertex u) {
        this.start_ = u;
        if (this.demo_) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public void slowAlgorithm(boolean slow) {
        this.demo_ = slow;
        this.byStep(slow);
    }

    public void run() {
        this.init_ = true;
        if (this.demo_) {
            this.waitB();
        }
        AbstractVertexSet c = this.g_.getFactory().newAbstractVertexSet(this.g_.getAbstractVertexSet());
        c.addAll((Collection)this.g_.getAbstractVertexSet());
        c.remove(this.start_);
        AbstractVertexSet d = this.g_.getFactory().newAbstractVertexSet();
        this.parcours_.clear();
        this.distance_.clear();
        Iterator itC = this.g_.getAbstractVertexSet().iterator();
        while (itC.hasNext()) {
            AbstractVertex currentNode = (AbstractVertex)itC.next();
            this.parcours_.put(currentNode, this.start_);
            if (this.start_.getNeighbours(this.g_).contains(currentNode)) {
                this.distance_.put(currentNode, new Integer(1));
                currentNode.setValue(this.DIJKSTRADISTANCE, (MascoptObjectInterface)this.g_, "" + new Integer(1));
                continue;
            }
            this.distance_.put(currentNode, new Integer(Integer.MAX_VALUE));
            currentNode.setValue(this.DIJKSTRADISTANCE, (MascoptObjectInterface)this.g_, "" + new Integer(Integer.MAX_VALUE));
        }
        this.distance_.put(this.start_, new Integer(0));
        this.start_.setValue(this.DIJKSTRADISTANCE, (MascoptObjectInterface)this.g_, "" + new Integer(0));
        while (!c.isEmpty()) {
            itC = c.iterator();
            AbstractVertex minNode = null;
            int minDistance = Integer.MAX_VALUE;
            while (itC.hasNext()) {
                AbstractVertex currentNode = (AbstractVertex)itC.next();
                if (minNode != null && (Integer)this.distance_.get(currentNode) >= minDistance) continue;
                minNode = currentNode;
                minDistance = (Integer)this.distance_.get(currentNode);
            }
            c.remove(minNode);
            d.add(minNode);
            Iterator itMAJ = minNode.getNeighbours(this.g_).iterator();
            while (itMAJ.hasNext()) {
                AbstractVertex currentNode2 = (AbstractVertex)itMAJ.next();
                if ((Integer)this.distance_.get(minNode) + 1 >= (Integer)this.distance_.get(currentNode2)) continue;
                this.distance_.put(currentNode2, new Integer((Integer)this.distance_.get(minNode) + 1));
                currentNode2.setValue(this.DIJKSTRADISTANCE, (MascoptObjectInterface)this.g_, "" + (Integer)this.distance_.get(currentNode2));
                this.parcours_.put(currentNode2, minNode);
            }
            if (!this.demo_) continue;
            minNode.setValue("color", (MascoptObjectInterface)this.g_, "" + Color.green.getRGB());
            this.waitB();
        }
        this.ends(true);
        c.free();
    }

    public Hashtable getDistances() {
        if (this.init_) {
            return this.distance_;
        }
        return null;
    }

    public int getDistanceTo(AbstractVertex v) {
        if (this.init_) {
            return (Integer)this.distance_.get(v);
        }
        return -1;
    }

    public AbstractPath getShortestPathTo(AbstractVertex v) {
        if (v == this.start_ || !this.init_ || (Integer)this.distance_.get(v) == Integer.MAX_VALUE) {
            return null;
        }
        AbstractPath machaine = this.g_.getFactory().newAbstractPath(this.g_.getAbstractEdgeSet());
        AbstractVertex rendu = v;
        while (rendu != this.start_) {
            AbstractVertex prec = (AbstractVertex)this.parcours_.get(rendu);
            Iterator la_bonne_edge_it = prec.getOutgoing(this.g_.getAbstractEdgeSet()).iterator();
            AbstractEdge la_bonne_edge = null;
            while (la_bonne_edge_it.hasNext() && !(la_bonne_edge = (AbstractEdge)la_bonne_edge_it.next()).leadsTo(rendu)) {
            }
            if (!machaine.concatAbstractEdge(la_bonne_edge)) {
                System.err.println("Error in Dijkstra: cannot add edge " + la_bonne_edge + " to chain " + machaine);
            }
            rendu = prec;
        }
        machaine.setName("Chaine calcul?e par Dijkstra: node " + this.start_ + " -> " + v);
        return machaine;
    }

    public AbstractVertex getStartNode() {
        return this.start_;
    }
}

