/*
 * Decompiled with CFR 0.152.
 */
package mascoptLib.algos.abstractalgos;

import java.awt.Color;
import java.util.Hashtable;
import java.util.Iterator;
import mascoptLib.abstractGraph.AbstractEdge;
import mascoptLib.abstractGraph.AbstractGraph;
import mascoptLib.abstractGraph.AbstractPath;
import mascoptLib.abstractGraph.AbstractVertex;
import mascoptLib.abstractGraph.MascoptFixedSet;
import mascoptLib.abstractGraph.MascoptObjectInterface;
import mascoptLib.algos.abstractalgos.StepAlgo;
import mascoptLib.util.fibHeap.FibonacciHeap;
import mascoptLib.util.fibHeap.Underflow;

public class DijkstraAdvanced
extends StepAlgo {
    static final double DISTANCE_MAX = Double.MAX_VALUE;
    private AbstractGraph g_;
    private Hashtable parcours_;
    private AbstractVertex start_;
    private boolean init_;
    private String nameOfValue_;
    private boolean demo_;
    private boolean thread_;
    public static final String DIJKSTRADISTANCE = "distanceDijkstra";

    public DijkstraAdvanced(AbstractGraph g, String nameOfValue) {
        super(false);
        this.g_ = g;
        this.parcours_ = new Hashtable();
        this.init_ = false;
        this.demo_ = false;
        this.nameOfValue_ = nameOfValue;
    }

    public void valuateFromSource(AbstractVertex u) {
        this.start_ = u;
        if (this.demo_) {
            new Thread(this).start();
        } else {
            this.run();
        }
    }

    public void slowAlgorithm(boolean slow) {
        this.demo_ = slow;
        this.byStep(slow);
    }

    public void run() {
        this.init_ = true;
        if (this.demo_) {
            this.waitB();
        }
        FibonacciHeap c = new FibonacciHeap(this.g_);
        this.parcours_.clear();
        Iterator itC = this.g_.getAbstractVertexSet().iterator();
        this.start_.setDoubleValue(DIJKSTRADISTANCE, this.g_, new Double(0.0));
        while (itC.hasNext()) {
            AbstractVertex currentNode = (AbstractVertex)itC.next();
            this.parcours_.put(currentNode, this.start_);
            if (currentNode != this.start_) {
                currentNode.setDoubleValue(DIJKSTRADISTANCE, this.g_, new Double(Double.MAX_VALUE));
            }
            if (!this.start_.getNeighbours(this.g_).contains(currentNode)) continue;
            MascoptFixedSet conduce = this.start_.getEdgesTo(this.g_, currentNode);
            Iterator itEdge = conduce.iterator();
            while (itEdge.hasNext()) {
                AbstractEdge ae = (AbstractEdge)itEdge.next();
                if (currentNode.getDoubleValue(DIJKSTRADISTANCE, this.g_) == null || Double.compare(currentNode.getDoubleValue(DIJKSTRADISTANCE, this.g_), ae.getDoubleValue(this.nameOfValue_, this.g_)) <= 0) continue;
                currentNode.setDoubleValue(DIJKSTRADISTANCE, this.g_, new Double(ae.getDoubleValue(this.nameOfValue_, this.g_)));
            }
        }
        Iterator itNodes = this.g_.getAbstractVertexSet().iterator();
        while (itNodes.hasNext()) {
            AbstractVertex n = (AbstractVertex)itNodes.next();
            if (n == this.start_) continue;
            Integer index = new Integer(c.insert(n));
            n.setIntegerValue("FibonacciIndex", index);
        }
        while (!c.isEmpty()) {
            AbstractVertex minNode = null;
            try {
                minNode = (AbstractVertex)c.findMin();
                c.deleteMin();
            }
            catch (Underflow u) {
                System.out.println("Erreur: underflow returned by FibonacciHeap.");
            }
            Iterator itMAJ = minNode.getOutgoing(this.g_).iterator();
            while (itMAJ.hasNext()) {
                AbstractEdge currentEdge2 = (AbstractEdge)itMAJ.next();
                AbstractVertex currentNode2 = minNode.getConnected(currentEdge2);
                if (minNode.getDoubleValue(DIJKSTRADISTANCE, this.g_) + currentEdge2.getDoubleValue(this.nameOfValue_, this.g_) < currentNode2.getDoubleValue(DIJKSTRADISTANCE, this.g_)) {
                    currentNode2.setDoubleValue(DIJKSTRADISTANCE, this.g_, new Double(minNode.getDoubleValue(DIJKSTRADISTANCE, this.g_) + currentEdge2.getDoubleValue(this.nameOfValue_, this.g_)));
                    this.parcours_.put(currentNode2, minNode);
                    try {
                        c.FibHeapDecreaseKey(c.getNode(currentNode2.getIntegerValue("FibonacciIndex")), currentNode2);
                    }
                    catch (Underflow u) {
                        System.out.println("Erreur: underflow returned by FibonacciHeap.");
                    }
                }
                if (!this.demo_) continue;
                minNode.setValue("color", (MascoptObjectInterface)this.g_, "" + Color.green.getRGB());
                this.waitB();
            }
            this.ends(true);
        }
    }

    public Double getDistanceTo(AbstractVertex v) {
        if (this.init_) {
            return v.getDoubleValue(DIJKSTRADISTANCE, this.g_);
        }
        return new Double(-1.0);
    }

    public AbstractPath getShortestPathTo(AbstractVertex v) {
        if (v == this.start_ || !this.init_ || v.getDoubleValue(DIJKSTRADISTANCE, this.g_) == Double.MAX_VALUE) {
            return null;
        }
        AbstractPath machaine = this.g_.getFactory().newAbstractPath(this.g_.getAbstractEdgeSet());
        AbstractVertex rendu = v;
        while (rendu != this.start_) {
            AbstractVertex prec = (AbstractVertex)this.parcours_.get(rendu);
            Iterator la_bonne_edge_it = prec.getOutgoing(this.g_.getAbstractEdgeSet()).iterator();
            AbstractEdge la_bonne_edge = null;
            while (la_bonne_edge_it.hasNext() && !(la_bonne_edge = (AbstractEdge)la_bonne_edge_it.next()).leadsTo(rendu)) {
            }
            machaine.concatAbstractEdge(la_bonne_edge);
            rendu = prec;
        }
        machaine.setName("Chaine calcul?e par Dijkstra: node " + this.start_ + " -> " + v);
        return machaine;
    }

    public AbstractVertex getStartNode() {
        return this.start_;
    }
}

